/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import jp.ossc.nimbus.core.*;

/**
 * {@link DatabaseAuthenticateStoreService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DatabaseAuthenticateStoreService
 */
public interface DatabaseAuthenticateStoreServiceMBean extends ServiceBaseMBean{
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[F؏܂͔F؃L[̃L[B<p>
     */
    public static final String INPUT_KEY_AUTH = "Auth";
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[HTTPZbVID̃L[B<p>
     */
    public static final String INPUT_KEY_HTTP_SESSION_ID = "SessionId";
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[^CX^ṽL[B<p>
     */
    public static final String INPUT_KEY_TIMESTAMP = "Timestamp";
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[zXg̃L[B<p>
     */
    public static final String INPUT_KEY_HOST = "Host";
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rXݒ肷B<p>
     *
     * @param name PersistentManagerT[rX̃T[rX
     */
    public void setPersistentManagerServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rX擾B<p>
     *
     * @return PersistentManagerT[rX̃T[rX
     */
    public ServiceName getPersistentManagerServiceName();
    
    /**
     * f[^x[X畜F؏̃NXIuWFNgݒ肷B<p>
     *
     * @param clazz F؏̃NXIuWFNg
     */
    public void setAuthenticatedInfoClass(Class<?> clazz);
    
    /**
     * f[^x[X畜F؏̃NXIuWFNg擾B<p>
     *
     * @return F؏̃NXIuWFNg
     */
    public Class<?> getAuthenticatedInfoClass();
    
    /**
     * f[^x[X畜F؏̃IuWFNgݒ肷B<p>
     * ̃IuWFNǵACloneablepublicclone()\bhKvB<br>
     *
     * @param template F؏̃IuWFNg
     */
    public void setAuthenticatedInfoTemplate(Object template);
    
    /**
     * f[^x[X畜F؏̃IuWFNg擾B<p>
     *
     * @return F؏̃IuWFNg
     */
    public Object getAuthenticatedInfoTemplate();
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[zXgݒ肷B<p>
     * ݒ肵ȂꍇAIɃ[JzXg̃zXggpB<br>
     * 
     * @param name zXg
     */
    public void setHostName(String name);
    
    /**
     * PersistentManagerւ̓̓IuWFNgł}bvɊi[zXg擾B<p>
     * 
     * @param name zXg
     */
    public String getHostName();
    
    /**
     * F؏𐶐ėǂNGݒ肷B<p>
     *
     * @param query NG
     */
    public void setSelectQueryOnCreateUser(String query);
    
    /**
     * F؏𐶐ėǂNG擾B<p>
     *
     * @return NG
     */
    public String getSelectQueryOnCreateUser();
    
    /**
     * F؏NGݒ肷B<p>
     *
     * @param query NG
     */
    public void setSelectQueryOnFindUser(String query);
    
    /**
     * F؏NG擾B<p>
     *
     * @return NG
     */
    public String getSelectQueryOnFindUser();
    
    /**
     * F؏}NGݒ肷B<p>
     *
     * @param query NG
     */
    public void setInsertQuery(String query);
    
    /**
     * F؏}NG擾B<p>
     *
     * @return NG
     */
    public String getInsertQuery();
    
    /**
     * F؏XgAۂɁAɊYF؏񂪑݂ꍇɁAF؏XVNGݒ肷B<p>
     *
     * @param query NG
     */
    public void setUpdateQueryOnCreate(String query);
    
    /**
     * F؏XgAۂɁAɊYF؏񂪑݂ꍇɁAF؏XVNG擾B<p>
     *
     * @return NG
     */
    public String getUpdateQueryOnCreate();
    
    /**
     * F؏𕜌ۂɁAF؏XVNGݒ肷B<p>
     *
     * @param query NG
     */
    public void setUpdateQueryOnActivate(String query);
    
    /**
     * F؏𕜌ۂɁAF؏XVNG擾B<p>
     *
     * @return NG
     */
    public String getUpdateQueryOnActivate();
    
    /**
     * F؏񊈐ۂɁAF؏XVNGݒ肷B<p>
     *
     * @param query NG
     */
    public void setUpdateQueryOnDeactivate(String query);
    
    /**
     * F؏񊈐ۂɁAF؏XVNG擾B<p>
     *
     * @return NG
     */
    public String getUpdateQueryOnDeactivate();
    
    /**
     * F؏폜NGݒ肷B<p>
     *
     * @param query NG
     */
    public void setDeleteQuery(String query);
    
    /**
     * F؏폜NG擾B<p>
     *
     * @return NG
     */
    public String getDeleteQuery();
}