/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

import jp.ossc.nimbus.core.*;

/**
 * {@link ClientBeanFlowFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ClientBeanFlowFactoryService
 */
public interface ClientBeanFlowFactoryServiceMBean extends ServiceBaseMBean{
    
    public static final String MSG_ID_ASYNCH_INVOKE_ERROR = "CBFI_00001";
    
    /**
     * {@link ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * {@link BeanFlowServer}NX^T[rX̃o[񂩂擾B<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * {@link BeanFlowServer#invokeFlow(Object, Object, Map)}̑RɎw肷ReLXg擾{@link jp.ossc.nimbus.service.context.Context Context}̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link BeanFlowServer#invokeFlow(Object, Object, Map)}̑RɎw肷ReLXg擾{@link jp.ossc.nimbus.service.context.Context Context}̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link BeanFlowServer#invokeFlow(Object, Object, Map)}̑RɎw肷ReLXg̃L[ݒ肷B<p>
     * w肵Ȃꍇ́ASẴReLXgnB<br>
     *
     * @param keys ReLXg̃L[
     */
    public void setContextKeys(String[] keys);
    
    /**
     * {@link BeanFlowServer#invokeFlow(Object, Object, Map)}̑RɎw肷ReLXg̃L[擾B<p>
     *
     * @return ReLXg̃L[
     */
    public String[] getContextKeys();
    
    /**
     * {@link jp.ossc.nimbus.service.queue.QueueHandlerContainer QueueHandlerContainer}T[rX̃T[rXݒ肷B<p>
     *
     * @param name QueueHandlerContainerT[rX̃T[rX
     */
    public void setAsynchInvokeQueueHandlerContainerServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.queue.QueueHandlerContainer QueueHandlerContainer}T[rX̃T[rX擾B<p>
     *
     * @return QueueHandlerContainerT[rX̃T[rX
     */
    public ServiceName getAsynchInvokeQueueHandlerContainerServiceName();
    
    /**
     * 񓯊s̗vɎsꍇɏo͂郍ObZ[WIDݒ肷B<br>
     * ftHǵA{@link #MSG_ID_ASYNCH_INVOKE_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setAsynchInvokeErrorMessageId(String id);
    
    /**
     * 񓯊s̗vɎsꍇɏo͂郍ObZ[WID擾B<br>
     *
     * @return ObZ[WID
     */
    public String getAsynchInvokeErrorMessageId();
}
