/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.io.File;
import java.util.Date;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link FileConcentrateBackupManagerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface FileConcentrateBackupManagerServiceMBean extends ServiceBaseMBean{
    
    /**
     * ftHg̓tfBNgtH[}bgB<p>
     */
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    
    /**
     * k[hF񈳏kB<p>
     */
    public static final int COMPRESS_MODE_NONE = 0;
    
    /**
     * k[hFZLIB`B<p>
     */
    public static final int COMPRESS_MODE_ZLIB = 1;
    
    /**
     * k[hFZIP`B<p>
     */
    public static final int COMPRESS_MODE_ZIP = 2;
    
    /**
     * k[hFGZIP`B<p>
     */
    public static final int COMPRESS_MODE_GZIP = 3;
    
    /**
     * tfBNg̃tH[}bgݒ肷B<p>
     * ftHǵA{@link #DEFAULT_DATE_FORMAT}B<br>
     * 
     * @param format tH[}bg
     */
    public void setDateFormat(String format);
    
    /**
     * tfBNg̃tH[}bg擾B<p>
     * 
     * @return tH[}bg
     */
    public String getDateFormat();
    
    /**
     * obNAbvfBNgݒ肷B<p>
     * ftHǵA"backup"B<br>
     *
     * @param dir obNAbvfBNg
     */
    public void setBackupDirectory(File dir);
    
    /**
     * obNAbvfBNg擾B<p>
     *
     * @return obNAbvfBNg
     */
    public File getBackupDirectory();
    
    /**
     * obNAbv̓ǂݍ݃Xg[̃obt@TCYݒ肷B<p>
     * ftHǵA1024B<br>
     *
     * @param size obt@TCY
     */
    public void setBufferSize(int size);
    
    /**
     * obNAbv̓ǂݍ݃Xg[̃obt@TCY擾B<p>
     *
     * @return obt@TCY
     */
    public int getBufferSize();
    
    /**
     * k[hݒ肷B<p>
     * ftHǵA{@link #COMPRESS_MODE_NONE 񈳏k}B<br>
     * 
     * @param mode k[h
     * @see #COMPRESS_MODE_NONE
     * @see #COMPRESS_MODE_ZLIB
     * @see #COMPRESS_MODE_ZIP
     * @see #COMPRESS_MODE_GZIP
     */
    public void setCompressMode(int mode);
    
    /**
     * k[h擾B<p>
     * 
     * @return k[h
     */
    public int getCompressMode();
    
    /**
     * kxݒ肷B<p>
     * ftHǵA{@link java.util.zip.Deflater#DEFAULT_COMPRESSION}B<br>
     * k[hA{@link #COMPRESS_MODE_ZLIB}A{@link #COMPRESS_MODE_ZIP}̏ꍇALB<br>
     * 
     * @param level kx
     */
    public void setCompressLevel(int level);
    
    /**
     * kx擾B<p>
     * 
     * @return kx
     */
    public int getCompressLevel();
    
    /**
     * k\bhݒ肷B<p>
     * ftHǵA{@link java.util.zip.ZipOutputStream#DEFLATED}B<br>
     * k[hA{@link #COMPRESS_MODE_ZIP}̏ꍇ̂݁ALB<br>
     * 
     * @param method k\bh
     */
    public void setCompressMethod(int method);
    
    /**
     * k\bh擾B<p>
     * 
     * @return k\bh
     */
    public int getCompressMethod();
    
    /**
     * obNAbvSč폜B<p>
     *
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean clear() throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[ṽobNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvt̃obNAbvSč폜B<p>
     *
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vobNAbvt̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group, Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvt܂ł̃obNAbvSč폜B<p>
     *
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean removeTo(Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vobNAbvt܂ł̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean removeTo(String group, Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vAobNAbvtAobNAbvL[̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @param key obNAbvL[
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group, Date date, String key) throws ConcentrateBackupException;
}