/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import jp.ossc.nimbus.core.*;

/**
 * ȈՃJeST[rXB<p>
 * o͐𕪗ނJeST[rX̊ȈՎNXB<br>
 * w肳ꂽo͗vfAݒ肳ꂽ{@link WritableRecordFactory}{@link WritableRecord}ɕϊāAݒ肳ꂽ{@link MessageWriter}ɏo͂˗B<br>
 *
 * @author M.Takata
 */
public class SimpleCategoryService extends ServiceBase
 implements SimpleCategoryServiceMBean{
    
    private static final long serialVersionUID = 1601430582489560068L;
    
    /**
     * ̃JeSLǂ̃tOB<p>
     * LȏꍇAtrue
     */
    protected boolean isEnabled = true;
    
    /**
     * ̃JeS̏o͐ƂȂMessageWriter̃T[rXB<p>
     */
    protected ServiceName writerName;
    
    /**
     * ̃JeS̏o͐ƂȂMessageWriterIuWFNgB<p>
     */
    protected MessageWriter writer;
    
    /**
     * ̃JeS̏o̓tH[}bg߂WritableRecordFactorỹT[rXB<p>
     */
    protected ServiceName recordFactoryName;
    
    /**
     * ̃JeS̏o̓tH[}bg߂WritableRecordFactoryIuWFNgB<p>
     */
    protected WritableRecordFactory recordFactory;
    
    // SimpleCategoryServiceMBeanJavaDoc
    public void setMessageWriterServiceName(ServiceName name){
        writerName = name;
    }
    
    // SimpleCategoryServiceMBeanJavaDoc
    public ServiceName getMessageWriterServiceName(){
        return writerName;
    }
    
    // SimpleCategoryServiceMBeanJavaDoc
    public void setWritableRecordFactoryServiceName(ServiceName name){
        recordFactoryName = name;
    }
    
    // SimpleCategoryServiceMBeanJavaDoc
    public ServiceName getWritableRecordFactoryServiceName(){
        return recordFactoryName;
    }
    
    /**
     * ̃JeS̏o͂sMessageWriterT[rXݒ肷B<p>
     *
     * @param writer ̃JeS̏o͂sMessageWriterT[rX
     */
    public void setMessageWriterService(MessageWriter writer){
        this.writer = writer;
    }
    
    /**
     * ̃JeS̏o͂sMessageWriterT[rX擾B<p>
     *
     * @return ̃JeS̏o͂sMessageWriterT[rX
     */
    public MessageWriter getMessageWriterService(){
        return this.writer;
    }
    
    /**
     * ̃JeS̏o̓tH[}bg߂WritableRecordFactoryT[rXݒ肷B<p>
     *
     * @param factory ̃JeS̏o̓tH[}bg߂WritableRecordFactoryT[rX
     */
    public void setWritableRecordFactoryService(WritableRecordFactory factory){
        recordFactory = factory;
    }
    
    /**
     * ̃JeS̏o̓tH[}bg߂WritableRecordFactoryT[rX擾B<p>
     *
     * @return ̃JeS̏o̓tH[}bg߂WritableRecordFactoryT[rX
     */
    public WritableRecordFactory getWritableRecordFactoryService(){
        return recordFactory;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(writerName != null){
            writer = (MessageWriter)ServiceManagerFactory
                .getServiceObject(writerName);
        }
        if(recordFactoryName != null){
            recordFactory = (WritableRecordFactory)ServiceManagerFactory
                .getServiceObject(recordFactoryName);
        }
    }
    
    // CategoryJavaDoc
    public boolean isEnabled(){
        return isEnabled;
    }
    
    // CategoryJavaDoc
    public void setEnabled(boolean enable){
        isEnabled = enable;
    }
    
    // CategoryJavaDoc
    public void write(Object elements) throws MessageWriteException{
        if(!isEnabled()){
            return;
        }
        writer.write(recordFactory.createRecord(elements));
    }
}
