/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import java.util.*;

/**
 * {@link SimpleLogCategoryService}T[rXMBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface SimpleLogCategoryServiceMBean
 extends LogCategory, SimpleCategoryServiceMBean{
    
    /**
     * JeSݒ肷B<p>
     *
     * @param name JeS
     */
    public void setCategoryName(String name);
    
    /**
     * ̃JeSŏo͂郍O̗D揇ʔ͈͂ݒ肷B<p>
     *
     * @param range D揇ʔ͈́Bŏl:ől̏Ŏw肷B
     * @exception IllegalArgumentException D揇ʔ͈͂̎w肪sȏꍇB
     */
    public void setPriorityRange(String range) throws IllegalArgumentException;
    
    /**
     * ̃JeSŏo͂郍O̗D揇ʔ͈͂擾B<p>
     *
     * @return D揇ʔ͈
     */
    public String getPriorityRange();
    
    /**
     * O̗D揇ʂɑΉ郉xݒ肷B<p>
     * labelsɂ́Aȉ̃}bsOݒ肷B<br>
     * <table border="1">
     *   <tr bgcolor="#CCCCFF"><th colspan="2">L[</th><th colspan="2">l</th></tr>
     *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
     *   <tr><td>String</td><td>D揇ʔ͈́Bŏl:ől̏Ŏw肷B</td><td>String</td><td>x</td></tr>
     * </table>
     *
     * @param labels O̗D揇ʂɑΉ郉x̃}bsO
     * @exception IllegalArgumentException D揇ʔ͈͂̎w肪sȏꍇB
     */
    public void setLabels(Properties labels) throws IllegalArgumentException;
    
    /**
     * O̗D揇ʂɑΉ郉x擾B<p>
     *
     * @return O̗D揇ʂɑΉ郉x̃}bsO
     */
    public Properties getLabels();
}
