# -*- coding: utf-8 -*-
#
#  kawari8.py - a (Real) 華和梨 loader for ninix
#  Copyright (C) 2002, 2003 by ABE Hideaki <abe-xx@eos.dricas.com>
#  Copyright (C) 2002-2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys
import logging

try:
    import _kawari8
except:
    _kawari8 = None


class Shiori:

    saori_list = {}

    def __init__(self, dll_name):
        self.dll_name = dll_name
        self.handle = 0

    def use_saori(self, saori):
        self.saori = saori

    def find(self, topdir, dll_name):
        result = 0
        if _kawari8 and os.path.isfile(os.path.join(topdir, b'kawarirc.kis')):
            result = 205
        return result

    def show_description(self):
        logging.info(
            'Shiori: Real Kawari8 loader for ninix\n'
            '        Copyright (C) 2002, 2003 by ABE Hideaki\n'
            '        Copyright (C) 2002-2012 by Shyouzou Sugitani\n'
            '        Copyright (C) 2002, 2003 by MATSUMURA Namihiko')

    def load(self, topdir):
        self.dir = topdir
        if _kawari8:
            ##reload(_kawari8)
            if self.dir.endswith(os.fsencode(os.sep)):
                topdir = self.dir
            else:
                topdir = b''.join((self.dir, os.fsencode(os.sep)))
            _kawari8.setcallback(self.saori_exist,
                                 Shiori.saori_load,
                                 Shiori.saori_unload,
                                 Shiori.saori_request)
            result = _kawari8.load(topdir)
            self.handle = result
            return 1 if result != 0 else 0
        else:
            return 0

    def unload(self):
        if _kawari8:
            _kawari8.unload(self.handle)
            for name in list(Shiori.saori_list.keys()):
                if not name.startswith(os.fsdecode(self.dir)):
                    continue
                if self.saori_list[name][1]:
                    self.saori_list[name][0].unload()
                del self.saori_list[name]
            # XXX
            _kawari8.setcallback(lambda *a: 0, # dummy
                                 Shiori.saori_load,
                                 Shiori.saori_unload,
                                 Shiori.saori_request)

    def request(self, req_string):
        if _kawari8:
            return _kawari8.request(self.handle, req_string)
        else:
            return '' # FIXME

    def saori_exist(self, saori):
        module = self.saori.request(saori)
        if module:
            Shiori.saori_list[saori] = [module, 0]
            return len(Shiori.saori_list)
        else:
            return 0

    @classmethod
    def saori_load(cls, saori, path):
        result = 0
        if saori in cls.saori_list and cls.saori_list[saori][1] == 0:
            result = cls.saori_list[saori][0].load(path)
            cls.saori_list[saori][1] = result
        return result

    @classmethod
    def saori_unload(cls, saori):
        result = 0
        if saori in cls.saori_list and cls.saori_list[saori][1] != 0:
            result = cls.saori_list[saori][0].unload()
            cls.saori_list[saori][1] = 0
        return result

    @classmethod
    def saori_request(cls, saori, req):
        result = b'SAORI/1.0 500 Internal Server Error'
        if saori in cls.saori_list:
            if cls.saori_list[saori][1] == 0:
                head, tail = os.path.split(os.fsencode(saori))
                cls.saori_list[saori][1] = cls.saori_list[saori][0].load(head)
            if cls.saori_list[saori][1]:
                result = cls.saori_list[saori][0].request(req)
        return result
