#include "json.h"
#include <string.h>
#include <Windows.h>

typedef char JSONText;


#define wcharToHex(c,defaulterr) ((((c) >= L'0') & ((c) <= L'9')) ? (c) - L'0' : ((((c) >= L'a') & ((c) <= L'f')) ? (((c) - L'a') + 10) : ((((c) >= L'A') &((c) <= L'F')) ? (((c) - L'A') + 10) : (defaulterr))))
///
///jsonp[TIuWFNg
///
typedef struct jsonparser_t{


	JSONChar_P value;								//lێp̈

	JSONUInt valueSize;								//TCY

	JSONStructEventHandler structHandler;			//\̃Cxgnh

	JSONDataEventHandler dataHandler;					//\̃f[^Cxgnh

	JSONStructEndEventHandler dataEndHandler;			//\̏I[Cxgnh

	JSONVoid *option;									//IvV




}JSONParser;

typedef struct {

	JSONChar buffer[32];								//ftHg̃obt@

	JSONBool heapFlag;									//q[v̈gpĂ邩̃tO

	JSONChar_P heapBuf;									//q[v̈p|C^

}JSONStringAllocator,*JSONStringAllocator_P;


//
//ftHg̃Cxgnh
//

static JSONVoid defaultStructEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt valueType,JSONChar_P name);

static JSONVoid defaultDataEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt valueType,JSONChar_P name,JSONParameter parameter);

static JSONVoid defaultDataEndEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt endStructreType,JSONChar_P name);




//
//vCx[g֐
//

///
///jsontextutf8ł
///
static JSONResult JSONParser_ParseUTF8(JSONParser_P parser,const JSONText *jsontext);


///
///utf8ŃIuWFNg
///
static JSONResult ParseObjectUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr);


///
///utf8ŃIuWFNgo[
///
static JSONResult ParseObjectMemberUTF8(JSONParser_P parser, const JSONText *jsontext,const JSONText **endptr);


///
///utf8Ŕzl
///
static JSONResult ParseValueUTF8(JSONParser_P parser,JSONUInt base,JSONChar_P name,const JSONText *jsontext,const JSONText **endptr);

///
///utf8Ŕz
///
static JSONResult ParseArrayUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr);

///
///utf8ŕ
///
static JSONResult ParseStringUTF8(JSONChar_P buf,JSONUInt buflen,const JSONText *jsontext,const JSONText *end,const JSONText **endptr);


///
///utf810i
///
static JSONResult ParseDecimalUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr);

///
///utf8ŕl
///
static JSONResult ParseStringValueUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr);

///
///utf8Ńe
///
static JSONResult ParseLiteralNameUTF8(JSONText *literalName,const JSONText *jsontext,const JSONText **endptr); 

///
///json̏I[擾
///
static JSONResult GetJSONStringEndUTF8(const JSONText *jsontext,const JSONText **endptr);


///
///json̈m
///
static JSONChar_P JSONString_alloc(JSONStringAllocator_P allocator,JSONUInt len);


///
///json̈
///
static JSONVoid JSONString_free(JSONStringAllocator_P allocator);


///
///p[T̃obt@w肳ꂽ̈m
///
static JSONVoid JSONParser_BufferExtend(JSONParser_P parser,JSONUInt length);


///
///utf8񂩂utf16ϊɕKvȒ擾
///
static JSONUInt getLenU8ToU16(const JSONText *start,const JSONText *end);

///
///utf8񂩂utf16ɕϊ
///
static JSONUInt U8ToU16(JSONChar_P buf,JSONUInt len,const JSONText *start,const JSONText *end);





JSONResult JSONParser_Parse(JSONParser_P parser,const JSONVoid *jsontext,JSONParameter encode,JSONVoid *option){

	JSONResult rslt = JSON_ERR_NOTINIT;

	parser->option = option;

	//GR[h^Cv̔
	switch(encode){

		//utf8̏ꍇ
	case JSON_ENCODE_UTF8:

		//utf8p̉
		rslt = JSONParser_ParseUTF8(parser,(const JSONText*)jsontext);

		break;

		//`ĂȂ^Cv̏ꍇ
	default:

		rslt = JSON_ERR_ENCODE_UNKNOWN;

		break;
	}

	return rslt;

}



static JSONResult JSONParser_ParseUTF8(JSONParser_P parser,const JSONText *jsontext){

	JSONResult rslt = JSON_ERR_NOTINIT;

	//IuWFNg͔z̊Jn
	jsontext = strpbrk(jsontext,"{[");

	//NULL̏ꍇI
	if(jsontext == NULL){
		
		return rslt;

	}

	//\̃^Cv
	switch(jsontext[0]){

		//IuWFNg
	case '{':

		parser->structHandler(parser->option,JSONTypeRoot,JSONTypeObject,NULL);

		rslt = ParseObjectUTF8(parser,jsontext,&jsontext);

		parser->dataEndHandler(parser->option,JSONTypeRoot,JSONTypeObject,NULL);

		break;

		//z
	case '[':

		parser->structHandler(parser->option,JSONTypeRoot,JSONTypeArray,NULL);

		rslt = ParseArrayUTF8(parser,jsontext,&jsontext);

		parser->dataEndHandler(parser->option,JSONTypeRoot,JSONTypeArray,NULL);


		break;

	}

	return rslt;

}


static JSONResult ParseObjectUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr){

	JSONResult rslt = JSON_ERR_NOTINIT;

	//'{'XLbv
	jsontext++;
	//󔒂XLbv
	jsontext += strspn(jsontext," \r\n\t");

	if(jsontext[0] =='}'){
		goto success;
	}

	//IuWFNgo
	do{

		

		
		if(jsontext[0] != '"'){

			goto syntaxerr;

		}


		rslt = ParseObjectMemberUTF8(parser,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){
			goto end;
		}

		switch(jsontext[0]){

			//IuWFNg̏ꍇ͏I
		case '}':

			//'}'XLbv
			jsontext++;
			goto success;

		case ',':

			//','XLbv
			jsontext++;
			break;

		default:

			goto syntaxerr;



		}

		//󔒂XLbv
		jsontext += strspn(jsontext," \r\n\t");

	}while(JSONTrue);

	

success:
	rslt = JSON_ERR_OK;
	(*endptr) = (JSONText*)jsontext;
end:
	

	return rslt;

	//\̓G[
syntaxerr:
	rslt = JSON_ERR_SYNTAX;
	goto end;



}

static JSONResult ParseObjectMemberUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr){

	JSONStringAllocator stringAllocator;				//AP[^
	JSONResult rslt = JSON_ERR_NOTINIT;
	JSONChar_P name;
	JSONText *nameend;									//nameI[|C^
	JSONUInt nameLen;									//name̒

	//'"'XLbv
	jsontext++;

	//I[|C^擾
	rslt = GetJSONStringEndUTF8(jsontext,&nameend);

	if(rslt != JSON_ERR_OK){

		goto end;

	}

	//I[|C^ɕϊp̒擾
	nameLen = getLenU8ToU16(jsontext,nameend);

	//obt@擾
	name = JSONString_alloc(&stringAllocator,nameLen + 1);

	//IuWFNg
	rslt = ParseStringUTF8(name,nameLen,jsontext,nameend,&jsontext);

	
	//ł͂ȂꍇI
	if(rslt != JSON_ERR_OK){

		goto end;

	}

	//oZp[^̔
	if(jsontext[0] != ':'){

		goto syntaxerr;

	}
	jsontext++;

	//󔒂XLbv
	jsontext += strspn(jsontext," \r\n\t");

	

	//value
	rslt = ParseValueUTF8(parser,JSONTypeObject,name,jsontext,&jsontext);

	if(rslt != JSON_ERR_OK){

		goto end;
	}

	(*endptr) = jsontext;
end:

	//obt@J
	JSONString_free(&stringAllocator);
	

	return rslt;

	//\̓G[
syntaxerr:
	rslt = JSON_ERR_SYNTAX;
	goto end;
}



static JSONResult ParseArrayUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr){


	JSONResult rslt = JSON_ERR_NOTINIT;

	//'['XLbv
	jsontext++;

	//󔒂XLbv
	jsontext += strspn(jsontext," \r\n\t");

	if(jsontext[0] == ']'){

		goto success;

	}


		//z
	do{

		rslt = ParseValueUTF8(parser,JSONTypeArray,NULL,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){
			goto end;
		}

		switch(jsontext[0]){

			//IuWFNg̏ꍇ͏I
		case ']':

			//']'XLbv
			jsontext++;
			goto success;

		case ',':

			//','XLbv
			jsontext++;
			break;;

		default:

			goto syntaxerr;



		}

		//󔒂XLbv
		jsontext += strspn(jsontext," \r\n\t");

	}while(JSONTrue);

success:
	rslt = JSON_ERR_OK;
	(*endptr) = jsontext;

end:
	

	return rslt;

syntaxerr:

	rslt = JSON_ERR_SYNTAX;

	goto end;

}

///
///value
///
static JSONResult ParseValueUTF8(JSONParser_P parser,JSONUInt base,JSONChar_P name,const JSONText *jsontext,const JSONText **endptr){

	JSONResult rslt = JSON_ERR_NOTINIT;


		//value
	switch(jsontext[0]){

		//valueIuWFNg̏ꍇ
	case '{':
		parser->structHandler(parser->option,base,JSONTypeObject,name);

		rslt = ParseObjectUTF8(parser,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){
			goto end;
		}

		parser->dataEndHandler(parser->option,base,JSONTypeObject,name);
		break;

		//valuez̏ꍇ
	case '[':
		parser->structHandler(parser->option,base,JSONTypeArray,name);

		rslt = ParseArrayUTF8(parser,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){

			goto end;

		}

		parser->dataEndHandler(parser->option,base,JSONTypeArray,NULL);

		break;

		//valuȅꍇ
	case '"':

		rslt = ParseStringValueUTF8(parser,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){

			goto end;

		}

		parser->dataHandler(parser->option,base,JSONTypeString,name,(JSONParameter)parser->value);

		break;

		//valuel̏ꍇ
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':

		rslt = ParseDecimalUTF8(parser,jsontext,&jsontext);

		if(rslt != JSON_ERR_OK){

			goto end;

		}

		parser->dataHandler(parser->option,base,JSONTypeDecimal,name,(JSONParameter)parser->value);

		break;

		//valuetruȅꍇ
	case 't':

		rslt = ParseLiteralNameUTF8("true",jsontext,&jsontext);
		if(rslt != JSON_ERR_OK){
			goto end;
		}
		
		parser->dataHandler(parser->option,base,JSONTypeBool,name,JSONTrue);

		break;

		//valuefalsȅꍇ
	case 'f':
		rslt = ParseLiteralNameUTF8("false",jsontext,&jsontext);
		if(rslt != JSON_ERR_OK){
			goto end;
		}

		parser->dataHandler(parser->option,base,JSONTypeBool,name,JSONFalse);
		break;

	case 'n':

		rslt = ParseLiteralNameUTF8("null",jsontext,&jsontext);
		if(rslt != JSON_ERR_OK){
			goto end;
		}

		parser->dataHandler(parser->option,base,JSONNull,name,(JSONParameter)NULL);

		break;

		//valueɎgp\ȕȊȌ̕ꍇ
	default:

		goto syntaxerr;


	}

	rslt = JSON_ERR_OK;

	//󔒂XLbv
	jsontext += strspn(jsontext," \r\n\t");


	rslt = JSON_ERR_OK;
	(*endptr) = (JSONText*)jsontext;

end:
	return rslt;

	//\̓G[
syntaxerr:
	rslt = JSON_ERR_SYNTAX;
	goto end;
}


JSONParser_P JSONParser_new(){

	JSONParser_P parser = (JSONParser_P)malloc(sizeof(JSONParser));

	parser->valueSize = sizeof(JSONChar) * 1024;

	parser->value = (JSONChar_P)malloc(parser->valueSize);

	JSONParser_setEventHandler(parser,defaultStructEventHandler,defaultDataEventHandler,defaultDataEndEventHandler);

	return parser;
}


JSONVoid JSONParser_delete(JSONParser_P *parser){

	
	free((*parser)->value);
	free(*parser);

	parser = NULL;


	return;
}


///
///\̃CxgnhZbg
///
JSONVoid JSONParser_setStructHandler(JSONParser_P parser,JSONStructEventHandler handler){

	parser->structHandler = handler;

	return;
}

///
///IuWFNgCxgnhZbg
///
JSONVoid JSONParser_setDataEventHandler(JSONParser_P parser,JSONDataEventHandler handler){

	parser->dataHandler = handler;

	return;
}


///
///zCxgnhZbg
///
JSONVoid JSONParser_setDataEndEventHandler(JSONParser_P parser,JSONStructEndEventHandler handler){

	parser->dataEndHandler = handler;

	return;


}

extern JSONVoid JSONParser_setEventHandler(JSONParser_P parser,JSONStructEventHandler structHandler,JSONDataEventHandler dataHandler,JSONStructEndEventHandler endHandler){
	
	parser->structHandler = structHandler;
	parser->dataHandler = dataHandler;
	parser->dataEndHandler = endHandler;

	return;

}




//
//vCx[g֐
//

//
//ftHg̃Cxgnh
//
static JSONVoid defaultDataEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt valueType,JSONChar_P name,JSONParameter parameter){

	return;
}

static JSONVoid defaultDataEndEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt endStructreType,JSONChar_P name){

	return;
}

static JSONVoid defaultStructEventHandler(JSONVoid *option,JSONUInt thisHierarchy,JSONUInt valueType,JSONChar_P name){

	return;
}

static JSONResult ParseStringUTF8(JSONChar_P buf,JSONUInt buflen,const JSONText *jsontext,const JSONText *end,const JSONText **endptr){

	JSONResult rslt = JSON_ERR_NOTINIT;			//
	JSONChar_P indexptr;						//CfbNX|C^
	JSONUInt len;

	len = U8ToU16(buf,buflen,jsontext,end);

	//utf16ɕϊ
	if(len == 0){
		goto converterr;
	}
	
	indexptr = buf;

	while(indexptr[0] != L'\"'){

		switch(indexptr[0]){

			//䕶Jn
		case L'\\':
			
			switch(indexptr[1]){

				
			case L'b':
				buf[0] = L'\b';
				goto recommand;
			case L't':
				buf[0] = L'\t';
				goto recommand;
			case L'f':
				buf[0] = L'\f';
				goto recommand;
			case L'n':
				buf[0] = L'\n';
				goto recommand;
			case L'r':
				buf[0] = L'\r';
				goto recommand;
			case L'\"':
			case L'\\':
			case L'/':

				buf[0] = indexptr[1];
recommand:

				buf++;
				indexptr += 2;
				break;

			case L'u':

				buf[0] = (wcharToHex(indexptr[2],-1) * 4096) + (wcharToHex(indexptr[3],-17) * 256) + (wcharToHex(indexptr[4],-257) * 16) + (wcharToHex(indexptr[5],-4097));

				if(buf[0] < 0){

					goto syntaxerr; 
				}

				buf++;
				indexptr += 6;
				break;
			



				//䕶ł͂ȂꍇA\̓G[Ƃ
			default:

				goto syntaxerr;

			}

			break;

			//"܂\ȊO̕
		default:
			buf[0] = indexptr[0];
			buf++;
			indexptr++;
			break;

		}


	}

	//Ōnull
	buf[0] = L'\0';

	(*endptr) = end + strspn(end," \t\r\n");
	rslt = JSON_ERR_OK;



end:


	return rslt;

converterr:
	rslt = JSON_ERR_CONVERT;
	goto end;

syntaxerr:
	rslt = JSON_ERR_SYNTAX;
	goto end;
}


JSONResult ParseStringValueUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr){

	JSONResult rslt = JSON_ERR_NOTINIT;

	JSONText *end;

	JSONUInt valueLen;
	
	jsontext++;
	

	rslt = GetJSONStringEndUTF8(jsontext,&end);

	if(rslt != JSON_ERR_OK){

		return rslt;

	}

	valueLen = getLenU8ToU16(jsontext,end);

	JSONParser_BufferExtend(parser,valueLen);

	rslt = ParseStringUTF8(parser->value,valueLen,jsontext,end,&jsontext);

	(*endptr) = jsontext;

	return rslt;
}

static JSONResult ParseDecimalUTF8(JSONParser_P parser,const JSONText *jsontext,const JSONText **endptr){

	JSONResult rslt;

	const JSONText *end = jsontext + strcspn(jsontext," \r\n\t,}");

	JSONUInt valueLen = getLenU8ToU16(jsontext,end);

	JSONParser_BufferExtend(parser,valueLen);

	if(U8ToU16(parser->value,valueLen,jsontext,end) == 0){

		goto converterr;
	}

	parser->value[valueLen] = L'\0';
	rslt = JSON_ERR_OK;

	(*endptr) = end;
end:
	return rslt;

converterr:
	rslt = JSON_ERR_CONVERT;
	goto end;

}

static JSONChar_P JSONString_alloc(JSONStringAllocator_P allocator,JSONUInt len){

	return (allocator->heapFlag = ((sizeof(allocator->buffer) / sizeof(allocator->buffer[0])) -1 <= len)) ? (allocator->heapBuf = (JSONChar_P)malloc(sizeof(JSONChar) * len)) : allocator->buffer;

}

static JSONVoid JSONString_free(JSONStringAllocator_P allocator){

	if(allocator->heapFlag){

		free(allocator->heapBuf);
	}

}

static JSONUInt U8ToU16(JSONChar_P buf,JSONUInt len,const JSONText *start,const JSONText *end){
	
	return MultiByteToWideChar(CP_UTF8,0,start,end - start,buf,len);
}

static JSONUInt getLenU8ToU16(const JSONText *start,const JSONText *end){



	return MultiByteToWideChar(CP_UTF8,0,start,end - start,NULL,0);

}

static JSONResult ParseLiteralNameUTF8(JSONText *literalName,const JSONText *jsontext,const JSONText **endptr){

	JSONUInt len = strcspn(jsontext," \r\n\t");
	JSONResult rslt =  (strncmp(literalName,jsontext,len) == 0) ? JSON_ERR_OK : JSON_ERR_SYNTAX;


	(*endptr) = jsontext + len;
	return rslt;
}

static JSONResult GetJSONStringEndUTF8(const JSONText *jsontext,const JSONText **endptr){


	for(;jsontext[0] != '\0' && jsontext[0] != '"';jsontext += jsontext[0] == '\\' ? 2 : 1);

	if(jsontext[0] == '\0'){

		return JSON_ERR_SYNTAX;

	}

	jsontext++;

	(*endptr) = jsontext;
	return JSON_ERR_OK;

}

static JSONVoid JSONParser_BufferExtend(JSONParser_P parser,JSONUInt length){

	length *= sizeof(JSONChar_P);
	if(parser->valueSize < length){
		free(parser->value);
		parser->value = (JSONChar_P)malloc(length);

	}
	return;
}