#include "StdAfx.h"
#include "nlib_include.h"



enum NPlayerStatus_NORD{
	NPlayerStatus_ROOT,
	NPlayerStatus_GETPLAYERSTATUS,
	NPlayerStatus_MS,
	NPlayerStatus_STREAM,
	NPlayerStatus_ERROR,
	NPlayerStatus_ADDR,
	NPlayerStatus_THREAD,
	NPlayerStatus_OPEN_TIME,
	NPlayerStatus_START_TIME,
	NPlayerStatus_ID,
	NPlayerStatus_CODE,
	NPlayerStatus_TITLE,
	NPlayerStatus_PORT,
	NPlayerStatus_PROVIDER,
	NPlayerStatus_DEFAULT_COMMUNITY,
	NPlayerStatus_IS_OWNER,
	NPlayerStatus_END_TIME,
	NPlayerStatus_NICOLIVE_API,
	NPlayerStatus_USER,
	NPlayerStatus_IS_PREMIUM,
	NPlayerStatus_USER_ID,
	NPlayerStatus_USER_DOMEIN,
	NPlayerStatus_BASE_TIME
};

enum NicoLiveHeartBeat_NORD{
	NicoLiveHeartBeat_ROOT,
	NicoLiveHeartBeat_HEARTBEAT,
	NicoLiveHeartBeat_WATCHCOUNT,
	NicoLiveHeartBeat_COMMENTCOUNT,
	NicoLiveHeartBeat_IS_RESTRICT,
	NicoLiveHeartBeat_TICKET
};

enum StreamInfo_NORD{
	StreamInfo_ROOT,
	StreamInfo_GETPLAYERSTATUS,
	StreamInfo_REQUEST_ID,
	StreamInfo_STREAMINFO,
	StreamInfo_TITLE,
	StreamInfo_DESCRIPTION,
	StreamInfo_PROVIDER_TYPE,
	StreamInfo_DEFAULT_COMMUNITY,
	StreamInfo_COMMUNITYINFO,
	StreamInfo_NAME,
	StreamInfo_THUMBNAIL,
};


enum NicoLivePublishStatus_NORD{
	NicoLivePublish_ROOT,
	NicoLivePublish_PUBLISHSTATUS,
	NicoLivePublish_NICOLIVE_API,
	NicoLivePublish_STREAM,
	NicoLivePublish_ERROR,
	NicoLivePublish_TOKEN,
	NicoLivePublish_CODE

};



#define StrCpyArray(buf,pszData,nLength) StrCpy(buf,sizeof(buf) / sizeof(buf[0]),pszData,nLength)

static INLINE NLIB_RESULT StrCpy(LPTSTR buf,UINT_PTR buflen,LPCTSTR pszData,UINT_PTR nLength);

///
///UTF8ϊ֐
///
static INLINE VOID ToUTF8(LPSTR buf,LPCTSTR input,INT_PTR nLength,INT_PTR maxLength);


static INLINE NLIB_RESULT convToResultCode(LPCTSTR pszData,UINT nLength){

	NLIB_RESULT rslt = NLIB_ERR_CODE_NOTSET;

	if(_tcsncmp(pszData,TEXT("invalid_lv"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_INVALID_LV;
			
	}else if(_tcsncmp(pszData,TEXT("invalid_thread"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_INVALID_THREAD;

	}else if( _tcsncmp(pszData,TEXT("notfound"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_NOTFOUND;

	}else if(_tcsncmp(pszData,TEXT("notlogin"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_NOTLOGIN;

	}else if(_tcsncmp(pszData,TEXT("not_permitted"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_NOT_PERMITTED;

	}else if(_tcsncmp(pszData,TEXT("maintenance"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_MAINTENANCE;

	}else if(_tcsncmp(pszData,TEXT("closed"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_CLOSED;

	} else if(_tcsncmp(pszData,TEXT("unknown"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_UNKNOWN;

	}else if(_tcsncmp(pszData,TEXT("unknown_error"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_UNKNOWN_ERROR;

	} else if(_tcsncmp(pszData,TEXT("server_error"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_SERVER_ERROR;
			

	} else if(_tcsncmp(pszData,TEXT("DELETED"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_DELETED;

	} else if(_tcsncmp(pszData,TEXT("full"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_FULL;

	} else if(_tcsncmp(pszData,TEXT("permission_denied"),nLength) == 0){
			
		rslt = NLIB_ERR_GETPLAYERSTATUS_PERMISSION_DENIED;
			
	}else if(_tcsncmp(pszData,TEXT("require_accept_print_timeshift_ticket"),nLength) == 0) {

		rslt = NLIB_ERR_GETPLAYERSTATUS_REQUIRE_ACCEPT_PRINT_TIMESHIFT_TICKET;


	}else if(_tcsncmp(pszData,TEXT("access_locked"),nLength) == 0) {

		rslt = NLIB_ERR_GETPLAYERSTATUS_ACCESS_LOCKED;


	}else if(_tcsncmp(pszData,TEXT("tsarchive"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_TSARCHIVE;

	} else if(_tcsncmp(pszData,TEXT("usertimeshift"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_USERTIMESHIFT;

	} else if(_tcsncmp(pszData,TEXT("require_community_member"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_REQUIRE_COMMUNITY_MEMBER;

	} else if(_tcsncmp(pszData,TEXT("comingsoon"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_COMINGSOON;

	}else if(_tcsncmp(pszData,TEXT("noauth"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_NOAUTH;

	} else if(_tcsncmp(pszData,TEXT("block_now_count_overflow"),nLength) == 0){

		rslt = NLIB_ERR_GETPLAYERSTATUS_BLOCK_NOW_COUNT_OVERFLOW;

	}else {
		std::wstring errmessage(TEXT("mF̃vC[Xe[^XG[:"));
		errmessage.append(pszData,nLength);
		rslt = NLIB_ERR_GETPLAYERSTATUS_UNDEFINED;
		throw nlib::Exception(errmessage.c_str(),__LINE__,TEXT(__FILE__),TEXT(__FILE__));
			

			
			
	}
	return rslt;

}



extern void NPlayerStatus_ElementStartHandler(void *userData,const XML_Char *pszName,const XML_Char *atts[]){

	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLivePlayerStatus_P ps = (NicoLivePlayerStatus_P)userDataContainer->userData;

	
	
	enum NPlayerStatus_NORD element  = NPlayerStatus_ROOT;

	switch (userDataContainer->nord){

		//em[h
	case (MAKENORD(NPlayerStatus_ROOT)):
	
		
		if(_tcscmp(pszName,TEXT("getplayerstatus")) == 0){

			

			UINT_PTR index;

			for(index = 0;atts[index] != NULL;index += 2){

				if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) == 0){

					
						userDataContainer->errcode = NLIB_ERR_OK;


				}else if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) != 0){

					userDataContainer->errcode = NLIB_ERR_PLAYERSTATUS_ERROR;
				}


			}

			element = NPlayerStatus_GETPLAYERSTATUS;



			


		} else if(_tcscmp(pszName,TEXT("nicolive_api")) == 0){

			element = NPlayerStatus_NICOLIVE_API;

		}
		break;

		//getplayerstatus or // NPlayerStatus_NICOLIVE_API
	case (MAKENORD(NPlayerStatus_GETPLAYERSTATUS)):
	case (MAKENORD(NPlayerStatus_NICOLIVE_API)):

		
			

	
		if(_tcscmp(pszName,TEXT("ms"))== 0){

			element = NPlayerStatus_MS;
			


		} else if(_tcscmp(pszName,TEXT("stream"))== 0){

			element = NPlayerStatus_STREAM;
			


		}else if(_tcscmp(pszName,TEXT("user"))== 0){

			element = NPlayerStatus_USER;

		} else if(_tcscmp(pszName,TEXT("error"))== 0){

			element = NPlayerStatus_ERROR;

		}
		
		break;
		//getplayerstatus/ms
	case (MAKENORD1(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_MS)):

	

		if(_tcscmp(pszName,TEXT("addr")) == 0){

			element = NPlayerStatus_ADDR;
			

		} else if(_tcscmp(pszName,TEXT("port")) == 0){

			element = NPlayerStatus_PORT;


		} else if(_tcscmp(pszName,TEXT("thread")) == 0){

			
			element = NPlayerStatus_THREAD;


		}
		break;

		//getplayerstatus/stream
	case (MAKENORD1(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM)):
		if(_tcscmp(pszName,TEXT("open_time")) == 0){

			element = NPlayerStatus_OPEN_TIME;
			

		} else if(_tcscmp(pszName,TEXT("start_time")) == 0){

			element = NPlayerStatus_START_TIME;
			
		} else if(_tcscmp(pszName,TEXT("base_time")) == 0){
		
			element = NPlayerStatus_BASE_TIME;
		
		} else if(_tcscmp(pszName,TEXT("id")) == 0){

			element = NPlayerStatus_ID;

		} else if(_tcscmp(pszName,TEXT("title")) == 0){
		
			element = NPlayerStatus_TITLE;
		}else if(_tcscmp(pszName,TEXT("provider_type")) == 0){

			element = NPlayerStatus_PROVIDER;

		} else if(_tcscmp(pszName,TEXT("default_community")) == 0){

			element = NPlayerStatus_DEFAULT_COMMUNITY;

		} else if(_tcscmp(pszName,TEXT("is_owner")) == 0){

			element = NPlayerStatus_IS_OWNER;

		} else if(_tcscmp(pszName,TEXT("end_time")) == 0){

			element = NPlayerStatus_END_TIME;

		}


		break;

	case (MAKENORD1(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_USER)):


		if(_tcscmp(pszName,TEXT("is_premium")) == 0){

			element = NPlayerStatus_IS_PREMIUM;
			
		}  else if(_tcscmp(pszName,TEXT("user_id")) == 0){

			element = NPlayerStatus_USER_ID;

		}  else if(_tcscmp(pszName,TEXT("userDomain")) == 0){

			element = NPlayerStatus_USER_DOMEIN;
		}

		break;

	case (MAKENORD1(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_ERROR)):
	case MAKENORD1(NPlayerStatus_NICOLIVE_API,NPlayerStatus_ERROR):

		if(_tcscmp(pszName,TEXT("code")) == 0){

			element = NPlayerStatus_CODE;

		}

		break;






	}

	userDataContainer->nord = MAKENORD1(userDataContainer->nord,element);

	return;

}


void NPlayerStatus_CharacterDataHandler(void *userData,const XML_Char *pszData,int nLength){

	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLivePlayerStatus_P ps = (NicoLivePlayerStatus_P)userDataContainer->userData;
	
	
	switch(userDataContainer->nord){

	//getplayerstatus/ms/addr
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_MS,NPlayerStatus_ADDR):

		

		
		userDataContainer->errcode =  StrCpyArray(ps->ms.addr,pszData,nLength);


		break;

		//getplayerstatus/ms/port
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_MS,NPlayerStatus_PORT):

		
		

		userDataContainer->errcode =  StrCpyArray(ps->ms.port,pszData,nLength);
		
		


		break;

		//getplayerstatus/ms/thread
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_MS,NPlayerStatus_THREAD):

		//ps->ms.thread = wtoin(pszData,nLength);
		strToIntN(ps->ms.thread,pszData,nLength);


		break;

		//getplayerstatus/stream/open_time
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_OPEN_TIME):

		//ps->stream.open_time = wtoin(pszData,nLength);
		strToIntN(ps->stream.open_time,pszData,nLength);


		break;

		//getplayerstatus/stream/start_time
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_START_TIME):

		//ps->stream.start_time = wtoin(pszData,nLength);
		strToIntN(ps->stream.start_time,pszData,nLength);
		//_tcscpy(start_time,elementValue);

		break;

		//getplayerstatus/stream/base_time
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_BASE_TIME):

		strToIntN(ps->stream.base_time,pszData,nLength);

		break;
#ifdef PLAYERSTATUS_GET_TITLE
		//getplayerstatus/stream/title
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_TITLE):

		StrCpy(ps->stream.title,ARRAY_LENGTH(ps->stream.title),pszData,nLength);

		break;
#endif
			

		//getplayerstatus/stream/id
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_ID):

		
		userDataContainer->errcode =  StrCpyArray(ps->stream.id,pszData,nLength);

		break;
		


		//getplayerstatus/user/is_premium
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_USER,NPlayerStatus_IS_PREMIUM):

		
		strToIntN(ps->user.is_premium,pszData,nLength);

		break;

		//getplayerstatus/user/is_premium
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_USER,NPlayerStatus_USER_ID):

		
		userDataContainer->errcode = StrCpyArray(ps->user.user_id,pszData,nLength);

		break;
		
		//getplayerstatus/user/userDomein
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_USER,NPlayerStatus_USER_DOMEIN):

		userDataContainer->errcode = StrCpyArray(ps->user.userDomain,pszData,nLength);

		break;

		//getplayerstatus/stream/provider
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_PROVIDER):

		if(_tcsncmp(pszData,TEXT("community"),nLength) == 0){

			ps->stream.provider_type = COMMUNITY_PROVIDER_TYPE;

		} else if(_tcsncmp(pszData,TEXT("channel"),nLength) == 0){

			ps->stream.provider_type = CHANNEL_PROVIDER_TYPE;
		
		}else if(_tcsncmp(pszData,TEXT("official"),nLength) == 0){

			ps->stream.provider_type = OFFICIAL_PROVIDER_TYPE;

		}

		break;

		//getplayerstatus/stream/default_community
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_DEFAULT_COMMUNITY):

		
		userDataContainer->errcode =  StrCpyArray(ps->stream.default_community,pszData,nLength);

		break;

		//getplayerstatus/stream/is_owner
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_IS_OWNER):

		//ps->stream.is_owner = wtoin(pszData,nLength);
		strToIntN(ps->stream.is_owner,pszData,nLength);
		break;


		//getplayerstatus/stream/end_time
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_STREAM,NPlayerStatus_END_TIME):

		//ps->stream.end_time = wtoin(pszData,nLength);
		strToIntN(ps->stream.end_time,pszData,nLength);

		break;

		//getplayerstatus/error/code
	case MAKENORD2(NPlayerStatus_GETPLAYERSTATUS,NPlayerStatus_ERROR,NPlayerStatus_CODE):
	case MAKENORD2(NPlayerStatus_NICOLIVE_API,NPlayerStatus_ERROR,NPlayerStatus_CODE):

		
		
		userDataContainer->errcode = convToResultCode(pszData,nLength);

		


		break;

	}


}



extern void NPlayerStatus_ElementEndHandler(void *userData,const XML_Char *pszName){


	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	userDataContainer->nord = UPNORD(userDataContainer->nord);


}




void NicoLiveHeartBeat_ElementStartHandler(void *userData,const XML_Char *pszName,const XML_Char *atts[]){

	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLiveHeartBeatContainer_P hbc = (NicoLiveHeartBeatContainer_P)userDataContainer->userData;


	enum NicoLiveHeartBeat_NORD element  = NicoLiveHeartBeat_ROOT;

	switch (userDataContainer->nord){

		//em[h
	case (MAKENORD(NicoLiveHeartBeat_ROOT)):
	
		
		if(_tcscmp(pszName,TEXT("heartbeat")) == 0){


			UINT_PTR index;

			for(index = 0;atts[index] != NULL;index += 2){

				if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) == 0){

					
						userDataContainer->errcode = NLIB_ERR_OK;


				}else if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) != 0){

					userDataContainer->errcode = NLIB_ERR_HEARTBEAT_ERROR;
				}else if(_tcscmp(atts[index],TEXT("time")) == 0){

					hbc->heartBeat.time = wcstoul(atts[index + 1],NULL,0);

				}


			}

			element = NicoLiveHeartBeat_HEARTBEAT;
		}
		


		break;
			

	case MAKENORD(NicoLiveHeartBeat_HEARTBEAT):

		if(_tcscmp(pszName,TEXT("watchCount")) == 0){

			element = NicoLiveHeartBeat_WATCHCOUNT;

		} else if(_tcscmp(pszName,TEXT("commentCount")) == 0){

			element = NicoLiveHeartBeat_COMMENTCOUNT;

		} else if(_tcscmp(pszName,TEXT("is_restrict")) == 0){

			element = NicoLiveHeartBeat_IS_RESTRICT;

		} else if(_tcscmp(pszName,TEXT("ticket")) == 0){

			element = NicoLiveHeartBeat_TICKET;

		}


		break;
	}

		

		

	userDataContainer->nord = MAKENORD1(userDataContainer->nord,element);



}


void NicoLiveHeartBeat_CharacterDataHandler(void *userData,const XML_Char *pszData,int nLength){


	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLiveHeartBeatContainer_P hbc = (NicoLiveHeartBeatContainer_P)userDataContainer->userData;


	switch(userDataContainer->nord){

		//heartbeat/watchCount
	case MAKENORD1(NicoLiveHeartBeat_HEARTBEAT,NicoLiveHeartBeat_WATCHCOUNT):

		 strToIntN(hbc->heartBeat.watchCount,pszData,nLength);

		break;

		//heartbeat/commentCount
	case MAKENORD1(NicoLiveHeartBeat_HEARTBEAT,NicoLiveHeartBeat_COMMENTCOUNT):

		strToIntN(hbc->heartBeat.commentCount,pszData,nLength);

		break;

		//heartbeat/is_restrict
	case MAKENORD1(NicoLiveHeartBeat_HEARTBEAT,NicoLiveHeartBeat_IS_RESTRICT):

		extendMalloc(hbc->is_restrictBuff,LPTSTR,hbc->is_restrictSize,(INT_PTR)sizeof(TCHAR) * nLength);

		wcsncpy(hbc->is_restrictBuff,pszData,nLength);

		hbc->is_restrictBuff[nLength] = L'\0';

		break;

		//heartbeat/ticket
	case MAKENORD1(NicoLiveHeartBeat_HEARTBEAT,NicoLiveHeartBeat_TICKET):

		extendMalloc(hbc->ticketBuff,LPTSTR,hbc->ticketSize,(INT_PTR)sizeof(TCHAR) * nLength);

		wcsncpy(hbc->ticketBuff,pszData,nLength);

		hbc->ticketBuff[nLength] = L'\0';

		break;


	}

}


void NicoLiveHeartBeat_ElementEndHandler(void *userData,const XML_Char *pszName){

	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	userDataContainer->nord = UPNORD(userDataContainer->nord);


}




static INLINE VOID ToUTF8(LPSTR buf,LPCTSTR input,INT_PTR nLength,INT_PTR maxLength){


	if(WideCharToMultiByte(CP_UTF8,0,input,nLength,(LPSTR)NULL,0,(LPCSTR)NULL,(LPBOOL)NULL) > maxLength){

			return;

	}

	buf[WideCharToMultiByte(CP_UTF8,0,input,nLength,buf,maxLength,(LPCSTR)NULL,(LPBOOL)NULL)] = '\0';



}


static INLINE NLIB_RESULT StrCpy(LPTSTR buf,UINT_PTR buflen,LPCTSTR pszData,UINT_PTR nLength){

	if(nLength >= buflen){
		return NLIB_ERR_BUFFER_TOOLITTLE;
	}

	wcsncpy(buf,pszData,nLength);
	buf[nLength] = L'\0';


	return NLIB_ERR_OK;


	
	


}


void NPublishStatus_ElementStartHandler(void *userData,const XML_Char *pszName,const XML_Char *atts[]){
	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLivePublishStatus_P ps = (NicoLivePublishStatus_P)userDataContainer->userData;

	enum NicoLivePublishStatus_NORD element  = NicoLivePublish_ROOT;

	switch (userDataContainer->nord){

		//em[h
	case (MAKENORD(NicoLivePublish_ROOT)):
	
		
		if(_tcscmp(pszName,TEXT("getpublishstatus")) == 0){

			

			UINT_PTR index;

			for(index = 0;atts[index] != NULL;index += 2){

				if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) == 0){

					
						userDataContainer->errcode = NLIB_ERR_OK;


				}else if(_tcscmp(atts[index],TEXT("status")) == 0 && _tcscmp(atts[index + 1],TEXT("ok")) != 0){

					userDataContainer->errcode = NLIB_ERR_PUBLISHSTATUS_ERROR;
				}


			}

			element = NicoLivePublish_PUBLISHSTATUS;



			


		} else if(_tcscmp(pszName,TEXT("nicolive_api")) == 0){

			element = NicoLivePublish_NICOLIVE_API;

		}
		break;


	case (MAKENORD(NicoLivePublish_PUBLISHSTATUS)):
	case (MAKENORD(NicoLivePublish_NICOLIVE_API)):

		if(_tcscmp(pszName,TEXT("stream"))== 0){

			element = NicoLivePublish_STREAM;
			


		}else if(_tcscmp(pszName,TEXT("error"))== 0){

			element = NicoLivePublish_ERROR;

		}
		break;
	case (MAKENORD1(NicoLivePublish_PUBLISHSTATUS,NicoLivePublish_STREAM)):

		if(_tcscmp(pszName,TEXT("token")) == 0){

			element = NicoLivePublish_TOKEN;

		}

		break;

	case (MAKENORD1(NicoLivePublish_PUBLISHSTATUS,NicoLivePublish_ERROR)):
	case (MAKENORD1(NicoLivePublish_NICOLIVE_API,NicoLivePublish_ERROR)):

		if(_tcscmp(pszName,TEXT("code"))==0){

			element = NicoLivePublish_CODE;

		}

		break;


	default:


		break;

	}

	userDataContainer->nord = MAKENORD1(userDataContainer->nord,element);

	return;
}

void NPublishStatus_CharacterDataHandler(void *userData,const XML_Char *pszData,int nLength){
	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLivePublishStatus_P ps = (NicoLivePublishStatus_P)userDataContainer->userData;


	switch(userDataContainer->nord){

	case (MAKENORD2(NicoLivePublish_PUBLISHSTATUS,NicoLivePublish_STREAM,NicoLivePublish_TOKEN)):

		if(nLength < ARRAY_LENGTH(ps->token)){
			_tcsncpy(ps->token,pszData,nLength);
		} else {

			userDataContainer->errcode = NLIB_ERR_BUFFER_TOOLITTLE;

		}

		break;

	case MAKENORD2(NicoLivePublish_PUBLISHSTATUS,NicoLivePublish_ERROR,NicoLivePublish_CODE):
	case MAKENORD2(NicoLivePublish_NICOLIVE_API,NicoLivePublish_ERROR,NicoLivePublish_CODE):

		userDataContainer->errcode = convToResultCode(pszData,nLength);

		break;

	default:

		break;
	}

	return;
}

void NPublishStatus_ElementEndHandler(void *userData,const XML_Char *pszName){
	UserDataContainer_P userDataContainer = (UserDataContainer_P)userData;
	NicoLivePublishStatus_P ps = (NicoLivePublishStatus_P)userDataContainer->userData;


	userDataContainer->nord = UPNORD(userDataContainer->nord);

	return;

}