// nlite.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "nlite_include.h"
using namespace nlite;
CAppModule _Module;






static WSAData wsaData;							//winsockdata
static HINTERNET hInternet = NULL;

static BOOL InitializeNlite();					//AvP[V
static VOID FinalizeNlite();					//AvP[VI
static CNliteMainFrame wnd;						//Ct[EBhE

//C֐
int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE,
	LPTSTR lpCmdLine, int nCmdShow)
{
	HINSTANCE hRich = LoadLibrary(CRichEditCtrl::GetLibraryName());
	int nRet = -1;
	try{

		//
		//AvPP[V
		//
		HRESULT hRes = ::CoInitialize(NULL);
		ATLASSERT(SUCCEEDED(hRes));
		AtlInitCommonControls(ICC_COOL_CLASSES | ICC_WIN95_CLASSES);
		GUID guid;
		if(_Module.Init(NULL, hInstance,&guid) != S_OK){
			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		}

		AtlAxWinInit();

		if(InitializeNlite() != TRUE){
			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		}

		

		
		//bZ[W[vo^
		CMessageLoop theLoop;
		_Module.AddMessageLoop(&theLoop);


		//CEBhE
		wnd.Initialize(localAppDataPath);
		wnd.CreateEx(0,0,WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN);

		//CEBhE\
		wnd.ShowWindow(nCmdShow);
		wnd.UpdateWindow();

		//]ɊmۂĂq[vJ
		_heapmin();


		//bZ[W[vJn
		nRet = theLoop.Run();

		//Iチ`FbN
		vcassert(_heapchk() == _HEAPOK,TEXT("q[vG[ł"));

		goto nliteend;

	} catch(nlite::Exception &e){

		UnexpectedErrorMessageShow(TEXT("nhĂȂG["),e.what(),e.getLineNo(),e.getFileName(),e.getFunctionName());


		goto nlitefinally;
	} catch(nlib::Exception &e){

		UnexpectedErrorMessageShow(TEXT("nlibŃnhĂȂG["),e.what(),e.getLineNo(),e.getFileName(),e.getFunctionName());

		goto nlitefinally;
	}catch(std::exception &e){
		UnexpectedErrorMessageShow(TEXT("nhĂȂG["),CComBSTR(e.what()),-1,TEXT("t@Co܂"),TEXT("֐ł܂"));



		goto nlitefinally;
	} 

nlitefinally:
	wnd.OnException();
	wnd.DestroyWindow();
	FreeLibrary(hRich);

nliteend:

	_Module.RemoveMessageLoop();
	FinalizeNlite();
	_Module.Term();
	::CoUninitialize();

	return nRet;
}

static BOOL InitializeNlite(){

	BOOL rslt = FALSE;

	try{

		nlite::appInfo = &CApplicationInfo::getInstance();
		INT_PTR err;
		INT_PTR count = 0;

		//WSAData
		while((err = WSAStartup(MAKEWORD(2,0),&wsaData)) == WSASYSNOTREADY){

			count++;
			if(count >= 5)break;
			Sleep(500);



		}

		if(err != ERROR_SUCCESS){

			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		}

		//AvP[VCX^X
		const CApplicationInfo &appInfo = CApplicationInfo::getInstance();
		CNLiteString userAgent;
		userAgent = appInfo.getProcuctName();
		userAgent += TEXT("/");
		userAgent += appInfo.getProductVersion();



		//HTTPIuWFNg
		hInternet = WinHttpOpen(userAgent,WINHTTP_ACCESS_TYPE_DEFAULT_PROXY,(LPCWSTR)WINHTTP_NO_PROXY_NAME,(LPCWSTR)WINHTTP_NO_PROXY_BYPASS,0);

		if(hInternet == NULL){

			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

		}

		//nlib̏
		InitializeNLIB(hInternet);

		//[JAvP[VtH_
		if(SHGetFolderPathW(0,CSIDL_LOCAL_APPDATA,0,SHGFP_TYPE_CURRENT,localAppDataPath) != S_OK){

			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		}


		SystemParametersInfo (SPI_SETLISTBOXSMOOTHSCROLLING,FALSE,FALSE,0);



		if(SHGetFolderPathW(0,CSIDL_APPDATA,0,SHGFP_TYPE_CURRENT,appFolderPath) != S_OK){

			throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		}
		ncvAppSettingPath = appFolderPath;
		ncvAppSettingPath += TEXT("\\posite-c\\NiconamaCommentViewer\\AppSetting.xml");
		rslt = TRUE;
	}catch (AppInitException e){

		rslt = FALSE;

	}
	

	return rslt;
}


VOID FinalizeNlite(){

	//Ct[EBhE㏈
	wnd.Finalaize();

	//nlib㏈
	FinalizeNLIB();

	//HTTPIuWFNgJ
	WinHttpCloseHandle(hInternet);

	//winsockJ
	WSACleanup();

	return;
}

