#include "stdafx.h"
#include <Wininet.h>
#define _WINHTTPX_
#include "nlite_include.h"


namespace nlite{


CNicoVideoAuth::CNicoVideoAuth()
			:nicoVideoAuth(NicoVideoAuth_new()){}



CNicoVideoAuth::~CNicoVideoAuth(){

	NicoVideoAuth_delete(&nicoVideoAuth);
}

LPCTSTR CNicoVideoAuth::GetUserSession(){

	return NicoVideoAuth_getUserSession(nicoVideoAuth);

}

VOID CNicoVideoAuth::SetBrowserType(BROWSERTYPE bt){
	NLIB_RESULT rslt;

	rslt = NicoVideoAuth_getNicoVideoAuth(nicoVideoAuth,bt);
	if(rslt != NLIB_ERR_OK){

		throw NLIBException(TEXT("jRjRF؏擾Ɏs܂"),rslt,__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
	}
	
	return;
}




BOOL CCommentMaker::SetChatString(LPCTSTR chatString){
	
	if(this->chatString.Length() != 0)return FALSE;
	this->chatString = chatString;

	return TRUE;
}

BOOL CCommentMaker::AddMail(LPCTSTR mail){

	mailsBuffer.push_back(mail);
	mails.push_back(mailsBuffer.back());

	return TRUE;
}

BOOL CCommentMaker::AddExAttribute(LPCTSTR name,LPCTSTR value){

	exAttributeBuffer.push_back(name);
	exAttribute.push_back(exAttributeBuffer.back());
	exAttributeBuffer.push_back(value);
	exAttribute.push_back(exAttributeBuffer.back());

	return TRUE;
}

NicoVideoAuth_P CNicoVideoAuth::GetAuth(){

	return this->nicoVideoAuth;
}



CNicoLiveStream::CNicoLiveStream()
			:self(NicoLiveStream_new())

		{}


CNicoLiveStream::~CNicoLiveStream(){

	NicoLiveStream_delete(&self);
			
}


VOID CNicoLiveStream::SetResFrom(INT_PTR res_from){

	NicoLiveStrream_setResFrom(self,res_from);
	return;
}

INT_PTR CNicoLiveStream::GetResFrom(){

	return NicoLiveStream_getResFrom(self);
}

NLIB_RESULT CNicoLiveStream::Connect(CNicoVideoAuth &nicoVideoAuth,LPCTSTR url,NicoRecvCallBack callback,LPVOID userData){



	return NicoLiveStream_connect(self,nicoVideoAuth.GetAuth(),url,callback,userData);


}



VOID CNicoLiveStream::SetHeartBeatMsec(DWORD msec){

	NicoLiveStream_setHeartBeatMsec(self,msec);
	return;
}


DWORD CNicoLiveStream::GetHeartBeatMsec(){

	return NicoLiveStream_getHeartBeatMsec(self);
}


VOID CNicoLiveStream::SetHeartBeatFlag(BOOL flag){

	NicoLiveStream_setHeartBeatFlag(self,flag);
	return;
}



BOOL CNicoLiveStream::GetHeartBeatFlag(){

	return NicoLiveStream_getHeartBeatFlag(self);
}


VOID CNicoLiveStream::SetKeapALiveMsec(DWORD msec){

	NicoLiveStream_setKeapALiveMsec(self,msec);
	return;
}



DWORD CNicoLiveStream::GetKeapALiveMsec(){

	return NicoLiveStream_getKeapALiveMsec(self);

}


VOID CNicoLiveStream::SetKeapAliveFlag(BOOL flag){

	NicoLiveStream_setKeapALiveFlag(self,flag);
	return;
}


BOOL CNicoLiveStream::GetKeapAliveFlag(){

	return NicoLiveStream_getKeapALiveFlag(self);
}




NLIB_RESULT CNicoLiveStream::SendHeartBeat(){

	return NicoLiveStream_sendHeartBeat(self);
}


VOID CNicoLiveStream::DisConnect(){

	NicoLiveStream_disConnect(self);
}


NLIB_RESULT CNicoLiveStream::SendChat(CCommentMaker &commentMaker){
	commentMaker.mails.push_back(NULL);
	commentMaker.exAttribute.push_back(NULL);
	return NicoLiveStream_sendChat(self,commentMaker.chatString,&commentMaker.mails[0],&commentMaker.exAttribute[0]);


}

NLIB_RESULT CNicoLiveStream::SendOwnerChat(CCommentMaker &commentMaker){
	commentMaker.mails.push_back(NULL);
	commentMaker.exAttribute.push_back(NULL);
	return NicoLiveStream_sendOwnerChat(self,commentMaker.chatString,&commentMaker.mails[0],&commentMaker.exAttribute[0]);
}


	///
	///Xg[Xe[^XID擾
	///
	LPCTSTR CNicoLiveStream::GetId(){

		return NicoLiveStream_getId(self);
	}


	///
	///Xg[Xe[^X̃R~jeBԍ擾
	///
	LPCTSTR CNicoLiveStream::GetDefaultCommunity(){

		return NicoLiveStream_getDefaultCommunity(self);
	}


	///
	///Xg[Xe[^X̃voC_^Cv擾
	///
	PROVIDERTYPE CNicoLiveStream::GetProviderType(){

		return NicoLiveStream_getProviderType(self);
	}


	///
	///Xg[Xe[^X̃I[i[tO擾
	///
	BOOL CNicoLiveStream::IsOwner(){

		return NicoLiveStream_isOwner(self);
	}

	///
	///Xg[Xe[^X̊Jn擾
	///
	time_t CNicoLiveStream::GetStartTime(){

		return NicoLiveStream_getStartTime(self);
	}

	///
	///Xg[Xe[^X̏I擾
	///
	time_t CNicoLiveStream::GetEndTime(){

		return NicoLiveStream_getEndTime(self);
	}

	///
	///Xg[Xe[^X̊Jꎞ擾
	///
	time_t CNicoLiveStream::GetOpenTime(){

		return NicoLiveStream_getOpenTime(self);

	}

	///
	///Xg[Xe[^X̃x[X擾
	///
	time_t CNicoLiveStream::GetBaseTime(){

		return NicoLiveStream_getBaseTime(self);
	}


	///
	///Xg[Xe[^X̃^Cg擾
	///
	LPCTSTR CNicoLiveStream::GetTitle(){

		return NicoLiveStream_getTitle(self);
	}

	BOOL CNicoLiveStream::IsPremium(){

		return NicoLiveStream_isPremium(self);
	}

}


