#include "stdafx.h"
#include "nlite_include.h"

namespace nlite{
BOOL CCookieSettingWindow::OnInitDialog(CWindow wndFocus, LPARAM lInitParam){
	// XN[̒ɔzu
	CenterWindow();


	CButton radio;

	switch(this->browserType){

	case BT_INTERNET_EXPLORER:

		radio = GetDlgItem(IDC_RADIO_IE);

		break;

	case BT_FIRE_FOX:

		radio = GetDlgItem(IDC_RADIO_FIREFOX);

		break;


	case BT_GOOGLE_CHROME:

		radio = GetDlgItem(IDC_RADIO_CHROME);

		break;

	case BT_IE_COMPONENT:

		radio = GetDlgItem(IDC_RADIO_IECM);

		break;

	case BT_SAFARI:

		radio = GetDlgItem(IDC_RADIO_SAFARI);
		break;


	case BT_OPERA:

		radio = GetDlgItem(IDC_RADIO_OPERA);

		break;

	case BT_DEFAULT:

		radio = GetDlgItem(IDC_DEFAULT_BT_RADIO);

	default:
		goto skip;
	}
	radio.SetCheck(BST_CHECKED);
			
skip:
			
	return TRUE;
}

VOID CCookieSettingWindow::OnOK(UINT uNotifyCode, int nID, CWindow wndCtl){
	CButton ieRadio = GetDlgItem(IDC_RADIO_IE);
	CButton firefoxRadio = GetDlgItem(IDC_RADIO_FIREFOX);
	CButton chromeRadio = GetDlgItem(IDC_RADIO_CHROME);
	CButton iecmRadio = GetDlgItem(IDC_RADIO_IECM);
	CButton safariRadio = GetDlgItem(IDC_RADIO_SAFARI);
	CButton operaRadio = GetDlgItem(IDC_RADIO_OPERA);
	CButton defaultRadio = GetDlgItem(IDC_DEFAULT_BT_RADIO);

	if(ieRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_INTERNET_EXPLORER;
		
	}else if(firefoxRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_FIRE_FOX;

	}else if(chromeRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_GOOGLE_CHROME;

	}else if(iecmRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_IE_COMPONENT;

	}else if(safariRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_SAFARI;

	} else if(operaRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_OPERA;
	} else if(defaultRadio.GetCheck() == BST_CHECKED){

		this->browserType = BT_DEFAULT;

	}else {

		this->browserType = BT_NOSETTING;

	}



	EndDialog(nID);
}

VOID CCookieSettingWindow::OnCancel(UINT uNotifyCode, int nID, CWindow wndCtl){
	EndDialog(nID);
}

VOID CCookieSettingWindow::SetBrowserType(BROWSERTYPE browserType){
	
	this->browserType = browserType;


	return;
}

BROWSERTYPE CCookieSettingWindow::GetBrowserType(){
	return this->browserType;
}

VOID CColorSettingButton::OnLButtonDown(UINT wParam,CPoint &point){

	CColorDialog dlg(color);

	if(dlg.DoModal() == IDOK){
		this->SetColor(dlg.GetColor());
	}

	
	return;
}

VOID CColorSettingButton::SetColor(COLORREF in_color){

	color = in_color;
	if(brush.IsNull() != TRUE){
		brush.DeleteObject();
	}
	if(color != ListenerData::INIT_COLOR){

		brush.CreateSolidBrush(color);
		this->SetWindowText(TEXT(""));
	} else {
		brush.CreateSolidBrush(RGB(255,255,255));
		this->SetWindowText(TEXT("FݒȂ"));
	}

	return;
}

LRESULT CColorSettingButton::OnSetCursor(HWND wparam,UINT loLparam,UINT hiLparam){
	
	::SetCursor(::LoadCursor(NULL,IDC_HAND));

	return FALSE;

}

VOID CListenerSettingWindow::ShowSettingWindow(ListenerData &listenerData){

	this->ShowWindow(SW_HIDE);
	this->listenerData = &listenerData;
	

	backColorButton.SetColor(this->listenerData->bgcolor);
	nameColorButton.SetColor(this->listenerData->nameColor);
	
	idField.SetWindowText(listenerData.user_id);
	nameEdit.SetWindowText(listenerData.name);
	
	this->ShowWindow(SW_SHOW);
	return;
}


BOOL CListenerSettingWindow::OnInitDialog(CWindow wndFocus, LPARAM lInitParam){
	CenterWindow();
	nameEdit = GetDlgItem(IDC_NICKNAME_EDIT);
	
	nameColorButton.SubclassWindow(GetDlgItem(IDC_LT_NICKNAME_STATIC));
	backColorButton.SubclassWindow(GetDlgItem(IDC_LT_BACKCOLOR_STATIC));
	backColorReturnButton = GetDlgItem(IDC_BACKCOLOR_RETURN_BUTTON);
	nameColorReturnButton = GetDlgItem(IDC_NAMECOLOR_RETURN_BUTTON);
	idField = GetDlgItem(IDC_USERID_STATIC);
	return TRUE;
}

LRESULT CListenerSettingWindow::OnCtlColorStatic(HDC hdc,HWND hWnd){


	if(hWnd == nameColorButton){

		return (LRESULT)(HBRUSH)nameColorButton.brush;

	} else if(hWnd == backColorButton){


		return (LRESULT)(HBRUSH)backColorButton.brush;

	}

	return 0;
}





VOID CListenerSettingWindow::OnOK(UINT uNotifyCode, int nID, CWindow wndCtl){
   
	std::vector<TCHAR> nameBuf(nameEdit.GetWindowTextLength() + 1);
	nameEdit.GetWindowText(&nameBuf[0],nameBuf.size());
	this->listenerData->SetUserName(&nameBuf[0]);
	this->listenerData->SetBkColor( backColorButton.color);
	this->listenerData->SetNameColor( nameColorButton.color);
	



	::SendMessage(GetParent(),UM_UPDATEUI,(WPARAM)NULL,(LPARAM)NULL);

	
	this->ShowWindow(SW_HIDE);
	return;
}

VOID CListenerSettingWindow::OnCancel(UINT uNotifyCode, int nID, CWindow wndCtl){
  
	this->ShowWindow(SW_HIDE);
	return;
}


VOID CListenerSettingWindow::OnButton(UINT hiWParam,INT_PTR loWParam,HWND lParam){

	if(this->backColorReturnButton == lParam){

		backColorButton.SetColor(ListenerData::INIT_COLOR);

	} else if(this->nameColorReturnButton == lParam){

		nameColorButton.SetColor(ListenerData::INIT_COLOR);
	}

	return;
}




}