#include "stdafx.h"
#include "speaker_include.h"


namespace speaker{
namespace openJtalk{


///
///RXgN^
///
CMeiNormal::CMeiNormal(const TChar_P voiceDataDir,const TChar_P dictionaryDataDir)
{
	Initialize();
	Load(voiceDataDir,dictionaryDataDir);

}


///
///֐
///
void CMeiNormal::Initialize(){

	COpenJtalkCore::Initialize(true,48000,240,0.55,0,0.0,1600,0.5,false,0.7,0.5,1.0);

	return;
}


void CMeiNormal::Load(const TChar_P voiceDataDir,const TChar_P dictionaryDataDir){
	
	static char *mgc_winList[] = {"mgc.win1","mgc.win2","mgc.win3"};
	static char *lf0_winList[] = {"lf0.win1","lf0.win2","lf0.win3"};
	static char *lpf_winList[] = {"lpf.win1"};
	COpenJtalkCore::Load(
		voiceDataDir,dictionaryDataDir,
		"dur.pdf","tree-dur.inf",
		"mgc.pdf","tree-mgc.inf",mgc_winList,sizeof(mgc_winList)/sizeof(mgc_winList[0]),
		"lf0.pdf","tree-lf0.inf",lf0_winList,sizeof(lf0_winList)/sizeof(lf0_winList[0]),
		"lpf.pdf","tree-lpf.inf",lpf_winList,sizeof(lpf_winList)/sizeof(lpf_winList[0]),
		"gv-mgc.pdf","tree-gv-mgc.inf",
		"gv-lf0.pdf","tree-gv-lf0.inf",
		NULL,NULL,
		"gv-switch.inf"
		);

	return;
}


}
}