#include "sqlite3.h"
#include "sqliteManager.h"

 INLINE int SqliteManager_open(sqlite3 **pDb,LPCWSTR fileName,int flags,const char* zVfs){

	int rc;
	char fileNameMB[_MAX_PATH];

	WideToMB(CP_UTF8,fileName,fileNameMB,sizeof(fileNameMB));

	rc = sqlite3_open_v2( fileNameMB,pDb, flags, zVfs);
	
	
	if ( SQLITE_OK != rc )  {
		SqliteManager_close(pDb);
		goto end;
	}

	sqlite3_busy_timeout(*pDb,2000);

end:


	return rc;

}

INLINE VOID SqliteManager_close(sqlite3 **pDb){

	sqlite3_stmt *stmt = (sqlite3_stmt*)NULL, *next = (sqlite3_stmt*)NULL;

	if (sqlite3_close( *pDb ) != SQLITE_OK )  { /* f[^x[X𐳏ɃN[YłȂΈȉs */

	  /*** c̐ݒς݃vyA[hXe[ggsqlite3_finalizes ***/
	  stmt = sqlite3_next_stmt( *pDb, next );   /* ŏ̃vyA[hXe[gg */
	  while( NULL != stmt )  {
		next = sqlite3_next_stmt( *pDb, stmt ); /* ̃vyA[hXe[gg */
		sqlite3_finalize( stmt );			/* ̈J */

		stmt = next;
	  }
	  sqlite3_close( *pDb );  /* f[^x[XN[Y */
	}

	*pDb = (sqlite3*)NULL;

}

 INLINE int SqliteManager_prepare(sqlite3 *db, const void *sql, int bytes,sqlite3_stmt **stmt, const void **tail){

	int rc;
	if((rc = sqlite3_prepare16_v2( db, sql, bytes, stmt,tail)) != SQLITE_OK){

		sqlite3_finalize(*stmt);
		*stmt = (sqlite3_stmt*)NULL;

	}


	return rc;

}