package org.mineap.NNDD
{
	import flash.filesystem.File;
	
	import mx.controls.TileList;
	
	import org.mineap.NNDD.libraryManager.LibraryManager;
	import org.mineap.NNDD.model.NNDDVideo;
	
	/**
	 *
	 * TagManager.as
	 * 
	 * Copyright (c) 2008-2009 MAP - MineApplicationProject. All Rights Reserved.
	 *  
	 * @author shiraminekeisuke
	 * 
	 */
	public class TagManager
	{
		
		public var tagProvider:Array;
		public var tagMap:Object = new Object();
		public var tempTagArray:Array;
		private var libraryManager:LibraryManager;
		private var logManager:LogManager = LogManager.instance;
		
		private static const _tagManager:TagManager = new TagManager();
		
		/**
		 * シングルトンパターン
		 */
		public function TagManager()
		{
			if(_tagManager != null){
				throw new ArgumentError("TagManagerはインスタンス化できません。");
			}
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */
		public static function get instance():TagManager{
			return _tagManager;
		}
		
		/**
		 * 
		 * @param dataProvider
		 * @return 
		 * 
		 */
		public function initialize(dataProvider:Array):void{
			this.libraryManager = LibraryManager.instance;
			this.tagProvider = dataProvider;
		}
		
		/**
		 * 
		 * 
		 */
		public function loadTag():void{
			
			var array:Array = libraryManager.collectTag();
			for(var i:int=0; i<array.length; i++){
				if(!isExists(array[i])){
					tagProvider.push(array[i]);
					tagMap[String(array[i])] = String(array[i]);
				}
			}
			
			tagProvider.sort();
			tagProvider.unshift("すべて");
			
			logManager.addLog("ローカルのタグ情報を表示(すべて):" + tagProvider.length);
		}
		
		/**
		 * 
		 * @param tag
		 * @return 
		 * 
		 */
		public function isExists(tag:String):Boolean{
			if(tagMap[tag] != null){
				return true;
			}
			return false;
		}
		
		/**
		 * 指定されたディレクトリに対応するタグを取得し、表示します。
		 * ディレクトリを指定しない場合はすべてのタグを取得して表示します。
		 * @param dir
		 * 
		 */
		public function tagRenew(tileList:TileList, dir:File = null):void{
			
			tagProvider.splice(0, tagProvider.length);
			tagMap = new Object();
			
			if(dir == null){
				loadTag();
				
			}else{
				var array:Array = libraryManager.collectTag(dir);
				
				for(var i:int=0; i<array.length; i++){
					if(!isExists(array[i])){
						tagProvider.push(array[i]);
						tagMap[String(array[i])] = String(array[i]);
					}
				}
				
				tagProvider.sort();
				tagProvider.unshift("すべて");
				
				logManager.addLog("ローカルのタグ情報を表示(ディレクトリ指定):" + dir.nativePath + ":" + tagProvider.length);
			}
			
			tileList.dataProvider = tagProvider;
		}
		
		/**
		 * 
		 * @param tileList
		 * @param playList
		 * 
		 */
		public function tagRenewOnPlayList(tileList:TileList, videoArray:Array):void{
			tagProvider.splice(0, tagProvider.length);
			tagMap = new Object();
			
			var videoNameArray:Array = new Array();
			for each(var video:NNDDVideo in videoArray){
				videoNameArray.push(video.getVideoNameWithVideoID());
			}
			
			var array:Array = libraryManager.collectTagByVideoName(videoNameArray);
			for(var i:int=0; i<array.length; i++){
				if(!isExists(array[i])){
					tagProvider.push(array[i]);
					tagMap[String(array[i])] = String(array[i]);
				}
			}
			
			tagProvider.sort();
			tagProvider.unshift("すべて");
			
			logManager.addLog("プレイリストのタグ情報を表示:" + tagProvider.length);
			
			tileList.dataProvider = tagProvider;
		}
		
		
		/**
		 * タグ表示用のTileListを更新します。
		 * @param words
		 * 
		 */
		public function searchTagAndShow(words:Array):void{
			
			var newTagProvider:Array = new Array();
			for(var i:int = 0; i < tagProvider.length; i++ ){
				var existCount:int = 0;
				var tag:String = tagProvider[i];
				tag = tag.toUpperCase();
				for(var j:int = 0; j<words.length; j++){
					
					var tempWord:String = words[j];
					tempWord = tempWord.toUpperCase();
					
					if(j < 1){
						if(tag.indexOf(tempWord) != -1){
							existCount++;
						}
					}else if(tempWord != " "){
						tempWord = tempWord.substring(1).toUpperCase();
						if(tag.indexOf(tempWord) != -1){
							existCount++;
						}
					}else{
						existCount++;
					}
				}
				if(existCount >= words.length){
					//発見した項目を追加
					newTagProvider.push(tagProvider[i]);
				}
			}
			
			newTagProvider.sort();
			tagProvider = newTagProvider;
			
		}
		

	}
}