############################################################## -*- Makefile -*-
#
# Makefile for nodoka (Visual C++)
#
#	make release version: nmake nodebug=1
#	make debug version: nmake
#
###############################################################################

!if "$(BOOST_VER)" == ""
BOOST_VER	= 1_32
!endif
INCLUDES	= -I$(BOOST_DIR)	# why here ?
DEPENDIGNORE	= --ignore=$(BOOST_DIR)

!if "$(NODOKA_VC)" == ""
NODOKA_VC	= vct
!endif

!if ( "$(NODOKA_VC)" == "vct" )
NODOKA_REGEX_VC	= vc71
!else
NODOKA_REGEX_VC	= $(NODOKA_VC)
!endif

!if ( "$(RETAIL)" == "1" )
RETAIL_FLAG = -DRETAIL
!else
RETAIL_FLAG = 
!endif

!include <vc.mak>
!include <nodoka-common.mak>

DEFINES		= $(COMMON_DEFINES) $(RETAIL_FLAG) -DVERSION=""""$(VERSION)"""" \
		-DLOGNAME=""""$(LOGNAME)"""" \
		-DCOMPUTERNAME=""""$(COMPUTERNAME)""""
		
# INCLUDES	= -I$(BOOST_DIR)	# make -f nodoka-vc.mak depend fails ...

LDFLAGS_1	=						\
		$(guilflags)					\
		/PDB:$(TARGET_1).pdb				\
#		/DEBUG /PDB:$(TARGET_1).pdb				\
		/LIBPATH:$(BOOST_DIR)/libs/regex/build/$(NODOKA_REGEX_VC)	\

LDFLAGS_2	=						\
		$(dlllflags)					\
		/PDB:$(TARGET_2).pdb				\
#		/DEBUG /PDB:$(TARGET_2).pdb				\
		/LIBPATH:$(BOOST_DIR)/libs/regex/build/$(NODOKA_REGEX_VC)	\

$(TARGET_1):	$(OBJS_1) $(RES_1) $(EXTRADEP_1)
	$(link) -out:$@ $(ldebug) $(LDFLAGS_1) $(OBJS_1) $(LIBS_1) $(RES_1)

$(TARGET_2):	$(OBJS_2) $(RES_2) $(EXTRADEP_2)
	$(link) -out:$@ $(ldebug) $(LDFLAGS_2) $(OBJS_2) $(LIBS_2) $(RES_2)

$(TARGET_3):	$(DLL_3)

REGEXPP_XCFLAGS	= $(REGEXPP_XCFLAGS) XCFLAGS=-D_WCTYPE_INLINE_DEFINED

clean::
		-$(RM) nodoka.aps nodoka.opt *.pdb

boost:
		cd $(BOOST_DIR)/libs/regex/build/
		$(MAKE) -f $(NODOKA_REGEX_VC).mak $(REGEXPP_XCFLAGS) main_dir libboost_regex-$(NODOKA_REGEX_VC)-mt-s-$(BOOST_VER)_dir ./$(NODOKA_REGEX_VC)/libboost_regex-$(NODOKA_REGEX_VC)-mt-s-$(BOOST_VER).lib
		cd ../../../../nodoka

distclean::	clean
		cd $(BOOST_DIR)/libs/regex/build/
		-$(MAKE) -k -f $(NODOKA_REGEX_VC).mak clean
		cd ../../../../nodoka

batch:
!if "$(NODOKA_VC)" != "vct"
		-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT
!endif
	-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT nodebug=1
		cd s
		-$(MAKE) -k -f setup-vc.mak NODOKA_VC=$(NODOKA_VC) batch
		cd ..

batch_clean:
		-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT nodebug=1 clean
		-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT clean
		cd s
		-$(MAKE) -k -f setup-vc.mak NODOKA_VC=$(NODOKA_VC) batch_clean
		cd ..

batch_distclean: batch_clean
		-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT distclean

batch_distrib: batch
		-$(MAKE) -k -f nodoka-vc.mak NODOKA_VC=$(NODOKA_VC) TARGETOS=WINNT nodebug=1 distrib
