// nodoka_helper.cpp
//

#include "stdafx.h"
#include "nodoka_helper.h"
#include "nodoka.h"
#include "hook.h"
#include "windowstool.h"
//#include <Msctf.h>
#include "..\sirius_sdk\commonValues.h"

#define MAX_LOADSTRING 100

typedef SIRIUS_HOOK_API CcommonValues* (*SiriusSetupHookPtr)(DWORD dwMessageId);
typedef SIRIUS_HOOK_API void* (*SiriusReleaseHookPtr)();

// O[oϐ:
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX

// for Sirius TSF SDK
HMODULE hMsctf = NULL;
SiriusSetupHookPtr mySiriusSetupHook;
SiriusReleaseHookPtr mySiriusReleaseHook;
CcommonValues* pCv;

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	MSG msg;

	// dN`FbN܂B
	HANDLE mutex = CreateMutex(	(SECURITY_ATTRIBUTES *)NULL, TRUE, MUTEX_NODOKA_HELPER_EXCLUSIVE_RUNNING );
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		return FALSE;
	}

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_NODOKA_HELPER, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	CHECK_FALSE( installHooks() );

	// load sirius_hook dll
	hMsctf = LoadLibraryA("sirius_hook_x86.dll");

	mySiriusSetupHook = (SiriusSetupHookPtr)GetProcAddress(hMsctf, "SiriusSetupHook");
	mySiriusReleaseHook = (SiriusReleaseHookPtr)GetProcAddress(hMsctf, "SiriusReleaseHook");

	DWORD wm_sirius_control = RegisterWindowMessage(L"WM_SIRIUS_CONTROL");

	pCv = mySiriusSetupHook(wm_sirius_control);

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	// unload Sirius
	mySiriusReleaseHook();
	FreeLibrary(hMsctf);

	CHECK_FALSE( uninstallHooks() );
	CHECK_TRUE( CloseHandle(mutex) );

	return (int) msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;
	ZeroMemory(&wcex, sizeof(wcex));
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.lpfnWndProc	= WndProc;
	wcex.hInstance		= hInstance;
	wcex.lpszClassName	= szWindowClass;

	return RegisterClassEx(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   hWnd = CreateWindowEx(0, szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      0, 0, 0, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }
   	// Set ChangeWindowMessageFilter
	//HMODULE dll = LoadLibrary(TEXT("user32.dll"));
	FUNCTYPE ChangeWindowMessageFilter = (FUNCTYPE)GetProcAddress(LoadLibrary(TEXT("user32.dll")) , "ChangeWindowMessageFilter");

	if(ChangeWindowMessageFilter != NULL)
		{
		BOOL bFlag = ChangeWindowMessageFilter(WM_APP + 101, MSGFLT_ADD);	// WM_APP_taskTrayNotify 
		if(bFlag){
			//OutputDebugString(L"ChangeWindowMessageFilter OK\n");
			}
		else
			{
			//OutputDebugString(L"ChangeWindowMessageFilter NG\n");
			}

		ChangeWindowMessageFilter(WM_APP + 102, MSGFLT_ADD);	// WM_APP_msgStreamNotify
		ChangeWindowMessageFilter(WM_APP + 103, MSGFLT_ADD);	// WM_APP_notifyFocus
		ChangeWindowMessageFilter(WM_APP + 104, MSGFLT_ADD);	// WM_APP_notifyVKey
		ChangeWindowMessageFilter(WM_APP + 105, MSGFLT_ADD);	// WM_APP_targetNotify
		ChangeWindowMessageFilter(WM_APP + 110, MSGFLT_ADD);	// WM_APP_engineNotify
		ChangeWindowMessageFilter(WM_APP + 115, MSGFLT_ADD);	// WM_APP_dlglogNotify
		ChangeWindowMessageFilter(WM_APP + 116, MSGFLT_ADD);	// WM_APP_SendKey
		ChangeWindowMessageFilter(WM_APP + 120, MSGFLT_ADD);	// WM_APP_NotifyThreadDetach
		ChangeWindowMessageFilter(WM_APP + 122, MSGFLT_ADD);	// WM_APP_NotifyLockState
		ChangeWindowMessageFilter(WM_APP + 201, MSGFLT_ADD);	// for Touchpad
		ChangeWindowMessageFilter(WM_APP + 202, MSGFLT_ADD);	// for gamepad
		ChangeWindowMessageFilter(WM_APP + 203, MSGFLT_ADD);	// for mouse

		UINT WM_NODOKA_MESSAGE = RegisterWindowMessage(addSessionId(WM_NODOKA_MESSAGE_NAME).c_str());

		ChangeWindowMessageFilter(WM_NODOKA_MESSAGE, MSGFLT_ADD);	// for Touchpad

		ChangeWindowMessageFilter(WM_CREATE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_DESTROY, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_MOVE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SIZE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_ACTIVATE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SETFOCUS, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_KILLFOCUS, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_PAINT, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_CLOSE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_QUERYENDSESSION, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_ACTIVATEAPP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_MOUSEACTIVATE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_COPYDATA, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_NOTIFY, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SETICON, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_NCDESTROY, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_NCHITTEST, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_NCACTIVATE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_GETDLGCODE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_KEYDOWN, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_KEYUP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_CHAR, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_DEADCHAR, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SYSKEYDOWN, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SYSKEYUP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_IME_STARTCOMPOSITION	, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_IME_ENDCOMPOSITION, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_INITDIALOG, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_COMMAND, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SYSCOMMAND, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_TIMER, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_MOUSEMOVE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_LBUTTONDOWN, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_LBUTTONUP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_ENTERMENULOOP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_EXITMENULOOP, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_SIZING, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_IME_NOTIFY, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_WTSSESSION_CHANGE, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_LBUTTONDBLCLK, MSGFLT_ADD);	// 
		ChangeWindowMessageFilter(WM_MBUTTONDOWN, MSGFLT_ADD);	// 
		}

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
