/*
 * scancode2.cpp
 *
 *  Created on: 2009/09/05
 *      Author: uchan
 */

#include <bitnos/scancode1.h>

const uint8_t ScanCode01::table[128] =
    {
        0x00,0x83,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,'0' ,'-' ,'^' ,'\b','\t',
        'Q' ,'W' ,'E' ,'R' ,'T' ,'Y' ,'U' ,'I' ,'O' ,'P' ,'@' ,'[' ,'\n',0x87,'A' ,'S' ,
        'D' ,'F' ,'G' ,'H' ,'J' ,'K' ,'L' ,';' ,':' ,0x96,0x86,']' ,'Z' ,'X' ,'C' ,'V' ,
        'B' ,'N' ,'M' ,',' ,'.' ,'/' ,0x89,'*' ,0x88,' ' ,0x82,0xa0,0xa1,0xa2,0xa3,0xa4,
        0xa5,0xa6,0xa7,0xa8,0xa9,0x81,0x80,'7' ,'8' ,'9' ,'-' ,'4' ,'5' ,'6' ,'+' ,'1' ,
        '2' ,'3' ,'0' ,'.' ,0x00,0x00,0x00,0xaa,0xab,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x97,0x00,0x00,0x98,0x00,0x00,0x00,0x00,0x00,0x99,0x00,0x00,0x9a,'\\',0x00,0x00,
    };

const uint8_t ScanCode01::tableE0[128] =
    {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'\n',0x8a,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,'/' ,0x00,0x84,0x8b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x8c,0x94,0x00,0x8e,0x00,0x8f,0x00,0x93,
        0x8d,0x95,0x90,0x91,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xc1,0xc2,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    };


ScanCode::Code ScanCode01::Convert(uint8_t* scancode)
{
  Code result;
  result.code = 0;

  if (scancode[0] != 0xe0 && scancode[0] != 0xe1) {
    if (scancode[2] == 0xe1 && scancode[1] == 0x1d && scancode[0] == 0x45) {
      result.code = Keys::KeyPause;
    } else if (scancode[2] == 0xe1 && scancode[1] == 0x9d && scancode[0] == 0xc5) {
        result.code = Keys::KeyPause + Keys::FlagBreak;
    } else {
      if (scancode[1] == 0xe0) {
        result.code = tableE0[scancode[0] & 0x7f];
        if (scancode[0] == 0x35 || scancode[0] == 0x1c) {
          result.code |= Keys::FlagKeypad;
        }
      } else {
        result.code = table[scancode[0] & 0x7f];
        if ((0x47 <= scancode[0] && scancode[0] <= 0x53) ||
            scancode[0] == 0x37) {
          result.code |= Keys::FlagKeypad;
        }
      }
      if ((scancode[0] & 0x80) != 0) {
        result.code |= Keys::FlagBreak;
      }
    }
  }
  return result;
}
