﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Imaging;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ColorDialog
{
    internal partial class BaseColorDialog : UserControl
    {
        public event EventHandler ColorChanged;
        private BufferedGraphics grafx;
        private BufferedGraphicsContext context;
        int bigrad = 78;
        int smallrad = 62;
        int squaresize = 86;
        int basepoint = 37;
        Point currentpoint;
        Color basecolor = Color.FromArgb(255, 255, 0, 255);
        Color currentcolor = Color.FromArgb(255, 255, 0, 255);
        Bitmap bigcircle;
        Bitmap smallcircle;
        Bitmap verysmallcircle;
        Bitmap colorcircle;
        Point lastpos = new Point(0, 0);
        public BaseColorDialog()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint, true);
            /*bigcircle = AntiariasedCircle.Create(bigrad, 1.5f, 4, Color.FromArgb(0, 0, 0));
            smallcircle = AntiariasedCircle.Create(smallrad, 1.5f, 4, Color.FromArgb(0, 0, 0));
            verysmallcircle = AntiariasedCircle.Create(5, 2, 4, Color.FromArgb(0, 0, 0));*/
            bigcircle = ColorDialog.Properties.Resources.bigcircle;
            smallcircle = ColorDialog.Properties.Resources.smallcircle;
            verysmallcircle = ColorDialog.Properties.Resources.verysmallcircle;
            colorcircle = ColorDialog.Properties.Resources.colorcircle;
            //CreateColorCircle();
            currentpoint = new Point(squaresize, 0);
            timer1.Interval = 10;
            timer1.Tick += new EventHandler(timer1_Tick);
            timer2.Interval = 10;
            timer2.Tick += new EventHandler(timer2_Tick);
            context = BufferedGraphicsManager.Current;
            context.MaximumBuffer = new Size(this.Width + 1, this.Height + 1);
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            grafx = context.Allocate(this.CreateGraphics(), new Rectangle(0, 0, this.Width, this.Height));
            DrawToBuffer(grafx.Graphics);
        }

        void timer2_Tick(object sender, EventArgs e)
        {
            Point p = this.PointToClient(Cursor.Position);
            if (p.X <= basepoint) p.X = basepoint;
            if (p.X >= basepoint + squaresize) p.X = basepoint + squaresize;
            if (p.Y <= basepoint) p.Y = basepoint;
            if (p.Y >= basepoint + squaresize) p.Y = basepoint + squaresize;
            if (lastpos.X == p.X && lastpos.Y == p.Y) return;
            currentpoint = new Point(p.X - basepoint, p.Y - basepoint);
            Caliculatecurrentcolor();
            DrawToBuffer(grafx.Graphics);
            if (ColorChanged != null)
            {
                ColorChanged.Invoke(this, new EventArgs());
            }
            Refresh();
            lastpos = p;
        }

        void timer1_Tick(object sender, EventArgs e)
        {
            Point p = this.PointToClient(Cursor.Position);
            if (lastpos.X == p.X && lastpos.Y == p.Y) return;
            double length = Math.Pow(p.X - bigrad, 2) + Math.Pow(p.Y - bigrad, 2);
            double rad = 0;
            if (p.Y > bigrad)
            {
                rad = Math.Acos((p.X - bigrad) / Math.Sqrt(length));
            }
            else
            {
                rad = Math.PI * 2 - Math.Acos((p.X - bigrad) / Math.Sqrt(length));
            }
            basecolor = CaliculateColor(rad);
            Caliculatecurrentcolor();
            DrawToBuffer(grafx.Graphics);
            if (ColorChanged != null)
            {
                ColorChanged.Invoke(this, new EventArgs());
            }
            Refresh();
            lastpos = p;
        }

        private void MyColorDialog_Paint(object sender, PaintEventArgs e)
        {
            grafx.Render(e.Graphics);
        }
        private void DrawToBuffer(Graphics g)
        {
            Color Fillcolor = this.BackColor;
            g.FillRectangle(Brushes.White, new Rectangle(0, 0, this.Width, this.Height));
            g.DrawImage(bigcircle, new Point(-5, -5));
            g.DrawImage(colorcircle, new Point(5, 5));
            g.DrawImage(smallcircle, new Point(12, 12));
            g.DrawImage(verysmallcircle, Caliculatepos());
            DrawColorsquare(g);
            g.DrawImage(verysmallcircle, new Point(currentpoint.X + basepoint - 12, currentpoint.Y + basepoint - 12));
            g.DrawRectangle(Pens.Black, new Rectangle(54, 163, 53, 23));
            FillRectangle(g, currentcolor, new Rectangle(56, 165, 50, 20));
        }
        private void DrawColorsquare(Graphics g)
        {
            int temp = squaresize * 3;
            byte[] buffer;
            int stride = 0;
            if (temp % 4 == 0)
            {
                stride = temp;
            }
            else
            {
                stride = temp + 4 - temp % 4;
            }
            buffer = new byte[stride * squaresize];
            for (int i = 0; i < squaresize; i++)
            {
                for (int j = 0; j < squaresize; j++)
                {
                    int topr = (byte)((float)j / squaresize * basecolor.R + (float)(squaresize - j) / squaresize * 255);
                    int topg = (byte)((float)j / squaresize * basecolor.G + (float)(squaresize - j) / squaresize * 255);
                    int topb = (byte)((float)j / squaresize * basecolor.B + (float)(squaresize - j) / squaresize * 255);
                    topr = topr - 3 * (squaresize - i) <= 0 ? 0 : topr - 3 * (squaresize - i);
                    topg = topg - 3 * (squaresize - i) <= 0 ? 0 : topg - 3 * (squaresize - i);
                    topb = topb - 3 * (squaresize - i) <= 0 ? 0 : topb - 3 * (squaresize - i);
                    buffer[i * stride + j * 3] = (byte)topb;
                    buffer[i * stride + j * 3 + 1] = (byte)topg;
                    buffer[i * stride + j * 3 + 2] = (byte)topr;
                }
            }
            GCHandle GcHandle = GCHandle.Alloc(buffer, GCHandleType.Pinned);
            IntPtr scan0 = (IntPtr)(GcHandle.AddrOfPinnedObject().ToInt32() + (squaresize - 1) * stride);
            Bitmap bitmap = new Bitmap(squaresize, squaresize, -stride, PixelFormat.Format24bppRgb, scan0);
            g.DrawImage(bitmap, new Point(basepoint, basepoint));
            bitmap.Dispose();
            GcHandle.Free();
        }
        private void Caliculatecurrentcolor()
        {
            int r = basecolor.R, g = basecolor.G, b = basecolor.B;
            r -= currentpoint.Y * 3;
            g -= currentpoint.Y * 3;
            b -= currentpoint.Y * 3;
            if (r < 0) r = 0;
            if (g < 0) g = 0;
            if (b < 0) b = 0;
            int max = r;
            if (r > g)
            {
                if (r > b)
                {
                    max = r;
                }
                else
                {
                    max = b;
                }
            }
            else
            {
                if (g > b)
                {
                    max = g;
                }
                else
                {
                    max = b;
                }
            }
            r = max - (max - r) * currentpoint.X / squaresize;
            g = max - (max - g) * currentpoint.X / squaresize;
            b = max - (max - b) * currentpoint.X / squaresize;
            currentcolor = Color.FromArgb(r, g, b);
        }
        private Point Caliculatepos()
        {
            double rad = 0;
            if (basecolor.R == 255)
            {
                rad = Math.PI / 3 + Math.PI / 3 * basecolor.G / 255 - Math.PI / 3 * basecolor.B / 255;
            }
            else if (basecolor.G == 255)
            {
                rad = Math.PI + Math.PI / 3 * basecolor.B / 255 - Math.PI / 3 * basecolor.R / 255;
            }
            else
            {
                rad = Math.PI / 3 * 5 + Math.PI / 3 * basecolor.R / 255 - Math.PI / 3 * basecolor.G / 255;
            }
            Point center = new Point(bigrad, bigrad);
            Point vec1 = new Point((int)((smallrad + 9) * Math.Cos(rad)), (int)((smallrad + 9) * Math.Sin(rad)));
            Point vec2 = new Point(-10, -10);
            Point p = new Point(center.X + vec1.X + vec2.X, center.Y + vec1.Y + vec2.Y);
            return p;
        }
        public void CreateColorCircle()
        {
            int circlebig = bigrad - 3;
            int circlebig2 = circlebig * circlebig;
            int circlesmall2 = (int)Math.Pow(smallrad + 3, 2);
            int center = circlebig;
            int length = circlebig * 2 + 10;
            int stride = length * 4;
            byte[] buffer = new byte[length * stride];
            float onebythreepi = (float)Math.PI / 3;
            float twobythreepi = onebythreepi * 2;
            float threebythreepi = onebythreepi * 3;
            float forbythreepi = onebythreepi * 4;
            float fivebythreepi = onebythreepi * 5;
            for (int i = 0; i < length; i++)
            {
                for (int j = 0; j < length; j++)
                {
                    float[] poss = new float[]{
                        (float)(Math.Pow(i - center, 2) + Math.Pow(j - center, 2)),
                        (float)(Math.Pow(i - center, 2) + Math.Pow(j + 1 - center, 2)),
                        (float)(Math.Pow(i + 1 - center, 2) + Math.Pow(j - center, 2)),
                        (float)(Math.Pow(i + 1 - center, 2) + Math.Pow(j + 1 - center, 2))
                    };
                    //checkincirclesmall
                    if (poss[0] < circlesmall2 && poss[1] < circlesmall2 && poss[2] < circlesmall2 && poss[3] < circlesmall2)
                    {
                        buffer[(length - 1 - i) * stride + j * 4 + 3] = 0;
                        continue;
                    }
                    //lastlize
                    int devidenum = 4;
                    int count = 0;
                    for (int k = 0; k < devidenum; k++)
                    {
                        for (int l = 0; l < devidenum; l++)
                        {
                            float pos = (float)(Math.Pow(i - center + (float)l / devidenum, 2) + Math.Pow(j - center + (float)k / devidenum, 2));
                            if (pos >= circlesmall2 && pos <= circlebig2)
                            {
                                count++;
                            }
                        }
                    }
                    byte a = (byte)(255 * count / (devidenum * devidenum));
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (a != 0)
                    {
                        float rad = 0;
                        if (i > circlebig)
                        {
                            rad = (float)(Math.PI * 2 - Math.Acos((j - circlebig) / Math.Sqrt(poss[0])));
                        }
                        else
                        {
                            rad = (float)(Math.Acos((j - circlebig) / Math.Sqrt(poss[0])));
                        }
                        if (0 <= rad && rad <= twobythreepi)
                        {
                            r = 255;
                            if (onebythreepi < rad)
                            {
                                g = (int)(255 * (rad - onebythreepi) / onebythreepi);
                                b = 0;
                            }
                            else
                            {
                                g = 0;
                                b = (int)(255 * (onebythreepi - rad) / onebythreepi);
                            }
                        }
                        else if (twobythreepi < rad && rad <= forbythreepi)
                        {
                            g = 255;
                            if (threebythreepi < rad)
                            {
                                r = 0;
                                b = (int)(255 * (rad - threebythreepi) / onebythreepi);
                            }
                            else
                            {
                                r = (int)(255 * (threebythreepi - rad) / onebythreepi);
                                b = 0;
                            }
                        }
                        else
                        {
                            b = 255;
                            if (fivebythreepi < rad)
                            {
                                r = (int)(255 * (rad - fivebythreepi) / onebythreepi);
                                g = 0;
                            }
                            else
                            {
                                r = 0;
                                g = (int)(255 * (fivebythreepi - rad) / onebythreepi);
                            }
                        }
                    }
                    buffer[(length - 1 - i) * stride + j * 4] = (byte)r;
                    buffer[(length - 1 - i) * stride + j * 4 + 1] = (byte)g;
                    buffer[(length - 1 - i) * stride + j * 4 + 2] = (byte)b;
                    buffer[(length - 1 - i) * stride + j * 4 + 3] = a;
                }
            }
            GCHandle GcHandle = GCHandle.Alloc(buffer, GCHandleType.Pinned);
            IntPtr scan0 = (IntPtr)(GcHandle.AddrOfPinnedObject().ToInt32() + (length - 1) * stride);
            Bitmap bit = new Bitmap(length, length, -stride, PixelFormat.Format32bppArgb, scan0);
            colorcircle = new Bitmap(bit);
            bit.Dispose();
            GcHandle.Free();
        }
        private Color CaliculateColor(double rad)
        {
            double twobythreepi = Math.PI * 2 / 3;
            double onebythreepi = Math.PI / 3;
            int r, g, b;
            if (0 <= rad && rad <= twobythreepi)
            {
                r = 255;
                if (onebythreepi < rad)
                {
                    g = (int)(255 * (rad - onebythreepi) / onebythreepi);
                    b = 0;
                }
                else
                {
                    g = 0;
                    b = (int)(255 * (onebythreepi - rad) / onebythreepi);
                }
            }
            else if (twobythreepi < rad && rad <= twobythreepi * 2)
            {
                g = 255;
                if (onebythreepi * 3 < rad)
                {
                    r = 0;
                    b = (int)(255 * (rad - onebythreepi * 3) / onebythreepi);
                }
                else
                {
                    r = (int)(255 * (onebythreepi * 3 - rad) / onebythreepi);
                    b = 0;
                }
            }
            else
            {
                b = 255;
                if (onebythreepi * 5 < rad)
                {
                    r = (int)(255 * (rad - onebythreepi * 5) / onebythreepi);
                    g = 0;
                }
                else
                {
                    r = 0;
                    g = (int)(255 * (onebythreepi * 5 - rad) / onebythreepi);
                }
            }
            Color c = Color.FromArgb(r, g, b);
            return c;
        }
        public Color BaseColor
        {
            get
            {
                return basecolor;
            }
            set
            {
                basecolor = value;
                Refresh();
            }
        }
        private void FillRectangle(Graphics g, Color c, Rectangle rec)
        {
            int stride = rec.Width * 3;
            if (stride % 4 != 0)
            {
                stride = stride + 4 - stride % 4;
            }
            byte[] buffer = new byte[stride * rec.Height];
            for (int i = 0; i < rec.Height; i++)
            {
                for (int j = 0; j < rec.Width; j++)
                {
                    buffer[i * stride + j * 3] = c.B;
                    buffer[i * stride + j * 3 + 1] = c.G;
                    buffer[i * stride + j * 3 + 2] = c.R;
                }
            }
            GCHandle GcHandle = GCHandle.Alloc(buffer, GCHandleType.Pinned);
            IntPtr scan0 = (IntPtr)(GcHandle.AddrOfPinnedObject().ToInt32() + (rec.Height - 1) * stride);
            Bitmap bitmap = new Bitmap(rec.Width, rec.Height, -stride, PixelFormat.Format24bppRgb, scan0);
            g.DrawImage(bitmap, new Point(rec.X, rec.Y));
            bitmap.Dispose();
            GcHandle.Free();
        }
        private void MyColorDialog_MouseDown(object sender, MouseEventArgs e)
        {
            Point p = this.PointToClient(Cursor.Position);
            double length = Math.Pow(p.X - bigrad, 2) + Math.Pow(p.Y - bigrad, 2);
            if (smallrad * smallrad <= length && length <= bigrad * bigrad)
            {
                timer1.Start();
            }
            else if (basepoint <= p.X && p.X <= basepoint + squaresize && basepoint <= p.Y && p.Y <= basepoint + squaresize)
            {
                timer2.Start();
            }
        }

        private void MyColorDialog_MouseUp(object sender, MouseEventArgs e)
        {
            timer1.Stop();
            timer2.Stop();
        }
        public Color CurrentColor
        {
            get
            {
                return currentcolor;
            }
            set
            {
                currentcolor = value;
                int r = currentcolor.R, g = currentcolor.G, b = currentcolor.B;
                int[] array = new int[] { r, g, b };
                Array.Sort(array);
                if (array[2] == 0)
                {
                    currentpoint = new Point(squaresize, squaresize);
                }
                else
                {
                    if (array[2] == r) r = 255;
                    else if (array[2] == g) g = 255;
                    else if (array[2] == b) b = 255;
                    if (array[0] == r) r = 0;
                    else if (array[0] == g) g = 0;
                    else if (array[0] == b) b = 0;
                    int mid = (int)((float)255 / array[2] * array[1]);
                    if (array[1] == r) r = mid;
                    else if (array[1] == g) g = mid;
                    else if (array[1] == b) b = mid;
                    basecolor = Color.FromArgb(r, g, b);
                    int y = squaresize * (255 - array[2]) / 255;
                    int x = squaresize * (255 - array[0]) / 255;
                    currentpoint = new Point(x, y);
                }
                DrawToBuffer(grafx.Graphics);
                Refresh();
            }
        }
    }
}
