﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing.Imaging;
using System.Windows.Forms;

namespace ColorDialog
{
    public partial class CustomColorDialog : Form
    {
        bool ignorechange = false;
        Color displaycolor;
        public CustomColorDialog()
        {
            InitializeComponent();
            baseColorDialog1.ColorChanged += new EventHandler(baseColorDialog1_ColorChanged);
        }

        void baseColorDialog1_ColorChanged(object sender, EventArgs e)
        {
            ignorechange = true;
            Color c = baseColorDialog1.CurrentColor;
            this.textBox1.Text = c.R.ToString();
            this.textBox2.Text = c.G.ToString();
            this.textBox3.Text = c.B.ToString();
            ignorechange = false;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (ignorechange) return;
            ChangeColorFromTextBox();
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            if (ignorechange) return;
            ChangeColorFromTextBox();
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            if (ignorechange) return;
            ChangeColorFromTextBox();
        }
        private void ChangeColorFromTextBox()
        {
            int r = 0, g = 0, b = 0;
            if (!int.TryParse(this.textBox1.Text, out r))
            {
                MessageBox.Show("変換エラーです\nR:int");
                return;
            }
            if (!int.TryParse(this.textBox2.Text, out g))
            {
                MessageBox.Show("変換エラーです\nG:int");
                return;
            }
            if (!int.TryParse(this.textBox3.Text, out b))
            {
                MessageBox.Show("変換エラーです\nB:int");
                return;
            }
            if (r < 0 || r > 255)
            {
                MessageBox.Show("0以上255未満の数字を入力してください\nR:int");
                return;
            }
            if (g < 0 || g > 255)
            {
                MessageBox.Show("0以上255未満の数字を入力してください\nG:int");
                return;
            }
            if (b < 0 || b > 255)
            {
                MessageBox.Show("0以上255未満の数字を入力してください\nB:int");
                return;
            }
            Color c = Color.FromArgb(r, g, b);
            baseColorDialog1.CurrentColor = c;
        }
        public Color CurrentColor
        {
            get
            {
                return baseColorDialog1.CurrentColor;
            }
            set
            {
                ignorechange = true;
                baseColorDialog1.CurrentColor = value;
                this.textBox1.Text = value.R.ToString();
                this.textBox2.Text = value.G.ToString();
                this.textBox3.Text = value.B.ToString();
                ignorechange = false;
            }
        }
    }
}
