﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace NotepadNeue
{
    public partial class AudioControl : UserControl
    {
        int current = 50;
        int maximum = 100;
        int imagewidth = 84;
        int startx = 22;
        int lastx = 0;
        bool mute = false;
        public event EventHandler OnBarMove;
        public event EventHandler OnMute;
        public event EventHandler OnNonMute;
        private BufferedGraphics grafx;
        private BufferedGraphicsContext context;
        public AudioControl()
        {
            InitializeComponent();
            this.timer1.Interval = 20;
            this.timer1.Tick += new EventHandler(timer1_Tick);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint, true);
            context = BufferedGraphicsManager.Current;
            context.MaximumBuffer = new Size(this.Width + 1, this.Height + 1);
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            grafx = context.Allocate(this.CreateGraphics(), new Rectangle(0, 0, this.Width, this.Height));
            DrawToBuffer(grafx.Graphics);
        }
        private void timer1_Tick(object sender, EventArgs e)
        {
            Point p = this.PointToClient(Cursor.Position);
            if (p.X != lastx)
            {
                if (p.X <= startx)
                {
                    current = 0;
                }
                else if (p.X >= startx + imagewidth)
                {
                    current = 100;
                }
                else
                {
                    current = (int)((p.X - startx) / (float)imagewidth * maximum);
                }
                if (this.OnBarMove != null)
                {
                    this.OnBarMove(this, new EventArgs());
                }
                DrawToBuffer(grafx.Graphics);
                Refresh();
                lastx = p.X;
            }
        }
        private void pictureBox2_MouseDown(object sender, MouseEventArgs e)
        {
            pictureBox1.Show();
            mute = false;
            if (this.OnNonMute != null)
            {
                this.OnNonMute(this, new EventArgs());
            }
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            pictureBox1.Hide();
            mute = true;
            if (this.OnMute != null)
            {
                this.OnMute(this, new EventArgs());
            }
        }
        private void DrawToBuffer(Graphics g)
        {
            SolidBrush b = new SolidBrush(this.BackColor);
            g.FillRectangle(b, new Rectangle(0, 0, this.Width, this.Height));
            b.Dispose();
            int wakareme = (int)(current / (float)maximum * imagewidth);
            g.DrawImage(NotepadNeue.Properties.Resources.bar1, startx + wakareme, 6, new Rectangle(wakareme, 0, imagewidth, 5), GraphicsUnit.Pixel);
            g.DrawImage(NotepadNeue.Properties.Resources.bar2, startx, 6, new Rectangle(0, 0, wakareme, 5), GraphicsUnit.Pixel);
            g.DrawImage(NotepadNeue.Properties.Resources.move, new Point(startx + wakareme - 3, 3));
        }
        private void AudioControl_Paint(object sender, PaintEventArgs e)
        {
            grafx.Render(e.Graphics);
        }

        private void AudioControl_MouseDown(object sender, MouseEventArgs e)
        {
            Point p = this.PointToClient(Cursor.Position);
            if (startx <= p.X && p.X <= startx + imagewidth)
            {
                timer1.Start();
                DrawToBuffer(grafx.Graphics);
                Refresh();
                if (!this.pictureBox1.Visible)
                {
                    this.pictureBox1.Visible = true;
                }
            }
        }

        private void AudioControl_MouseUp(object sender, MouseEventArgs e)
        {
            timer1.Stop();
        }
        public int Current
        {
            get
            {
                return current;
            }
        }
        public bool IfMute
        {
            get
            {
                return mute;
            }
        }
    }
}
