﻿using System;
using System.Windows.Forms;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using Sgry.Azuki;
using Sgry.Azuki.Highlighter;
using System.Drawing;
using System.Text.RegularExpressions;

namespace NotepadNeue
{
    public class CustomHighlighter : KeywordHighlighter
    {
        const string Reserved = "reserved";
        const string Enclosure = "enclosure";
        const string LineHighlight = "linehighlight";
        const string RegexHighlight = "regexhighlight";
        const string Ignore = "ignore";
        int schemeStartIndex = 100;
        int ignoreSchemeStartIndex = 150;
        List<string> reservedWords = new List<string>();
        List<KeyValuePair<int, Color>> colorList = new List<KeyValuePair<int, Color>>();
        public CustomHighlighter(SettingAnalyzer sanal)
        {
            for (int i = 0; i < 50; i++)
            {
                string data = sanal[Reserved + i.ToString()];
                if (data == "") break;
                data = data.Replace('\n', ',');
                string[] colorandkeywords = data.Split(',');
                Color c = CreateColor(colorandkeywords);
                string[] keywords = new string[colorandkeywords.Length - 3];
                Array.Copy(colorandkeywords, 3, keywords, 0, colorandkeywords.Length - 3);
                Array.Sort(keywords, StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false));
                AddKeywordSet(keywords, (CharClass)(schemeStartIndex));
                colorList.Add(new KeyValuePair<int, Color>(schemeStartIndex, c));
                reservedWords.AddRange(keywords);
                schemeStartIndex++;
            }
            string enclosure = sanal[Enclosure];
            if (enclosure != "")
            {
                string[] splitenc = enclosure.Split('\n');
                for (int i = 0; i < splitenc.Length; i++)
                {
                    string[] splitdata = splitenc[i].Split(',');
                    if (splitdata.Length < 5)
                    {
                        MessageBox.Show("error at " + splitenc[i]);
                    }
                    else
                    {
                        Color c = CreateColor(splitdata);
                        if (splitdata.Length >= 6 && splitdata[5].Length > 0)
                        {
                            AddEnclosure(splitdata[3], splitdata[4], (CharClass)ignoreSchemeStartIndex, splitdata[5].ToCharArray()[0]);
                        }
                        else
                        {
                            AddEnclosure(splitdata[3], splitdata[4], (CharClass)ignoreSchemeStartIndex);
                        }
                        colorList.Add(new KeyValuePair<int, Color>(ignoreSchemeStartIndex, c));
                        ignoreSchemeStartIndex++;
                        if (CheckIgnoreSchemeOver(ignoreSchemeStartIndex)) break;
                    }
                }
            }
            string linehighlight = sanal[LineHighlight];
            if (linehighlight != "")
            {
                string[] splitlinehigh = linehighlight.Split('\n');
                for (int i = 0; i < splitlinehigh.Length; i++)
                {
                    string[] splitdata = splitlinehigh[i].Split(',');
                    if (splitdata.Length < 4)
                    {
                        MessageBox.Show("error at " + splitlinehigh[i]);
                    }
                    else
                    {
                        Color c = CreateColor(splitdata);
                        AddLineHighlight(splitdata[3], (CharClass)ignoreSchemeStartIndex);
                        colorList.Add(new KeyValuePair<int, Color>(ignoreSchemeStartIndex, c));
                        ignoreSchemeStartIndex++;
                        if (CheckIgnoreSchemeOver(ignoreSchemeStartIndex)) break;
                    }
                }
            }

            string regexhighright = sanal[RegexHighlight];
            if (regexhighright != "")
            {
                string[] splitregex = regexhighright.Split('\n');
                int i = 0;
                while (i < splitregex.Length)
                {
                    List<CharClass> pool = new List<CharClass>();
                    string pattern = splitregex[i];
                    i++;
                    while (i < splitregex.Length)
                    {
                        bool ignore = splitregex[i][0] == 'i';
                        string[] colors = splitregex[i].Split(',');
                        colors[0] = colors[0].Trim('i');
                        Color outcolor = Color.Black;
                        if (!IfColor(colors, out outcolor)) break;
                        if (ignore)
                        {
                            if (CheckIgnoreSchemeOver(ignoreSchemeStartIndex))
                            {
                                i++;
                                continue;
                            }
                        }
                        else
                        {
                            if (CheckSchemeOver(schemeStartIndex))
                            {
                                i++;
                                continue;
                            }
                        }
                        colorList.Add(new KeyValuePair<int, Color>(ignore ?
                            ignoreSchemeStartIndex : schemeStartIndex, outcolor));
                        pool.Add((CharClass)(ignore ? ignoreSchemeStartIndex++ : schemeStartIndex++));
                        i++;
                    }
                    try
                    {
                        pattern = pattern.Replace("\\n", "\n").Replace("\\r", "\r");
                        Regex regex = new Regex(pattern);
                        if (pool.Count > 0)
                        {
                            AddRegex(regex, pool.ToArray());
                        }
                    }
                    catch
                    {
                        MessageBox.Show("カラースキームの正規表現にエラーがあります。" + pattern);
                    }
                }
            }
        }
        private bool CheckSchemeOver(int num)
        {
            return num >= 150;
        }
        private bool CheckIgnoreSchemeOver(int num)
        {
            return num >= 200;
        }
        private bool IfColor(string[] data, out Color color)
        {
            color = Color.FromArgb(0, 0, 0);
            if (data.Length >= 3)
            {
                int r = 0, g = 0, b = 0;
                if (!int.TryParse(data[0], out r)) return false;
                if (!int.TryParse(data[1], out g)) return false;
                if (!int.TryParse(data[2], out b)) return false;
                color = Color.FromArgb(r, g, b);
                return true;
            }
            return false;
        }
        private Color CreateColor(string[] data)
        {
            Color ret = Color.FromArgb(0, 0, 0);
            if (data.Length >= 3)
            {
                int r = 0, g = 0, b = 0;
                int.TryParse(data[0], out r);
                int.TryParse(data[1], out g);
                int.TryParse(data[2], out b);
                ret = Color.FromArgb(r, g, b);
            }
            return ret;
        }
        public string[] Reservedword
        {
            get
            {
                return reservedWords.ToArray();
            }
        }
        public void SetCharClass(ExAzukiControl exac, Color BackColor)
        {
            foreach (KeyValuePair<int, Color> pair in colorList)
            {
                exac.ColorScheme.SetColor((CharClass)pair.Key, pair.Value, BackColor);
            }
        }
    }
}