﻿using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;
using Microsoft.Scripting.Hosting;
using System.Collections;

namespace NotepadNeue
{
    public class CustomToolStrip : ToolStrip
    {
        string currentdirectory;
        MainForm fm1;
        Shortcutmanager sm;
        public CustomToolStrip(string currentdirectory, MainForm fm1, Shortcutmanager sm)
            : base()
        {
            this.currentdirectory = currentdirectory;
            this.fm1 = fm1;
            this.sm = sm;
        }
        public void AddDropDownButton(string name, string text, string imagepath, string executefilename)
        {
            ToolStripDropDownButton tsddb = new ToolStripDropDownButton(text);
            tsddb.Name = name;
            if (imagepath != "")
            {
                try
                {
                    Image i = Image.FromFile(currentdirectory + imagepath);
                    tsddb.Image = i;
                    tsddb.ImageTransparentColor = Color.Magenta;
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                }
            }
            if (executefilename != "")
            {
                tsddb.Tag = currentdirectory + executefilename;
                tsddb.Click += new EventHandler(tsddb_Click);
            }
            tsddb.DropDownClosed += new EventHandler(tsddb_DropDownClosed);
            this.Items.Add(tsddb);
        }

        void tsddb_DropDownClosed(object sender, EventArgs e)
        {
            fm1.Refresh();
        }
        public void AddDropDownButton(string name, string text, string imagepath, string executefilename, bool displaydownarrow)
        {
            ToolStripDropDownButton tsddb = new ToolStripDropDownButton(text);
            tsddb.Name = name;
            if (imagepath != "")
            {
                try
                {
                    Image i = Image.FromFile(currentdirectory + imagepath);
                    tsddb.Image = i;
                    tsddb.ImageTransparentColor = Color.Magenta;
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                }
            }
            if (executefilename != "")
            {
                tsddb.Tag = currentdirectory + executefilename;
                tsddb.Click += new EventHandler(tsddb_Click);
            }
            tsddb.DropDownClosed += new EventHandler(tsddb_DropDownClosed);
            tsddb.ShowDropDownArrow = displaydownarrow;
            this.Items.Add(tsddb);
        }
        public void RemoveDropDownButton(string name)
        {
            if (this.Items.ContainsKey(name))
            {
                ToolStripItem[] tsis = this.Items.Find(name, false);
                for (int i = 0; i < tsis.Length; i++)
                {
                    this.Items.Remove(tsis[i]);
                }
            }
        }
        public void AddMenuItemToButton(string name, string text, string imagepath, string executefilename, string targetname)
        {
            if (this.Items.ContainsKey(targetname))
            {
                CustomToolStripMenuItem tsmi = new CustomToolStripMenuItem(fm1);
                tsmi.Name = name;
                tsmi.Text = text;
                if (imagepath != "")
                {
                    try
                    {
                        Image i = Image.FromFile(currentdirectory + imagepath);
                        tsmi.Image = i;
                        tsmi.ImageTransparentColor = Color.Magenta;
                    }
                    catch (Exception e)
                    {
                        MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                    }
                }
                if (executefilename != "")
                {
                    tsmi.ExecuteFileName = currentdirectory + executefilename;
                }
                int index = this.Items.IndexOfKey(targetname);
                if (index != -1)
                {
                    (this.Items[index] as ToolStripDropDownButton).DropDownItems.Add(tsmi);
                }
            }
        }
        public void AddMenuItemToButton(string name, string text, string imagepath, string executefilename, string targetname, string shortcut)
        {
            if (this.Items.ContainsKey(targetname))
            {
                CustomToolStripMenuItem tsmi = new CustomToolStripMenuItem(fm1);
                tsmi.Name = name;
                tsmi.Text = text;
                if (imagepath != "")
                {
                    try
                    {
                        Image i = Image.FromFile(currentdirectory + imagepath);
                        tsmi.Image = i;
                        tsmi.ImageTransparentColor = Color.Magenta;
                    }
                    catch (Exception e)
                    {
                        MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                    }
                }
                if (executefilename != "")
                {
                    tsmi.ExecuteFileName = currentdirectory + executefilename;
                }
                int index = this.Items.IndexOfKey(targetname);
                if (index != -1)
                {
                    (this.Items[index] as ToolStripDropDownButton).DropDownItems.Add(tsmi);
                }
                setshortcuttotsmi(tsmi, shortcut);
            }
        }

        public void AddMenuItemToMenu(string name, string text, string imagepath, string executefilename, string targetname)
        {
            ToolStripMenuItem targettsmi = null;
            for (int i = 0; i < this.Items.Count; i++)
            {
                foreach (ToolStripItem tsi in (this.Items[i] as ToolStripDropDownButton).DropDownItems.Find(targetname, true))
                {
                    targettsmi = tsi as ToolStripMenuItem;
                    break;
                }
                if (targettsmi != null)
                {
                    break;
                }
            }
            if (targettsmi != null)
            {
                CustomToolStripMenuItem tsmi = new CustomToolStripMenuItem(fm1);
                tsmi.Name = name;
                tsmi.Text = text;
                if (imagepath != "")
                {
                    try
                    {
                        Image i = Image.FromFile(currentdirectory + imagepath);
                        tsmi.Image = i;
                        tsmi.ImageTransparentColor = Color.Magenta;
                    }
                    catch (Exception e)
                    {
                        MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                    }
                }
                if (executefilename != "")
                {
                    tsmi.ExecuteFileName = currentdirectory + executefilename;
                }
                targettsmi.DropDownItems.Add(tsmi);
            }
        }
        public void AddMenuItemToMenu(string name, string text, string imagepath, string executefilename, string targetname, string shortcut)
        {
            ToolStripMenuItem targettsmi = null;
            for (int i = 0; i < this.Items.Count; i++)
            {
                foreach (ToolStripItem tsi in (this.Items[i] as ToolStripDropDownButton).DropDownItems.Find(targetname, true))
                {
                    targettsmi = tsi as ToolStripMenuItem;
                    break;
                }
                if (targettsmi != null)
                {
                    break;
                }
            }
            if (targettsmi != null)
            {
                CustomToolStripMenuItem tsmi = new CustomToolStripMenuItem(fm1);
                tsmi.Name = name;
                tsmi.Text = text;
                if (imagepath != "")
                {
                    try
                    {
                        Image i = Image.FromFile(currentdirectory + imagepath);
                        tsmi.Image = i;
                        tsmi.ImageTransparentColor = Color.Magenta;
                    }
                    catch (Exception e)
                    {
                        MessageBox.Show(e.Message + "\n" + "エラーです。ドロップダウンイメージ読み込みエラー");
                    }
                }
                if (executefilename != "")
                {
                    tsmi.ExecuteFileName = currentdirectory + executefilename;
                }
                targettsmi.DropDownItems.Add(tsmi);
                setshortcuttotsmi(tsmi, shortcut);
            }
        }
        void setshortcuttotsmi(CustomToolStripMenuItem tsmi, string shortcut)
        {
            //shortcut setting
            ArrayList eventData = new ArrayList();
            EventDescriptorCollection events = TypeDescriptor.GetEvents(tsmi);
            EventDatum ed = null;
            foreach (System.ComponentModel.EventDescriptor myEvent in events)
            {
                ed = EventDatum.Create(tsmi, myEvent);
                if (ed == null) continue;
                break;
            }
            if (ed != null)
            {
                CustomShortcut cs = sm.AddShortcut(shortcut, ed.Event);
                if (cs != null)
                {
                    tsmi.ShortcutKeyDisplayString = cs.displaystring();
                    tsmi.ShortCut = cs;
                }
            }
        }
        void tsddb_Click(object sender, EventArgs e)
        {
            string path = (sender as ToolStripDropDownButton).Tag as string;
            if (path != "")
            {
                try
                {
                    RunPython(path);
                }
                catch (Exception ee)
                {
                    MessageBox.Show(ee.Message);
                }
                finally
                {
                    //fm1.CurrentDocument.MakeValidChange();
                    fm1.CurrentDocument.HighlightAll();
                }
            }
        }
        private void RunPython(string path)
        {
            ScriptSource source = StaticObjects.PythonEngine.CreateScriptSourceFromFile(path);
            ScriptScope scope = StaticObjects.PythonEngine.CreateScope();
            //fm1.CurrentDocument.MakeInvalidChange();
            scope.SetVariable("editor", fm1.CurrentDocument);
            scope.SetVariable("n2", fm1);
            source.Execute(scope);
        }
        public void ClearAllWithShortCut()
        {
            for (int i = 0; i < this.Items.Count; i++)
            {
                ToolStripDropDownButton tsddb = this.Items[i] as ToolStripDropDownButton;
                if (tsddb != null)
                {
                    foreach (CustomToolStripMenuItem ctsmi in tsddb.DropDownItems)
                    {
                        recursiveclearshortcut(ctsmi);
                    }
                }
            }
            this.Items.Clear();
        }
        private void recursiveclearshortcut(CustomToolStripMenuItem ctsmi)
        {
            if (ctsmi.ShortCut != null)
            {
                sm.removeshortcut(ctsmi.ShortCut);
            }
            foreach (CustomToolStripMenuItem tempctsmi in ctsmi.DropDownItems)
            {
                if (tempctsmi.ShortCut != null)
                {
                    sm.removeshortcut(tempctsmi.ShortCut);
                }
            }
        }
    }
}
