﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using System.Linq;

namespace NotepadNeue
{
    public partial class ErrorWindow : NotepadNeueExtension.ExDockContent
    {
        public delegate void CompileErrorEventHandler(object sender, CompileErrorEventArgs e);
        public event CompileErrorEventHandler CellDoubleClick;

        List<CompileErrorInformation> ErrorInformation;
        List<CompileErrorInformation> WarningInformation;

        public ErrorWindow()
        {
            InitializeComponent();
            dataGridView1.Columns[2].DefaultCellStyle.WrapMode = DataGridViewTriState.True;
            dataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dataGridView1.MultiSelect = false;
            ErrorInformation = new List<CompileErrorInformation>();
            WarningInformation = new List<CompileErrorInformation>();
        }

        private void dataGridView1_KeyDown(object sender, KeyEventArgs e)
        {
            if (this.dataGridView1.CurrentRow != null && e.KeyCode == Keys.Return)
            {
                int index = this.dataGridView1.CurrentRow.Index;
                string fn = this.dataGridView1[2, index].Value.ToString();
                int row = int.Parse(this.dataGridView1[3, index].Value.ToString());
                int column = int.Parse(this.dataGridView1[4, index].Value.ToString());
                if (CellDoubleClick != null)
                {
                    CellDoubleClick.Invoke(this, new CompileErrorEventArgs(column, row, fn));
                }
            }
        }
        private void dataGridView1_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            if (this.dataGridView1.CurrentRow != null)
            {
                int index = this.dataGridView1.CurrentRow.Index;
                string fn = this.dataGridView1[2, index].Value.ToString();
                int row = int.Parse(this.dataGridView1[3, index].Value.ToString());
                int column = int.Parse(this.dataGridView1[4, index].Value.ToString());
                if (CellDoubleClick != null)
                {
                    CellDoubleClick.Invoke(this, new CompileErrorEventArgs(column, row, fn));
                }
            }
        }
        public void Add(int mode, string text, int row, int column, string filename)
        {
            //mode 0 is error 1 is warn
            if (mode == 0)
            {
                ErrorInformation.Add(new CompileErrorInformation(NotepadNeue.Properties.Resources.error, text, row, column, filename));
            }
            else
            {
                WarningInformation.Add(new CompileErrorInformation(NotepadNeue.Properties.Resources.warn, text, row, column, filename));
            }
        }
        public void AddCustom(int mode, string text, int row, int column, string filename)
        {
            if (mode == 0)
            {
                this.dataGridView1.Rows.Add(NotepadNeue.Properties.Resources.error, text, filename, row, column);
            }
            else
            {
                this.dataGridView1.Rows.Add(NotepadNeue.Properties.Resources.warn, text, filename, row, column);
            }
        }
        public void FinishAdd()
        {
            foreach (CompileErrorInformation cei in ErrorInformation.Concat(WarningInformation).OrderBy(c => c.Row))
            {
                this.dataGridView1.Rows.Add(cei.Mode, cei.Text, cei.Filename, cei.Row, cei.Column);
            }
        }
        public int ErrorCount
        {
            get
            {
                return ErrorInformation.Count;
            }
        }
        public int WarningCount
        {
            get
            {
                return WarningInformation.Count;
            }
        }
        public void Clear()
        {
            ErrorInformation.Clear();
            WarningInformation.Clear();
            this.dataGridView1.Rows.Clear();
        }
        public void ChangeErrorState(bool show)
        {
            if (show)
            {
                this.Icon = Icon.FromHandle(NotepadNeue.Properties.Resources.error.GetHicon());
            }
            else
            {
                this.Icon = null;
            }
        }
        public int RowCount
        {
            get
            {
                return this.dataGridView1.RowCount;
            }
        }

        public class CompileErrorInformation
        {
            public CompileErrorInformation(Image mode, string text, int row, int column, string filename)
            {
                Mode = mode;
                Text = text;
                Row = row;
                Column = column;
                Filename = filename;
            }
            public Image Mode
            {
                get;
                set;
            }
            public string Text
            {
                get;
                set;
            }
            public int Row
            {
                get;
                set;
            }
            public int Column
            {
                get;
                set;
            }
            public string Filename
            {
                get;
                set;
            }
        }
        public class CompileErrorEventArgs : EventArgs
        {
            public CompileErrorEventArgs(int column, int row, string filename)
            {
                Column = column;
                Row = row;
                Filename = filename;
            }
            public int Row
            {
                get;
                set;
            }
            public int Column
            {
                get;
                set;
            }
            public string Filename
            {
                get;
                set;
            }
        }

        private void dataGridView1_CellPainting(object sender, DataGridViewCellPaintingEventArgs e)
        {
            if (this.BackgroundImage != null)
            {
                e.Graphics.DrawImage(BackgroundImage, e.CellBounds, e.CellBounds, GraphicsUnit.Pixel);
            }
            else
            {
                SolidBrush sb = new SolidBrush(BackColor);
                e.Graphics.FillRectangle(sb, e.CellBounds);
                sb.Dispose();
            }
            if ((e.State & DataGridViewElementStates.Selected) == DataGridViewElementStates.Selected)
            {
                SolidBrush sb = new SolidBrush(Color.FromArgb(128, 128, 128, 128));
                e.Graphics.FillRectangle(sb, e.CellBounds);
                sb.Dispose();
            }
            //背景以外が描画されるようにする
            DataGridViewPaintParts paintParts =
               e.PaintParts & ~DataGridViewPaintParts.Background;
            //セルを描画する
            e.Paint(e.ClipBounds, paintParts);
            //描画が完了したことを知らせる
            e.Handled = true;
        }

        private void ErrorWindow_BackgroundImageChanged(object sender, EventArgs e)
        {
            dataGridView1.Invalidate();
        }

        private void dataGridView1_Scroll(object sender, ScrollEventArgs e)
        {
            dataGridView1.Invalidate();
        }
    }
}
