﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;

namespace NotepadNeue
{
    public partial class MovieWindow : TextEditWindow
    {
        testgame.MyGame mg;
        System.Threading.Thread t;
        Panel p;
        int Vscwidth;
        int Hscheight;
        Timer timer;
        Timer ChangedTimer;
        int firstindex;
        int lastindex;
        public MovieWindow()
        {
            InitializeComponent();
            t = new System.Threading.Thread(DXThread);
            mg = new testgame.MyGame();
            VScrollBar Vsc = new VScrollBar();
            Vscwidth = Vsc.Width;
            Vsc.Dispose();
            HScrollBar Hsc = new HScrollBar();
            Hscheight = Hsc.Height;
            Hsc.Dispose();
            timer = new Timer();
            timer.Interval = 50;
            timer.Tick += new EventHandler(timer_Tick);
            ChangedTimer = new Timer();
            ChangedTimer.Tick += new EventHandler(ChangedTimer_Tick);
            ChangedTimer.Interval = 2000;
        }

        public void Prepare()
        {
            p = new Panel();
            p.Size = new Size(this.ClientSize.Width - Vscwidth - 3, this.ClientSize.Height - Hscheight - 3);
            this.Controls.Add(p);
            this.Controls.SetChildIndex(p, 0);
            p.GotFocus += new EventHandler(p_GotFocus);
            p.MouseDown += new MouseEventHandler(p_MouseDown);
            p.MouseUp += new MouseEventHandler(p_MouseUp);
            mg.width = p.Width;
            mg.height = p.Height;
            mg.Window = this;
            mg.WindowHandle = this.Handle;
            mg.exac = ExAzukiControl;
            mg.Handle = p.Handle;
            ExAzukiControl.FontChanged += new EventHandler(ExAzukiControl_FontChanged);
            this.FontChanged += new EventHandler(MovieWindow_FontChanged);
        }
        public void RunDX()
        {
            t.Start();
        }
        void ExAzukiControl_FontChanged(object sender, EventArgs e)
        {
            mg.ChangeFont(ExAzukiControl.Font.Name, ExAzukiControl.Font.Height);
        }


        void MovieWindow_FontChanged(object sender, EventArgs e)
        {
            mg.ChangeFont(this.Font.Name, this.Font.Height);
        }
        void p_MouseUp(object sender, MouseEventArgs e)
        {
            setSelection();
            timer.Stop();
        }

        void p_MouseDown(object sender, MouseEventArgs e)
        {
            Point pos = ExAzukiControl.PointToClient(Cursor.Position);
            firstindex = ExAzukiControl.GetIndexFromPosition(pos);
            lastindex = firstindex;
            setSelection();
            timer.Start();
        }
        void timer_Tick(object sender, EventArgs e)
        {
            Point pos = ExAzukiControl.PointToClient(Cursor.Position);
            lastindex = ExAzukiControl.GetIndexFromPosition(pos);
            setSelection();
        }
        void setSelection()
        {
            int start = Math.Min(firstindex, lastindex);
            int caret = Math.Max(firstindex, lastindex);
            ExAzukiControl.SetSelection(start, caret);
        }
        void p_GotFocus(object sender, EventArgs e)
        {
            ExAzukiControl.Focus();
        }
        private void DXThread()
        {
            //ExAzukiControl.Visible = false;
            mg.Run();
        }

        private void MovieWindow_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (mg != null)
            {
                mg.Dispose();
                mg = null;
            }
            /*if (m != null && m.initialized)
            {
                m.Dispose();
                m = null;
            }*/
        }

        private void 動画再生ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = "";
            openFileDialog1.Multiselect = true;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                bool result = mg.OpenMovie(openFileDialog1.FileNames);
                再生ToolStripMenuItem.Enabled = result;
                動画を開放ToolStripMenuItem.Enabled = result;
            }
            //mg.OpenMovie("I:\\マイ ドキュメント\\Develop Application\\コピー ～ PPD\\songs\\Bad Apple!! - Feat Nomico  ByN\\movie.mp4");
        }

        private void 動画を開放ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mg.ReleaseMovie();
            再生ToolStripMenuItem.Enabled = false;
            動画を開放ToolStripMenuItem.Enabled = false;
        }

        private void オーバーレイα調整ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TrackBar tb = new TrackBar();
            tb.Minimum = 0;
            tb.Maximum = 255;
            tb.Value = (int)(mg.overrayalpha * 255);
            this.Controls.Add(tb);
            this.Controls.SetChildIndex(tb, 0);
            Point pos = this.PointToClient(Cursor.Position);
            tb.Location = new Point(pos.X - 5, pos.Y - 5);
            tb.TickStyle = TickStyle.None;
            tb.MouseLeave += new EventHandler(tb_MouseLeave);
            tb.ValueChanged += new EventHandler(tb_ValueChanged);
        }

        void tb_ValueChanged(object sender, EventArgs e)
        {
            TrackBar tb = sender as TrackBar;
            if (tb != null)
            {
                mg.overrayalpha = (float)tb.Value / 255;
            }
        }

        void tb_MouseLeave(object sender, EventArgs e)
        {
            TrackBar tb = sender as TrackBar;
            if (tb != null)
            {
                this.Controls.Remove(tb);
                tb.Dispose();
            }
        }

        private void 再生ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mg.Play();
        }

        private void アス比固定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (mg != null)
            {
                アス比固定ToolStripMenuItem.Checked = !アス比固定ToolStripMenuItem.Checked;
                mg.FixAspect = アス比固定ToolStripMenuItem.Checked;
            }
        }
        private void MovieWindow_BackgroundImageChanged(object sender, EventArgs e)
        {
            mg.ChangeBackGround(this.BackgroundImage as Bitmap);
        }

        private void MovieWindow_SizeChanged(object sender, EventArgs e)
        {
            if (ChangedTimer != null)
            {
                ChangedTimer.Start();
            }
        }
        void ChangedTimer_Tick(object sender, EventArgs e)
        {
            ChangedTimer.Stop();
            if (p != null && mg != null)
            {
                p.Size = new Size(this.ClientSize.Width - Vscwidth - 3, this.ClientSize.Height - Hscheight - 3);
                mg.width = p.Width <= 0 ? 1 : p.Width;
                mg.height = p.Height <= 0 ? 1 : p.Height;
                mg.ReCreate();
            }
        }
        private const int WM_GRAPHNOTIFY = 0x0400 + 13;
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case WM_GRAPHNOTIFY:
                    {
                        util.OnGraphNotify();
                        break;
                    }
            }
            base.WndProc(ref m);
        }
        public testgame.Utility util
        {
            get;
            set;
        }

    }
}
