﻿using System;

using System.Text.RegularExpressions;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using WeifenLuo.WinFormsUI.Docking;

namespace NotepadNeue
{
    public partial class SearchAndReplace : NotepadNeueExtension.ExDockContent
    {
        enum SearchType
        {
            Current = 0,
            All = 1,
            InSelection = 2
        }

        int selbegin = -1;
        int selend = -1;

        const string st1 = "ありませんでした";
        const string st2 = "処理が完了しました。";
        const string st3 = "入力がありません。";
        const string st4 = "個の変換を行いました";
        const string st5 = "選択範囲がありません";
        private SearchType Searchtype
        {
            get
            {
                return (SearchType)comboBox1.SelectedIndex;
            }
        }
        public SearchAndReplace()
        {
            InitializeComponent();
            this.GotFocus += new EventHandler(SearchAndReplace_GotFocus);
            this.comboBox1.SelectedIndex = 0;
        }

        void SearchAndReplace_GotFocus(object sender, EventArgs e)
        {
            if (fm1 != null && fm1.CurrentDocument != null)
            {
                textBox1.Text = fm1.CurrentDocument.GetSelectedText();
            }
            textBox1.SelectAll();
            textBox1.Focus();
        }
        public Form1 fm1
        {
            get;
            set;
        }
        private bool IgnoreCase
        {
            get
            {
                return checkBox3.Checked;
            }
        }
        private void button1_Click(object sender, EventArgs e)
        {
            if (fm1.CurrentDocument == null) return;
            if (Searchtype == SearchType.InSelection)
            {
                if (selbegin == -1 && selend == -1)
                {
                    fm1.CurrentDocument.GetSelection(out selbegin, out selend);
                    if (selbegin == selend)
                    {
                        MessageBox.Show(st5);
                        return;
                    }
                }
                if (selbegin == selend)
                {
                    MessageBox.Show(st5);
                    return;
                }
                searchinselection();
            }
            else
            {
                if (!search(fm1.CurrentWindow)) MessageBox.Show(st1);
            }
        }
        public bool searchinselection()
        {
            if (this.textBox1.Text != "")
            {
                int begin, end;
                fm1.CurrentDocument.GetSelection(out begin, out end);
                if (selbegin == begin && selend == end) end = begin;
                Sgry.Azuki.SearchResult searchresult = Search(this.textBox1.Text, end);
                if (searchresult != null)
                {
                    if (selbegin <= searchresult.Begin && searchresult.End <= selend)
                    {
                        fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                        fm1.CurrentDocument.ScrollToCaret();
                    }
                    else
                    {
                        fm1.CurrentDocument.SetSelection(selbegin, selend);
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st1);
                        return false;
                    }
                }
                else
                {
                    fm1.CurrentDocument.SetSelection(selbegin, selend);
                    selbegin = -1;
                    selend = -1;
                    MessageBox.Show(st1);
                }
                return true;
            }
            else
            {
                MessageBox.Show(st3);
                return false;
            }
        }
        public bool search(DockContent startexac)
        {
            if (this.textBox1.Text != "")
            {
                int begin, end;
                fm1.CurrentDocument.GetSelection(out begin, out end);
                Sgry.Azuki.SearchResult searchresult = Search(this.textBox1.Text, end);
                if (searchresult != null)
                {
                    fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                    fm1.CurrentDocument.ScrollToCaret();
                }
                else
                {
                    //MessageBox.Show(st1);
                    if (Searchtype == SearchType.Current)
                    {
                        searchresult = Search(this.textBox1.Text, 0);
                        if (searchresult == null)
                        {
                            return false;
                        }
                        else
                        {
                            fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                            fm1.CurrentDocument.ScrollToCaret();
                        }
                    }
                    else if (Searchtype == SearchType.All)
                    {
                        DockContent currentexac = null;
                        while ((currentexac = fm1.ChangeToNextDocument()) != null)
                        {
                            if (startexac == currentexac) return false;
                            searchresult = Search(this.textBox1.Text, 0);
                            if (searchresult == null)
                            {
                                //MessageBox.Show(st1);
                            }
                            else
                            {
                                fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                                fm1.CurrentDocument.ScrollToCaret();
                                this.button1.Focus();
                                break;
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                MessageBox.Show(st3);
                return false;
            }
        }
        public Sgry.Azuki.SearchResult Search(string text, int end)
        {
            if (text == null || text == "") return null;
            Sgry.Azuki.SearchResult searchresult = null;
            if (!this.checkBox1.Checked)
            {
                searchresult = fm1.CurrentDocument.Document.FindNext(this.textBox1.Text, end, !IgnoreCase);
            }
            else
            {
                try
                {
                    searchresult = fm1.CurrentDocument.Document.FindNext(new System.Text.RegularExpressions.Regex(this.textBox1.Text, IgnoreCase ? RegexOptions.IgnoreCase : RegexOptions.None), end);
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message);
                }
            }
            return searchresult;
        }
        private void button3_Click(object sender, EventArgs e)
        {
            if (fm1.CurrentDocument == null) return;
            if (Searchtype == SearchType.InSelection)
            {
                bool ret = true;
                if (selbegin == -1 && selend == -1)
                {
                    fm1.CurrentDocument.GetSelection(out selbegin, out selend);
                    if (selbegin == selend)
                    {
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st5);
                        return;
                    }
                    ret = searchinselection();
                }
                if (ret)
                {
                    int begin, end;
                    fm1.CurrentDocument.GetSelection(out begin, out end);
                    if (end - begin != 0)
                    {
                        int sub = 0;
                        if (this.checkBox2.Checked)
                        {
                            string selectionstring = fm1.CurrentDocument.GetTextInRange(begin, end);
                            selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                            fm1.CurrentDocument.Document.Replace(selectionstring);
                            sub = selectionstring.Length - (end - begin);
                        }
                        else
                        {
                            fm1.CurrentDocument.Document.Replace(this.textBox2.Text);
                            sub = this.textBox2.Text.Length - (end - begin);
                        }
                        selend += sub;
                    }
                    if (!searchinselection()) MessageBox.Show(st1);
                }
            }
            else
            {
                fm1.CurrentDocument.MakeInvalidChange();
                int begin, end;
                fm1.CurrentDocument.GetSelection(out begin, out end);
                if (end - begin != 0)
                {
                    if (this.checkBox2.Checked)
                    {
                        string selectionstring = fm1.CurrentDocument.GetTextInRange(begin, end);
                        selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                        fm1.CurrentDocument.Document.Replace(selectionstring);
                    }
                    else
                    {
                        fm1.CurrentDocument.Document.Replace(this.textBox2.Text);
                    }
                }
                fm1.CurrentDocument.MakeValidChange();
                if (!search(fm1.CurrentWindow)) MessageBox.Show(st1);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (fm1.CurrentDocument == null) return;
            if (Searchtype == SearchType.InSelection)
            {
                if (selbegin == -1 && selend == -1)
                {
                    fm1.CurrentDocument.GetSelection(out selbegin, out selend);
                    if (selbegin == selend)
                    {
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st5);
                        return;
                    }
                }
                if (selbegin == selend)
                {
                    selbegin = -1;
                    selend = -1;
                    MessageBox.Show(st5);
                    return;
                }
                int sub = 0;
                string selectedtext = fm1.CurrentDocument.GetTextInRange(selbegin, selend);
                if (this.checkBox2.Checked)
                {
                    string temp = System.Text.RegularExpressions.Regex.Replace(selectedtext, this.textBox1.Text, this.textBox2.Text);
                    fm1.CurrentDocument.Document.Replace(temp, selbegin, selend);
                    sub = temp.Length - selectedtext.Length;
                }
                else
                {
                    string temp = selectedtext.Replace(this.textBox1.Text, this.textBox2.Text);
                    fm1.CurrentDocument.Document.Replace(temp, selbegin, selend);
                    sub = temp.Length - selectedtext.Length;
                }
                selend += sub;
                fm1.CurrentDocument.SetSelection(selbegin, selend);
                selbegin = -1;
                selend = -1;
            }
            else
            {
                DockContent dc = fm1.CurrentWindow;
                fm1.CurrentDocument.SetSelection(0, 0);
                int replacecount = 0;
                while (search(dc))
                {
                    int begin, end;
                    fm1.CurrentDocument.GetSelection(out begin, out end);
                    if (end - begin != 0)
                    {
                        if (this.checkBox2.Checked)
                        {
                            string selectionstring = fm1.CurrentDocument.GetTextInRange(begin, end);
                            selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                            fm1.CurrentDocument.Document.Replace(selectionstring);
                        }
                        else
                        {
                            fm1.CurrentDocument.Document.Replace(this.textBox2.Text);
                        }
                    }
                    replacecount++;
                }
                if (replacecount == 0)
                {
                    MessageBox.Show(st1);
                }
                else
                {
                    MessageBox.Show(replacecount + st4);
                }
                /*DockContent startexac = fm1.CurrentWindow;
                DockContent currentexac = null;
                fm1.CurrentDocument.MakeInvalidChange();
                if (this.textBox1.Text != "")
                {
                    bool looped = false;
                    int begin, end;
                    fm1.CurrentDocument.GetSelection(out begin, out end);
                    Sgry.Azuki.SearchResult searchresult = Search(this.textBox1.Text, end);
                    if (searchresult == null)
                    {
                        looped = true;
                        fm1.CurrentDocument.SetSelection(0, 0);
                        searchresult = Search(this.textBox1.Text, 0);
                    }
                    while (searchresult != null)
                    {
                        if (!this.checkBox2.Checked)
                        {
                            fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                            fm1.CurrentDocument.Document.Replace(this.textBox2.Text);
                        }
                        else
                        {
                            string selectionstring = fm1.CurrentDocument.GetTextInRange(searchresult.Begin, searchresult.End);
                            selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                            fm1.CurrentDocument.SetSelection(searchresult.Begin, searchresult.End);
                            fm1.CurrentDocument.Document.Replace(selectionstring);
                        }
                        replacecount++;
                        fm1.CurrentDocument.GetSelection(out begin, out end);
                        searchresult = Search(this.textBox1.Text, end);
                        if (searchresult == null && !looped)
                        {
                            looped = true;
                            fm1.CurrentDocument.SetSelection(0, 0);
                            searchresult = Search(this.textBox1.Text, 0);
                        }
                    }
                    if (replacecount == 0)
                    {
                        MessageBox.Show(st1);
                    }
                    else
                    {
                        MessageBox.Show(replacecount + st4);
                    }
                    fm1.CurrentDocument.ScrollToCaret();
                }
                else
                {
                    MessageBox.Show(st3);
                }
                fm1.CurrentDocument.MakeValidChange();*/
            }
        }
        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (this.checkBox2.Checked)
            {
                this.checkBox1.Checked = true;
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox1.Checked)
            {
                this.checkBox2.Checked = false;
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            selbegin = -1;
            selend = -1;
        }
    }
}
