﻿using System;
using System.Reflection;
using System.ComponentModel;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class EventDatum
    {
        private EventDescriptor _eventDesc;
        private Delegate _event;
        private static MethodInfo GetEventsMethod(Type objType)
        {
            MethodInfo mi = objType.GetMethod("get_Events", All);
            if ((mi == null) & (objType.BaseType != null))
                mi = GetEventsMethod(objType.BaseType);
            return mi;
        }

        private static EventHandlerList GetEvents(object obj)
        {
            MethodInfo mi = GetEventsMethod(obj.GetType());
            if (mi == null) return null;
            return (EventHandlerList)mi.Invoke(obj, new object[] { });
        }

        private static FieldInfo GetEventIDField(Type objType, string eventName)
        {
            FieldInfo fi = objType.GetField("Event" + eventName, All);
            if ((fi == null) & (objType.BaseType != null))
                fi = GetEventIDField(objType.BaseType, eventName);
            return fi;
        }

        private static object GetEventID(object obj, string eventName)
        {
            FieldInfo fi = GetEventIDField(obj.GetType(), eventName);
            if (fi == null) return null;
            return fi.GetValue(obj);
        }

        private static BindingFlags All
        {
            get
            {
                return
                    BindingFlags.Public | BindingFlags.NonPublic |
                    BindingFlags.Instance | BindingFlags.IgnoreCase |
                    BindingFlags.Static;
            }
        }

        internal EventDatum(EventDescriptor desc, Delegate aEvent)
        {
            _eventDesc = desc;
            _event = aEvent;
        }

        public static EventDatum Create(object obj, EventDescriptor desc)
        {
            EventHandlerList list = GetEvents(obj);
            if (list == null) return null;
            object key = GetEventID(obj, desc.Name);
            if (key == null) return null;
            Delegate evnt = list[key];
            if (evnt == null) return null;
            return new EventDatum(desc, evnt);
        }

        public void Wire(object obj)
        {
            _eventDesc.AddEventHandler(obj, _event);
        }

        public void Unwire(object obj)
        {
            _eventDesc.RemoveEventHandler(obj, _event);
        }
        public Delegate Event
        {
            get
            {
                return _event;
            }
        }
    }
}
