﻿using System;
using System.Windows.Forms;
using System.IO;
using Microsoft.Scripting.Hosting;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

using NotepadNeueExtension;
using System.Collections;
using System.Threading;

namespace NotepadNeue
{
    public class ExtensionInfomation
    {
        string batbeforecompile;
        string compiler;
        string option;
        string program;
        string programoption;
        string exefilename;
        string extra;

        Encoding encoding;
        CustomHighlighter ch;
        string allowstringwhenassist;
        Regex compileerrorregex;
        Regex compilewarnregex;
        Regex functionscoperegex;
        Regex includefileregex;
        string bufferdirectory;
        string scopeaccessor;
        string[] objectaccessor;
        string[] reservedword;
        string[][] operationdata;
        string[] ignorepattern;
        string[] correspondpairs;
        string[] levelenclosures;
        string[] defaulttype;
        char[] autoformatchars;
        char functionseparator;
        char[] typetrimchars;
        SortedList<string, NameSpaceInfo> bufferdata;
        AssistInformation[] defaultinfos;

        Shortcutmanager sm;
        CustomToolStrip cts;

        string builtInMode = null;
        int timeoutinterval;

        MainForm fm1;

        string currentdirectory;

        List<Thread> readBufferThread;

        public ExtensionInfomation(string currentdirectory, MainForm fm1)
        {
            this.fm1 = fm1;
            sm = new Shortcutmanager();
            readBufferThread = new List<Thread>();
            cts = new CustomToolStrip(currentdirectory, fm1, sm);
            cts.BackColor = System.Drawing.Color.Transparent;
            this.currentdirectory = currentdirectory;
        }

        ~ExtensionInfomation()
        {
            foreach (Thread thread in readBufferThread)
            {
                if (thread.IsAlive)
                {
                    thread.Abort();
                }
            }
        }

        public void readini(string filename)
        {
            try
            {
                //string directory = Path.GetDirectoryName(filename);
                //checkini
                string s = "";
                StreamReader sr = new StreamReader(filename);
                s = sr.ReadToEnd();
                sr.Close();
                SettingAnalyzer sanal = new SettingAnalyzer(s);
                string characode = sanal["characode"];
                switch (characode)
                {
                    case "0":
                        encoding = Encoding.GetEncoding("euc-jp");
                        break;
                    case "1":
                        encoding = Encoding.Unicode;
                        break;
                    case "2":
                        encoding = Encoding.UTF8;
                        break;
                    case "3":
                        encoding = Encoding.GetEncoding(932);
                        break;
                    default:
                        encoding = Encoding.UTF8;
                        break;
                }
                batbeforecompile = sanal["batbeforecompile"];
                compiler = sanal["compiler"];
                option = sanal["option"];
                program = sanal["program"];
                programoption = sanal["programoption"];
                exefilename = sanal["filename"];
                extra = sanal["extra"];
                //reservedword
                ch = new CustomHighlighter(sanal);
                reservedword = ch.Reservedword;
                builtInMode = sanal["builtinmode"];
                //timeoutinterval
                string timeout = sanal["timeoutinterval"];
                if (!int.TryParse(timeout, out timeoutinterval))
                {
                    timeoutinterval = 15000;
                }
                //oprationdata
                string operationfilename = sanal["operator"];
                if (File.Exists(currentdirectory + "\\" + operationfilename))
                {
                    string temps = "";
                    StreamReader strr = new StreamReader(currentdirectory + "\\" + operationfilename);
                    temps = strr.ReadToEnd();
                    sr.Close();
                    temps = temps.Replace("\r\n", "\n");
                    temps = temps.Replace("\r", "\n");
                    string[] splitoperation = temps.Split('\n');
                    operationdata = new string[splitoperation.Length][];
                    for (int i = 0; i < splitoperation.Length; i++)
                    {
                        string[] subdata = splitoperation[i].Split('_');
                        if (subdata.Length != 2)
                        {
                            MessageBox.Show("error at " + splitoperation[i] + "\n because more _ or less _. the num of _ is 1 in the line");
                        }
                        operationdata[i] = subdata;
                    }
                }
                else
                {
                    operationdata = new string[0][];
                }
                //ignorepattern
                string ignorefilepath = sanal["ignorepattern"];
                if (File.Exists(currentdirectory + "\\" + ignorefilepath))
                {
                    StreamReader strr = new StreamReader(currentdirectory + "\\" + ignorefilepath);
                    string temps = strr.ReadToEnd();
                    strr.Close();
                    temps = temps.Replace("\r\n", "\n");
                    temps = temps.Replace("\r\n", "\n");
                    ignorepattern = temps.Split('\n');
                    strr.Close();
                }
                else
                {
                    ignorepattern = new string[0];
                }
                //defaulttype
                string defaulttypedata = sanal["defaulttype"];
                if (defaulttypedata != "")
                {
                    defaulttypedata = defaulttypedata.Replace("\n", ",");
                    defaulttype = defaulttypedata.Split(',');
                }
                else
                {
                    defaulttype = new string[0];
                }
                //compileerrorregex
                compileerrorregex = GetRegex("compileerrorregex", sanal);
                compilewarnregex = GetRegex("compilewarnregex", sanal);
                //allowstringwhenassist
                allowstringwhenassist = sanal["allowstringwhenassist"];
                //functionscoperegex
                functionscoperegex = GetRegex("functionscoperegex", sanal);
                //bufferdirectory
                bufferdirectory = sanal["bufferdirectory"];
                //includefileregex
                includefileregex = GetRegex("includefileregex", sanal);
                bufferdata = new SortedList<string, NameSpaceInfo>();
                //namespaceaccesor
                scopeaccessor = sanal["scopeaccessor"];
                //objectaccessor
                string objectaccessordata = sanal["objectaccessor"];
                if (objectaccessordata != "")
                {
                    objectaccessor = objectaccessordata.Split(',');
                }
                else
                {
                    objectaccessor = new string[0];
                }
                //correspondpair
                string corresponddata = sanal["correspondhighlightpair"];
                if (corresponddata != "")
                {
                    correspondpairs = corresponddata.Split(',');
                }
                else
                {
                    correspondpairs = new string[0];
                }
                //levelenclosure
                string levelenclosure = sanal["levelenclosure"];
                if (levelenclosure != "")
                {
                    levelenclosures = levelenclosure.Split(',');
                }
                else
                {
                    levelenclosures = new string[0];
                };
                //autoformatchars
                string autos = sanal["autoformatchars"];
                if (autos != "")
                {
                    string[] temps = autos.Split(',');
                    autoformatchars = new char[temps.Length];
                    for (int i = 0; i < temps.Length; i++)
                    {
                        if (temps[i].Length > 0)
                        {
                            autoformatchars[i] = temps[i][0];
                        }
                        else
                        {
                            autoformatchars[i] = '\0';
                        }
                    }
                }
                else
                {
                    autoformatchars = new char[0];
                }
                //functionseparator
                string funcsepa = sanal["functionseparator"];
                if (funcsepa != "")
                {
                    functionseparator = funcsepa[0];
                }
                else
                {
                    functionseparator = '\0';
                }
                //typetrimchars
                typetrimchars = sanal["typetrimchars"].ToCharArray();
                //assist
                defaultinfos = new AssistInformation[reservedword.Length];
                int iter = 0;
                foreach (string reserved in reservedword)
                {
                    defaultinfos[iter] = new AssistInformation();
                    defaultinfos[iter].Image = NotepadNeue.Properties.Resources.reserved;
                    defaultinfos[iter].Text = reserved;
                    defaultinfos[iter].HintText = "";
                    iter++;
                }
                //clear all item in plugin and shortcut
                cts.ClearAllWithShortCut();
                //extensionplugin
                string path = currentdirectory + sanal["pluginpath"];
                if (File.Exists(path))
                {
                    readplugin(path);
                }
            }
            catch (Exception e)
            {
                MessageBox.Show("拡張子設定読み込みエラーです\n" + e.Message);
            }
        }

        private Regex GetRegex(string key, SettingAnalyzer analyzer)
        {
            string val = analyzer[key];
            if (String.IsNullOrEmpty(val))
            {
                return null;
            }
            else
            {
                return new Regex(val);
            }
        }

        private void readplugin(string path)
        {
            if (!fm1.Utility.AllowScriptUse) return;
            RunPython(path);
        }
        private void RunPython(string path)
        {
            ScriptSource source = StaticObjects.PythonEngine.CreateScriptSourceFromFile(path);
            ScriptScope scope = StaticObjects.PythonEngine.CreateScope();
            //fm1.CurrentDocument.MakeInvalidChange();
            scope.SetVariable("usertoolstrip", cts);
            source.Execute(scope);
        }
        public void ReadBuffer(string filename)
        {
            string fullPath = Path.Combine(currentdirectory, bufferdirectory, filename);
            if (File.Exists(fullPath))
            {
                NameSpaceInfo nsm = new NameSpaceInfo();
                lock (bufferdata)
                {
                    if (bufferdata.ContainsKey(filename))
                    {
                        return;
                    }
                    bufferdata.Add(filename, nsm);
                }

                Thread thread = new Thread(new ParameterizedThreadStart(ReadBufferInAnotherThread));
                readBufferThread.Add(thread);
                thread.Start(new ArrayList()
                {
                    nsm,
                    fullPath
                });
            }
        }

        private void ReadBufferInAnotherThread(Object obj)
        {
            ArrayList args = obj as ArrayList;
            NameSpaceInfo nsm = args[0] as NameSpaceInfo;
            string fullPath = args[1] as string;
            XMLBufferReader bufferreader = new XMLBufferReader(fullPath);
            bufferreader.namespacemanager = nsm;
            bufferreader.Parse();
        }

        public Encoding Encoding
        {
            get
            {
                return encoding;
            }
            set
            {
                encoding = value;
            }
        }
        public CustomHighlighter CustomHighlighter
        {
            get
            {
                return ch;
            }
            set
            {
                ch = value;
            }
        }
        public string AllowStringWhenAssist
        {
            get
            {
                return allowstringwhenassist;
            }
        }
        public Regex CompileErrorRegex
        {
            get
            {
                return compileerrorregex;
            }
        }
        public Regex CompileWarnRegex
        {
            get
            {
                return compilewarnregex;
            }
        }
        public Regex FunctionScopeRegex
        {
            get
            {
                return functionscoperegex;
            }
        }
        public Regex IncludeFileRegex
        {
            get
            {
                return includefileregex;
            }
        }
        public string ScopeAccessor
        {
            get
            {
                return scopeaccessor;
            }
        }
        public string[] ObjectAccessor
        {
            get
            {
                return objectaccessor;
            }
        }
        public string[] ReservedWord
        {
            get
            {
                return reservedword;
            }
        }
        public string[][] OperationData
        {
            get
            {
                return operationdata;
            }
        }
        public string[] IgnorePattern
        {
            get
            {
                return ignorepattern;
            }
        }
        public string[] CorrespondPairs
        {
            get
            {
                return correspondpairs;
            }
        }
        public string[] LevelEnclosure
        {
            get
            {
                return levelenclosures;
            }
        }
        public string[] DefaultType
        {
            get
            {
                return defaulttype;
            }
        }
        public AssistInformation[] DefaultInfos
        {
            get
            {
                return defaultinfos;
            }
        }
        public char[] AutoFormatChars
        {
            get
            {
                return autoformatchars;
            }
        }
        public char FunctionSeparator
        {
            get
            {
                return functionseparator;
            }
        }
        public SortedList<string, NameSpaceInfo> BufferData
        {
            get
            {
                return bufferdata;
            }
        }

        public string BufferDirectory
        {
            get
            {
                return Path.Combine(currentdirectory, bufferdirectory);
            }
        }

        public string BuiltInMode
        {
            get
            {
                return builtInMode;
            }
        }
        public string Extension
        {
            get;
            set;
        }
        public CustomToolStrip CustomToolStrip
        {
            get
            {
                return cts;
            }
        }
        public Shortcutmanager ShortCutManager
        {
            get
            {
                return sm;
            }
        }
        public string BatBeforeCompile
        {
            get
            {
                return batbeforecompile;
            }
        }
        public string Compiler
        {
            get
            {
                return compiler;
            }
        }
        public string Option
        {
            get
            {
                return option;
            }
        }
        public string Program
        {
            get
            {
                return program;
            }
        }
        public string ProgramOption
        {
            get
            {
                return programoption;
            }
        }
        public string Filename
        {
            get
            {
                return exefilename;
            }
        }
        public string Extra
        {
            get
            {
                return extra;
            }
        }
        public int TimeOutInterval
        {
            get
            {
                return timeoutinterval;
            }
        }
        public char[] TypeTrimChars
        {
            get
            {
                return typetrimchars;
            }
        }
    }
}
