﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NotepadNeue
{
    class ExtensionSetting
    {
        private Dictionary<string, string> dict;

        public string ExtensionName
        {
            get;
            private set;
        }

        public string this[string key]
        {
            get
            {
                string ret;
                if (!dict.TryGetValue(key, out ret))
                {
                    return null;
                }
                return ret;
            }
            set
            {
                if (value == null)
                {
                    if (dict.ContainsKey(key))
                    {
                        dict.Remove(key);
                    }
                }
                else
                {
                    dict[key] = value;
                }
            }
        }

        public KeyValuePair<string, string>[] All
        {
            get
            {
                return dict.ToArray();
            }
        }

        public ExtensionSetting(string extensionName)
        {
            ExtensionName = extensionName;
            dict = new Dictionary<string, string>();
        }
    }
}
