﻿using System.Windows.Forms;
using System.IO;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;

namespace NotepadNeue
{
    public partial class Form1 : Form
    {
        public bool checkword(VariableInfo[] vis)
        {
            if (!inputassist) return false;
            int begin = 0, end = 0;
            this.azukiControl1.GetSelection(out begin, out end);
            if (end - begin == 0 && begin > 0)
            {
                //先頭データ探索
                int iter = begin - 1;
                int endanchor = begin;
                List<string[]> parserdata = new List<string[]>(10);
                while (true)
                {
                    if (iter < 0)
                    {
                        string[] tempdata = new string[] { "", this.azukiControl1.GetTextInRange(iter + 1, endanchor) };
                        parserdata.Add(tempdata);
                        iter++;
                        break;
                    }
                    char c = this.azukiControl1.Document[iter];
                    if (Char.IsLetterOrDigit(c) || c == '\t')
                    {
                        iter--;
                        continue;
                    }
                    //オブジェクトアクセサか調べる
                    bool found = false;
                    for (int i = 0; i < objectaccessor.Length; i++)
                    {
                        string accessor = objectaccessor[i];
                        if (accessor == string.Empty) continue;
                        if (iter - accessor.Length + 1 >= 0)
                        {
                            if (this.azukiControl1.Document.GetTextInRange(iter - accessor.Length + 1, iter + 1) == accessor)
                            {
                                string attribute = accessor == namespaceaccessor ? "oaornsa" : "oa";
                                string[] tempdata = new string[] { attribute, this.azukiControl1.GetTextInRange(iter + 1, endanchor) };
                                parserdata.Add(tempdata);
                                iter -= accessor.Length;
                                endanchor = iter + 1;
                                found = true;
                                break;
                            }
                        }
                        else
                        {
                            continue;
                        }
                    }
                    if (found) continue;
                    //名前空間アクセサか調べる
                    if (namespaceaccessor != "")
                    {
                        if (iter - namespaceaccessor.Length + 1 >= 0)
                        {
                            if (this.azukiControl1.Document.GetTextInRange(iter - namespaceaccessor.Length + 1, iter + 1) == namespaceaccessor)
                            {
                                string[] tempdata = new string[] { "nsa", this.azukiControl1.GetTextInRange(iter + 1, endanchor) };
                                parserdata.Add(tempdata);
                                iter -= namespaceaccessor.Length;
                                endanchor = iter + 1;
                                continue;
                            }
                        }
                    }
                    //止まる
                    iter++;
                    string[] temp = new string[] { "", this.azukiControl1.GetTextInRange(iter, endanchor) };
                    parserdata.Add(temp);
                    break;
                }
                if (parserdata.Count <= 1)
                {
                    //グローバルデータ
                    //データグリッドの表示
                    if (VariableDatas != null)
                    {
                        refreshdatagrid();
                        Monitor.Enter(ForLock);
                        userfunctions = VariableDatas.GetfData(begin);
                        //Monitor.Exit(ForLock);
                        addtodatagriduserfunction();
                        //Monitor.Enter(ForLock);
                        addtodatagridglobalobject();
                        addtodatagridglobalfunction();
                        addtodatagridglobalnamespace();
                        Monitor.Exit(ForLock);
                    }
                    addtodatagridvariableinfo(vis);
                    changestyledatagrid();
                    string data = parserdata[0][1];
                    data = data.Trim(new char[] { '\t', '\r', '\n', ' ' });
                    if (iter - allowstringwhenassist.Length >= 0 && this.azukiControl1.Document.GetTextInRange(iter - allowstringwhenassist.Length, iter) == allowstringwhenassist)
                    {
                        data = allowstringwhenassist + data;
                    }
                    if (data == "") return false;
                    int findresult = hitindatagrid(data);
                    if (findresult == -1)
                    {
                        findresult = hitindatagridcap(data.ToLower());
                    }
                    if (findresult != -1 && !this.azukiControl1.Document.ShouldBeIgnoredGrammatically(begin - data.Length))
                    {
                        this.dataGridView2.Visible = true;
                        Point p = this.azukiControl1.GetPositionFromIndex(begin - data.Length);
                        this.dataGridView2.Location = this.PointToClient(azukiControl1.PointToScreen((new Point(p.X, p.Y + this.azukiControl1.Font.Height))));
                        this.dataGridView2.FirstDisplayedScrollingRowIndex = Math.Max(findresult - (int)(nu.DisplayAssistnum / 2), 0);
                        this.dataGridView2.Rows[findresult].Selected = true;
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    //オブジェクト、名前空間参照
                    //まず、最初の文字列が何かを判別する
                    string objectornamespaceorvariable = parserdata[parserdata.Count - 1][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                    string type = parserdata[parserdata.Count - 2][0];
                    if (type == "oa")
                    {
                        //変数が定義されているか
                        string objecttype = "";
                        bool found = false;
                        for (int j = 0; j < vis.Length; j++)
                        {
                            if (vis[j].Name == objectornamespaceorvariable)
                            {
                                objecttype = vis[j].Type;
                                found = true;
                                break;
                            }
                        }
                        ObjectInfo firstobject = null;
                        if (found)
                        {
                            firstobject = GetObjectInfoFromCurrentBuffer(objecttype);
                        }
                        if (firstobject != null)
                        {
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridobjectvariableandfunction(firstobject);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "oa") return false;
                                    string target = parserdata[j][1];
                                    VariableInfo tempvi = firstobject.GetVariableInfo(target);
                                    if (tempvi == null) return false;
                                    firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                                    if (firstobject == null) return false;
                                }
                            }
                        }
                    }
                    else if (type == "nsa")
                    {
                        //今のアクセスできるネームスペースか調べる
                        Monitor.Enter(ForLock);
                        ArrayList temp = currentglobalnamespace;
                        Monitor.Exit(ForLock);
                        NameSpaceManager firstnamespace = null;
                        for (int i = 0; i < temp.Count; i++)
                        {
                            if ((temp[i] as NameSpaceManager).Name == objectornamespaceorvariable)
                            {
                                firstnamespace = temp[i] as NameSpaceManager;
                            }
                        }
                        if (firstnamespace == null)
                        {
                            //オブジェクトのタイプかもしれないので調べる
                            ObjectInfo firstobject = GetObjectInfoFromCurrentBuffer(objectornamespaceorvariable);
                            if (firstobject == null) return false;//no hit
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridobjectvariableandfunction(firstobject);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "oa") return false;
                                    string target = parserdata[j][1];
                                    VariableInfo tempvi = firstobject.GetVariableInfo(target);
                                    if (tempvi == null) return false;
                                    firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                                    if (firstobject == null) return false;
                                }
                            }
                        }
                        else
                        {
                            //名前空間があった
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridnamespaceobjectandfunctionandnamespace(firstnamespace);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "nsa") return false;
                                    string target = parserdata[j][1];
                                    NameSpaceManager nsm = firstnamespace.GetNameSpaceManager(target);
                                    if (nsm == null) return false;
                                    firstnamespace = nsm;
                                }
                            }
                        }
                    }
                    else if (type == "oaornsa")
                    {
                        //変数定義を調べる
                        string objecttype = "";
                        bool found = false;
                        for (int j = 0; j < vis.Length; j++)
                        {
                            if (vis[j].Name == objectornamespaceorvariable)
                            {
                                objecttype = vis[j].Type;
                                found = true;
                                break;
                            }
                        }
                        ObjectInfo firstobject = null;
                        ObjectInfo firstobjecttype = null;
                        NameSpaceManager firstnamespace = null;
                        if (found)
                        {
                            firstobject = GetObjectInfoFromCurrentBuffer(objecttype);
                        }
                        if (firstobject == null)
                        {
                            //名前空間か調べる
                            Monitor.Enter(ForLock);
                            ArrayList temp = currentglobalnamespace;
                            Monitor.Exit(ForLock);
                            for (int i = 0; i < temp.Count; i++)
                            {
                                if ((temp[i] as NameSpaceManager).Name == objectornamespaceorvariable)
                                {
                                    firstnamespace = temp[i] as NameSpaceManager;
                                }
                            }
                            if (firstnamespace == null)
                            {
                                //オブジェクトのタイプか調べる
                                firstobjecttype = GetObjectInfoFromCurrentBuffer(objectornamespaceorvariable);
                                if (firstobjecttype == null) return false;//no hit all
                            }
                        }
                        //something hit
                        if (firstobject != null)
                        {
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridobjectvariableandfunction(firstobject);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "oaornsa") return false;
                                    string target = parserdata[j][1];
                                    VariableInfo tempvi = firstobject.GetVariableInfo(target);
                                    if (tempvi == null) return false;
                                    firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                                    if (firstobject == null) return false;
                                }
                            }
                        }
                        else if (firstnamespace != null)
                        {
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridnamespaceobjectandfunctionandnamespace(firstnamespace);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "oaornsa") return false;
                                    string target = parserdata[j][1];
                                    NameSpaceManager nsm = firstnamespace.GetNameSpaceManager(target);
                                    if (nsm == null) return false;
                                    firstnamespace = nsm;
                                }
                            }
                        }
                        else if (firstobjecttype != null)
                        {
                            for (int j = parserdata.Count - 2; j >= 0; j--)
                            {
                                if (j == 0)
                                {
                                    string target = parserdata[0][1].Trim(new char[] { '\t', '\r', '\n', ' ' });
                                    cleardatagrid();
                                    addtodatagridobjectvariableandfunction(firstobject);
                                    changestyledatagrid();
                                    return showorhidedatagrid(target, begin);
                                }
                                else
                                {
                                    //j != 0
                                    string accestype = parserdata[j - 1][0];
                                    if (accestype != "oaornsa") return false;
                                    string target = parserdata[j][1];
                                    VariableInfo tempvi = firstobject.GetVariableInfo(target);
                                    if (tempvi == null) return false;
                                    firstobject = GetObjectInfoFromCurrentBuffer(tempvi.Type);
                                    if (firstobject == null) return false;
                                }
                            }
                        }
                    }
                    else
                    {//error

                    }
                }

            }
            return false;
        }
        public bool showorhidedatagrid(string target,int begin)
        {
            if (target == "")
            {
                this.dataGridView2.Visible = true;
                Point p = this.azukiControl1.GetPositionFromIndex(begin - 1);
                this.dataGridView2.Location = this.PointToClient(azukiControl1.PointToScreen((new Point(p.X, p.Y + this.azukiControl1.Font.Height))));
                this.dataGridView2.FirstDisplayedScrollingRowIndex = 0;
                this.dataGridView2.Rows[0].Selected = true;
                return true;
            }
            else
            {
                int findresult = hitindatagrid(target);
                if (findresult == -1)
                {
                    findresult = hitindatagridcap(target.ToLower());
                }
                if (findresult != -1 && !this.azukiControl1.Document.ShouldBeIgnoredGrammatically(begin - target.Length))
                {
                    this.dataGridView2.Visible = true;
                    Point p = this.azukiControl1.GetPositionFromIndex(begin - target.Length);
                    this.dataGridView2.Location = this.PointToClient(azukiControl1.PointToScreen((new Point(p.X, p.Y + this.azukiControl1.Font.Height))));
                    this.dataGridView2.FirstDisplayedScrollingRowIndex = Math.Max(findresult - (int)(nu.DisplayAssistnum / 2), 0);
                    this.dataGridView2.Rows[findresult].Selected = true;
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        public ObjectInfo GetObjectInfoFromCurrentBuffer(string type)
        {
            ObjectInfo ret = null;
            Monitor.Enter(ForLock);
            ArrayList temp = currentloadedbuffername;
            Monitor.Exit(ForLock);
            for (int i = 0; i < temp.Count; i++)
            {
                NameSpaceManager nsm = null;
                bufferdata.TryGetValue(temp[i] as string, out nsm);
                if (nsm != null)
                {
                    ObjectInfo oi = nsm.GetObjectInfo(type);
                    if (oi != null)
                    {
                        ret = oi;
                        break;
                    }
                }
            }
            if (ret == null)
            {
                Monitor.Enter(ForLock);
                temp = currentglobalnamespace;
                Monitor.Exit(ForLock);
                for (int j = 0; j < temp.Count; j++)
                {
                    ObjectInfo oi = (temp[j] as NameSpaceManager).GetObjectInfo(type);
                    if (oi != null)
                    {
                        ret = oi;
                        break;
                    }
                }
            }
            return ret;
        }
        public string findfunccontent(string functionname)
        {
            int index = Array.BinarySearch(funcname, functionname);
            if (index >= 0 && index < funccontent.Length)
            {
                return funccontent[index];
            }
            if (userfunctions != null)
            {
                for (int i = 0; i < userfunctions.Length; i++)
                {
                    if (userfunctions[i].Name == functionname)
                    {
                        currentdisplayfunctionindex = i;
                        return userfunctions[i].ContentAt(userfunctions[i].Displaynum) + userfunctions[i].NumOfOverride;
                    }
                }
            }
            return "";
        }
        public int hitindatagrid(string data)
        {
            for (int i = 0; i < this.dataGridView2.RowCount; i++)
            {
                string griddata = this.dataGridView2[1, i].Value.ToString();
                if (griddata.StartsWith(data))
                {
                    if (griddata == data)
                    {
                        if (i + 1 < this.dataGridView2.RowCount && this.dataGridView2[1, i + 1].Value.ToString().StartsWith(data))
                        {
                            return i;
                        }
                        return -1;
                    }
                    return i;
                }
            }
            return -1;
        }
        public int hitindatagridcap(string data)
        {
            for (int i = 0; i < this.dataGridView2.RowCount; i++)
            {
                string griddata = this.dataGridView2[1, i].Value.ToString().ToLower();
                if (griddata.StartsWith(data))
                {
                    if (griddata == data)
                    {
                        if (i + 1 < this.dataGridView2.RowCount && this.dataGridView2[1, i + 1].Value.ToString().ToLower().StartsWith(data))
                        {
                            return i;
                        }
                        return -1;
                    }
                    return i;
                }
            }
            return -1;
        }
        public bool Replaceassist()
        {
            int begin = 0, end = 0;
            this.azukiControl1.GetSelection(out begin, out end);
            if (end - begin == 0 && this.dataGridView2.SelectedRows.Count > 0 && begin > 0)
            {
                //変換する部分を探す
                int iter = begin - 1;
                while (true)
                {
                    if (iter < 0)
                    {
                        iter++;
                        break;
                    }
                    char c = this.azukiControl1.Document[iter];
                    if (Char.IsLetterOrDigit(c))
                    {
                        iter--;
                        continue;
                    }
                    iter++;
                    break;
                }
                //string data = this.azukiControl1.GetTextInRange(iter, begin);
                int zure = 0;
                if (iter - allowstringwhenassist.Length >= 0 && this.azukiControl1.Document.GetTextInRange(iter - allowstringwhenassist.Length, iter) == allowstringwhenassist)
                {
                    zure = -allowstringwhenassist.Length;
                }
                this.azukiControl1.Document.Replace(this.dataGridView2[1, this.dataGridView2.SelectedRows[0].Index].Value.ToString(), iter + zure, begin);
                this.dataGridView2.Visible = false;
                this.myToolTip1.Hide();
                return true;
            }
            return false;
        }
        int headcharindexforreplace = 0;
        int currentreplaceindex;
        public void checkformat(int lineindex)
        {

            string data = this.azukiControl1.Document.GetLineContent(lineindex);
            int head, tail;
            head = this.azukiControl1.Document.GetLineHeadIndex(lineindex);
            headcharindexforreplace = head;
            tail = head + data.Length;
            for (int i = 0; i < operationdata.Length; i++)
            {
                currentreplaceindex = i;
                ignorepoint = new int[ignorepattern.Length][];
                for (int j = 0; j < ignorepoint.Length; j++)
                {
                    System.Text.RegularExpressions.Match match = System.Text.RegularExpressions.Regex.Match(data, ignorepattern[j]);
                    int[] tempintarray = new int[] { match.Index, match.Length };
                    ignorepoint[j] = tempintarray;
                }
                try
                {
                    System.Text.RegularExpressions.Regex regex = new System.Text.RegularExpressions.Regex(operationdata[i][0]);
                    string newdata = regex.Replace(data, new System.Text.RegularExpressions.MatchEvaluator(CheckIgnore));
                    if (!String.Equals(newdata, data))
                    {
                        data = newdata;
                        this.azukiControl1.Document.Replace(newdata, head, tail);
                        tail = head + data.Length;
                        int dirtybegin = head, dirtyend = tail;
                        this.azukiControl1.Document.Highlighter.Highlight(this.azukiControl1.Document, ref dirtybegin, ref dirtyend);
                    }
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message);
                }
            }
        }
        public string CheckIgnore(System.Text.RegularExpressions.Match m)
        {
            if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(headcharindexforreplace + m.Index) || checkignorepattern(m.Index))
            {
                return m.Value;
            }
            else
            {
                return m.Result(operationdata[currentreplaceindex][1]);
            }
        }
        public bool checkignorepattern(int index)
        {
            for (int i = 0; i < ignorepoint.Length; i++)
            {
                if (ignorepoint[i][0] <= index && index <= ignorepoint[i][0] + ignorepoint[i][1])
                {
                    return true;
                }
            }
            return false;
        }
        public void checkindent(int lineindex)
        {
            if (lineindex > 0)
            {
                string data = this.azukiControl1.Document.GetLineContent(lineindex);
                int length = data.Length;
                string beforedata = this.azukiControl1.Document.GetLineContent(lineindex - 1);
                int beforehead = this.azukiControl1.GetLineHeadIndex(lineindex - 1),
                    currenthead = this.azukiControl1.GetLineHeadIndex(lineindex);
                int beforelevel = countlevel(beforedata, beforehead);
                int currentlevel = justcountheadcountlevel(data, currenthead);
                int minuslevel = countclosesignnum(data, currenthead);
                minuslevel = minuslevel < 0 ? 0 : minuslevel;
                if (beforelevel != currentlevel + minuslevel)
                {
                    data = data.TrimStart(new char[] { '\t', ' ' });
                    StringBuilder sb = new StringBuilder();
                    if (beforelevel - minuslevel >= 0)
                    {
                        sb.Append('\t', beforelevel - minuslevel);
                    }
                    sb.Append(data);
                    data = sb.ToString();
                    this.azukiControl1.Document.Replace(data, currenthead, currenthead + length);
                }
            }
            else if(lineindex == 0)
            {
                string data = this.azukiControl1.Document.GetLineContent(lineindex);
                int length = data.Length;
                data = data.TrimStart(new char[] { '\t', ' ' });
                this.azukiControl1.Document.Replace(data, 0, length);
            }
        }
        public int countlevel(string data, int startindex)
        {
            int ret = 0, iter = 0;
            bool openfound = false;
            while (iter < data.Length)
            {
                if (!this.azukiControl1.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (data[iter] == '\t')
                    {
                        ret++;
                    }
                    else if (data[iter] == '{')
                    {
                        ret++;
                        openfound = true;
                    }
                    else if (data[iter] == '}' && openfound)
                    {
                        ret--;
                    }
                }
                iter++;
            }
            return ret;
        }
        public int justcountheadcountlevel(string data, int startindex)
        {
            int ret = 0, iter = 0;
            while (iter < data.Length)
            {
                if (!this.azukiControl1.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (data[iter] == '\t')
                    {
                        ret++;
                    }
                    else if (data[iter] == ' ')
                    {
                        ret = 100;
                        return ret;
                    }
                    else
                    {
                        break;
                    }
                }
                else
                {
                    break;
                }
                iter++;
            }
            return ret;
        }
        public int countclosesignnum(string data, int startindex)
        {
            int ret = 0, iter = 0;
            while (iter < data.Length)
            {
                if (!this.azukiControl1.Document.ShouldBeIgnoredGrammatically(startindex + iter))
                {
                    if (data[iter] == '{')
                    {
                        ret--;
                    }
                    if (data[iter] == '}')
                    {
                        ret++;
                    }
                }
                iter++;
            }
            return ret;
        }
        public void clearbottomtext()
        {
            this.toolStripStatusLabel2.Text = "";
            this.toolStripStatusLabel3.Text = "";
        }
        public bool isvalidchar(char c)
        {
            if (c < 0x30)
                return false;
            else if (c >= 58 && c < 64)
                return false;
            else if (c >= 91 && c < 96)
                return false;
            else if (c >= 123)
                return false;
            return true;
        }
        public void Changereferencetext(string text, int index)
        {
            Point p = this.PointToClient(azukiControl1.PointToScreen(this.azukiControl1.GetPositionFromIndex(index)));
            this.myToolTip1.DisplayText = text;
            this.myToolTip1.Location = new Point(p.X, p.Y + this.azukiControl1.Font.Height);
            this.myToolTip1.Show();
        }
        public bool checkfunction()
        {
            //for inputreference
            if (inputreference)
            {
                int lineindex = 0, columnindex = 0;
                this.azukiControl1.Document.GetCaretIndex(out lineindex, out columnindex);
                string linedata = this.azukiControl1.Document.GetLineContent(lineindex);
                int anchor = columnindex;
                bool findanchor = false;
                int headcharindex = this.azukiControl1.GetLineHeadIndex(lineindex);
                int kakkocount = 0;
                for (int i = Math.Min(columnindex, linedata.Length - 1); i >= 0; i--)
                {
                    if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(headcharindex + i)) continue;
                    if (findanchor)
                    {
                        string maybefuncname = String.Empty;
                        if (kakkocount == -1)
                        {
                            if (!isvalidchar(linedata[i]))
                            {
                                maybefuncname = linedata.Substring(i + 1, anchor - i - 1);
                                maybefuncname = findfunccontent(maybefuncname);
                                if (maybefuncname == "")
                                {
                                    findanchor = true;
                                    anchor = i;
                                }
                                else
                                {

                                    int charindex = headcharindex + i;
                                    Changereferencetext(maybefuncname, charindex);
                                    return true;
                                }
                            }
                            else if (i == 0)
                            {
                                maybefuncname = linedata.Substring(i, anchor - i);
                                maybefuncname = findfunccontent(maybefuncname);
                                if (maybefuncname != "")
                                {
                                    int charindex = headcharindex + i;
                                    Changereferencetext(maybefuncname, charindex);
                                    return true;
                                }
                            }
                        }
                    }
                    if (linedata[i] == '(' && i > 0)
                    {
                        anchor = i;
                        findanchor = true;
                        kakkocount--;
                    }
                    if (linedata[i] == ')')
                    {
                        kakkocount++;
                    }
                }
            }
            return false;
        }
        public void analyze()
        {
            string alldata = this.azukiControl1.Text;
            try
            {
                Monitor.Enter(ForLock);
                checkbufferfile(alldata);
                checknamespaceuse(alldata);
                checkdefaultobject();
                checklevelenclosure(alldata);
                checkobjectdefine(alldata);
                checkfunctiondefine(alldata);
                checkvariabledefine(alldata);
                Monitor.Exit(ForLock);
            }
            catch (Exception e)
            {
#if DEBUG
                MessageBox.Show(e.Message);
#endif
            }
            variabledatacreated = true;
        }
        public void checkbufferfile(string data)
        {
            if (includefileregex != "")
            {
                ArrayList bufferloadname = new ArrayList(10);
                foreach (System.Text.RegularExpressions.Match m in System.Text.RegularExpressions.Regex.Matches(data, includefileregex))
                {
                    if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(m.Index)) continue;
                    string filename = m.Groups[1].Captures[0].Value;
                    if (!bufferloadname.Contains(filename))
                    {
                        bufferloadname.Add(filename);
                    }
                    if (!bufferdata.ContainsKey(filename))
                    {
                        if (File.Exists(currentdirectory + "\\" + bufferdirectory + "\\" + filename))
                        {
                            NameSpaceManager nsm = new NameSpaceManager();
                            bufferdata.Add(filename, nsm);
                            XMLBufferReader bufferreader = new XMLBufferReader(currentdirectory + "\\" + bufferdirectory + "\\" + filename);
                            bufferreader.namespacemanager = nsm;
                            bufferreader.Parse();
                        }
                    }
                }
                currentloadedbuffername = bufferloadname;
            }
        }
        public void checknamespaceuse(string data)
        {
            if (namespaceuseregex != "")
            {
                ArrayList namespacename = new ArrayList(4);
                foreach (System.Text.RegularExpressions.Match m in System.Text.RegularExpressions.Regex.Matches(data, namespaceuseregex))
                {
                    if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(m.Index)) continue;
                    string name = m.Groups[1].Captures[0].Value;
                    namespacename.Add(name);
                }
                currentusingnamespace = namespacename;
            }
        }
        public void checkdefaultobject()
        {
            currentglobalclass = new ArrayList(10);
            currentglobalnamespace = new ArrayList(10);
            currentglobalfunction = new ArrayList(10);
            for (int i = 0; i < currentloadedbuffername.Count; i++)
            {
                NameSpaceManager nsm = null;
                bufferdata.TryGetValue(currentloadedbuffername[i] as string, out nsm);
                if (nsm == null) continue;
                foreach (ObjectInfo oi in nsm.GetAllObjectType())
                {
                    string[] objecttypedata = new string[] { oi.Name, oi.Name };
                    currentglobalclass.Add(objecttypedata);
                }
                foreach (FunctionInfo fi in nsm.GetALLFunction())
                {
                    currentglobalfunction.Add(fi);
                }
                foreach (NameSpaceManager nsmane in nsm.GetALLNameSpace())
                {
                    currentglobalnamespace.Add(nsmane);
                }
                for (int j = 0; j < currentusingnamespace.Count; j++)
                {
                    NameSpaceManager childnsm = nsm;
                    string tempdata = "";
                    string[] namespaces = (currentusingnamespace[j] as string).Split(new string[] { namespaceaccessor }, StringSplitOptions.None);
                    for (int k = 0; k < namespaces.Length; k++)
                    {
                        childnsm = childnsm.GetNameSpaceManager(namespaces[k]);
                        if (childnsm == null) break;
                        if (k == namespaces.Length - 1)
                        {
                            foreach (ObjectInfo oi in childnsm.GetAllObjectType())
                            {
                                string[] objecttypedata = new string[] { oi.Name, tempdata + oi.Name };
                                currentglobalclass.Add(objecttypedata);
                            }
                            foreach (FunctionInfo fi in childnsm.GetALLFunction())
                            {
                                currentglobalfunction.Add(fi);
                            }
                            foreach (NameSpaceManager nsmane in childnsm.GetALLNameSpace())
                            {
                                currentglobalnamespace.Add(nsmane);
                            }
                        }
                        else
                        {
                            tempdata += childnsm.Name + ".";
                        }
                    }
                }
            }
        }
        public void checklevelenclosure(string data)
        {
            if (levelenclosures.Length > 1)
            {
                VariableDatas = new BasicTree();
                VariableDatas.Start = 0;
                VariableDatas.End = this.azukiControl1.TextLength;
                List<BasicTree> list = new List<BasicTree>(10);
                list.Add(VariableDatas);
                int temp = 0;
                int openindex = (temp = data.IndexOf(levelenclosures[0])) == -1 ? int.MaxValue : temp;
                int closeindex = (temp = data.IndexOf(levelenclosures[1])) == -1 ? int.MaxValue : temp;
                while (openindex != int.MaxValue || closeindex != int.MaxValue)
                {
                    int minimum = Math.Min(openindex, closeindex);
                    if (!this.azukiControl1.Document.ShouldBeIgnoredGrammatically(minimum))
                    {
                        if (minimum == openindex)
                        {
                            BasicTree beforebt = list[list.Count - 1];
                            int tempminimum = minimum;
                            if (functionscoperegex != "")
                            {
                                BasicTree beforebthavebt = null;
                                foreach (EitherVariableOrTree et in beforebt.evot)
                                {
                                    if (et.VariableInfo != null)
                                    {
                                        beforebthavebt = et.BasicTree;
                                    }
                                }
                                int checkstartpos = 0;
                                if (beforebthavebt == null)
                                {
                                    checkstartpos = beforebt.Start;
                                }
                                else
                                {
                                    checkstartpos = beforebthavebt.End;
                                }
                                string target = data.Substring(checkstartpos, minimum - checkstartpos);
                                System.Text.RegularExpressions.Match m = System.Text.RegularExpressions.Regex.Match(target, functionscoperegex);
                                if (m.Success)
                                {
                                    tempminimum = checkstartpos + m.Index;
                                }
                            }
                            BasicTree bt = new BasicTree();
                            bt.Start = tempminimum;
                            bt.End = VariableDatas.End;
                            list.Add(bt);
                            EitherVariableOrTree evot = new EitherVariableOrTree();
                            evot.BasicTree = bt;
                            beforebt.AddData(evot, tempminimum);
                        }
                        else
                        {
                            if (list.Count > 1)
                            {
                                BasicTree bt = list[list.Count - 1];
                                bt.End = minimum;
                                list.Remove(bt);
                            }
                            else
                            {
                                //error!!
                            }
                        }
                    }
                    if (minimum + 1 >= data.Length) break;
                    openindex = (temp = data.IndexOf(levelenclosures[0], minimum + 1)) == -1 ? int.MaxValue : temp;
                    closeindex = (temp = data.IndexOf(levelenclosures[1], minimum + 1)) == -1 ? int.MaxValue : temp;
                }
            }
        }
        public void checkobjectdefine(string data)
        {

        }
        public void checkfunctiondefine(string data)
        {
            if (functiondefinition.Length < 2) return;
            for (int i = 0; i < defaulttype.Length; i++)
            {
                string pattern = functiondefinition[0].Replace("\"type\"", defaulttype[i]);
                foreach (System.Text.RegularExpressions.Match m in System.Text.RegularExpressions.Regex.Matches(data, pattern))
                {
                    if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(m.Index)) continue;
                    FunctionInfo finfo = new FunctionInfo();
                    finfo.Start = m.Groups[0].Captures[0].Index;
                    finfo.Content = m.Groups[0].Captures[0].Value;
                    //treeの位置決定
                    BasicTree shouldbein = VariableDatas.getTreeshouldbeinput(finfo.Start);
                    pattern = functiondefinition[1].Replace("\"type\"", defaulttype[i]);
                    foreach (System.Text.RegularExpressions.Match mm in System.Text.RegularExpressions.Regex.Matches(m.Groups[1].Captures[0].Value, pattern))
                    {
                        bool changed = false;
                        foreach (FunctionInfo fi in shouldbein.finfos)
                        {
                            if (fi.Name == mm.Groups[1].Captures[0].Value)
                            {
                                if (!fi.ifcontainsamecontent(finfo.ContentAt(0)))
                                {
                                    fi.Content = finfo.ContentAt(0);
                                }
                                changed = true;
                            }
                        }
                        if (!changed)
                        {
                            finfo.Name = mm.Groups[1].Captures[0].Value;
                            finfo.Type = defaulttype[i];
                            shouldbein.AddfData(finfo, finfo.Start);
                        }
                    }
                }
            }
        }
        public void checkvariabledefine(string data)
        {
            if (VariableDatas == null) return;
            recursivevariabledefine(VariableDatas, data);
        }
        public void recursivevariabledefine(BasicTree bt, string st)
        {
            if (variabledefinition.Length < 1) return;
            ArrayList temp = new ArrayList(3);
            foreach (EitherVariableOrTree evot in bt.evot)
            {
                if (evot.VariableInfo == null)
                {
                    temp.Add(evot.BasicTree);
                }
            }
            if (temp.Count == 0)
            {
                subcheckvariabledefine(bt, st);
            }
            else
            {
                //start
                BasicTree tempbt = temp[0] as BasicTree;
                string target = st.Substring(0, tempbt.Start - bt.Start);
                subcheckvariabledefine(bt, target);
                for (int i = 0; i < temp.Count; i++)
                {
                    tempbt = temp[i] as BasicTree;
                    recursivevariabledefine(tempbt, st.Substring(tempbt.Start - bt.Start, (tempbt.End - bt.Start) - (tempbt.Start - bt.Start)));
                    //bitween
                    if (i > 0)
                    {
                        BasicTree tempbt2 = temp[i - 1] as BasicTree;
                        target = st.Substring(tempbt2.End - bt.Start, tempbt.Start - tempbt2.End);
                        subcheckvariabledefine(bt, target);
                    }
                }
                //end
                tempbt = temp[temp.Count - 1] as BasicTree;
                target = st.Substring(tempbt.End - bt.Start);
                subcheckvariabledefine(bt, target);
            }
        }
        public void subcheckvariabledefine(BasicTree bt, string target)
        {
            for (int g = 0; g < variabledefinition.Length; g++)
            {
                for (int i = 0; i < defaulttype.Length + currentglobalclass.Count; i++)
                {
                    string pattern = String.Empty;
                    string type = string.Empty;
                    if (i >= defaulttype.Length)
                    {
                        string[] objecttype = currentglobalclass[i - defaulttype.Length] as string[];
                        pattern = variabledefinition[g][0].Replace("\"type\"", objecttype[0]);
                        type = objecttype[1];
                    }
                    else
                    {
                        pattern = variabledefinition[g][0].Replace("\"type\"", defaulttype[i]);
                    }
                    foreach (System.Text.RegularExpressions.Match m in System.Text.RegularExpressions.Regex.Matches(target, pattern))
                    {
                        for (int j = 1; j < m.Groups.Count; j++)
                        {
                            for (int k = 0; k < m.Groups[j].Captures.Count; k++)
                            {
                                int start = 0, end = m.Groups[j].Captures[k].Length;
                                if (variabledefinition[g].Length > 1) ifincluderegex(m.Groups[j].Captures[k].Value, g, 1, i, out start, out end);
                                if (start == -1) continue;
                                VariableInfo vi = new VariableInfo();
                                vi.Name = m.Groups[j].Captures[k].Value.Substring(start, end);
                                vi.Type = type;
                                vi.Start = m.Groups[j].Captures[k].Index + bt.Start + start;
                                vi.End = vi.Start + end;
                                EitherVariableOrTree evot = new EitherVariableOrTree();
                                evot.VariableInfo = vi;
                                bt.AddData(evot, vi.Start);
                            }
                        }
                    }
                }
            }
        }
        public void ifincluderegex(string s, int definitioncount, int filterlevel, int defaulttypeindex, out int start, out int end)
        {
            start = -1;
            end = -1;
            string pattern = String.Empty;
            if (defaulttypeindex >= defaulttype.Length)
            {
                string[] objecttype = currentglobalclass[defaulttypeindex - defaulttype.Length] as string[];
                pattern = variabledefinition[definitioncount][filterlevel].Replace("\"type\"", objecttype[0]);
            }
            else
            {
                pattern = variabledefinition[definitioncount][filterlevel].Replace("\"type\"", defaulttype[defaulttypeindex]);
            }
            System.Text.RegularExpressions.Match m = System.Text.RegularExpressions.Regex.Match(s, pattern);
            if (m.Success)
            {
                if (filterlevel < variabledefinition.Length - 1)
                {
                    int tempstart = 0, tempend = 0;
                    ifincluderegex(m.Value, definitioncount, filterlevel + 1, defaulttypeindex, out tempstart, out tempend);
                    if (tempstart == -1)
                    {
                        start = -1;
                        end = -1;
                        return;
                    }
                    else
                    {
                        start = m.Groups[1].Captures[0].Index + tempstart;
                        end = m.Groups[1].Captures[0].Index + tempend;
                        return;
                    }
                }
                else
                {
                    start = m.Groups[1].Captures[0].Index;
                    end = m.Groups[1].Captures[0].Length;
                    return;
                }
            }
            else
            {
                start = -1;
                end = -1;
                return;
            }
        }
        public void refreshdatagrid()
        {
            this.dataGridView2.Rows.Clear();
            this.dataGridView2.Rows.AddRange(defaultdatarows);
        }
        public void cleardatagrid()
        {
            this.dataGridView2.Rows.Clear();
        }
        public void addtodatagridvariableinfo(VariableInfo[] vis)
        {
            for (int i = 0; i < vis.Length; i++)
            {
                if (this.azukiControl1.Document.ShouldBeIgnoredGrammatically(vis[i].Start)) continue;
                this.dataGridView2.RowCount++;
                Bitmap b = NotepadNeue.Properties.Resources.variable;
                b.Tag = "variable";
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = b;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = vis[i].Name;
            }
        }
        public void changestyledatagrid()
        {
            adjustdatagrigheight();
            removesameindatagrid();
        }
        public void addtodatagriduserfunction()
        {
            for (int i = 0; i < userfunctions.Length; i++)
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources.function;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = userfunctions[i].Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(userfunctions[i].ContentAt(0));
            }
        }
        public void addtodatagridglobalobject()
        {
            if (currentglobalclass == null) return;
            for (int i = 0; i < currentglobalclass.Count; i++)
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources._class;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = (currentglobalclass[i] as string[])[0];
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid((currentglobalclass[i] as string[])[1]);
            }
        }
        public void addtodatagridglobalfunction()
        {
            if (currentglobalfunction == null) return;
            for (int i = 0; i < currentglobalfunction.Count; i++)
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources.function;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = (currentglobalfunction[i] as FunctionInfo).Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid((currentglobalfunction[i] as FunctionInfo).ContentAt(0));
            }
        }
        public void addtodatagridglobalnamespace()
        {
            if (currentglobalnamespace == null) return;
            for (int i = 0; i < currentglobalnamespace.Count; i++)
            {   
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources._namespace;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = (currentglobalnamespace[i] as NameSpaceManager).Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid((currentglobalnamespace[i] as NameSpaceManager).Name);
            }
        }
        public void addtodatagridobjectvariableandfunction(ObjectInfo oi)
        {
            foreach (VariableInfo vi in oi.GetAllVariable())
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources.variable;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = vi.Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(vi.Type);
            }
            foreach (FunctionInfo fi in oi.GetAllMethod())
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources.function;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = fi.Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(fi.ContentAt(0));
            }
        }
        public void addtodatagridnamespaceobjectandfunctionandnamespace(NameSpaceManager nsm)
        {
            foreach (NameSpaceManager tempnsm in nsm.GetALLNameSpace())
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources._namespace;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = tempnsm.Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(tempnsm.Name);
            }
            foreach (ObjectInfo oi in nsm.GetAllObjectType())
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources._class;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = oi.Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(oi.Name);
            }
            foreach (FunctionInfo fi in nsm.GetALLFunction())
            {
                this.dataGridView2.RowCount++;
                this.dataGridView2[0, this.dataGridView2.RowCount - 1].Value = NotepadNeue.Properties.Resources.function;
                this.dataGridView2[1, this.dataGridView2.RowCount - 1].Value = fi.Name;
                this.dataGridView2[2, this.dataGridView2.RowCount - 1].Value = new InfoinDataGrid(fi.ContentAt(0));
            }
        }
        public void removesameindatagrid()
        {
            ArrayList shouldremove = new ArrayList(10);
            string before = "", current = "";
            for (int i = 0; i < dataGridView2.RowCount; i++)
            {
                current = dataGridView2[1, i].Value.ToString();
                if (String.Equals(current, before))
                {
                    Bitmap b = (Bitmap)this.dataGridView2[0, i].Value;
                    if (b.Tag != null)
                    {
                        if (b.Tag.ToString() == "variable")
                        {
                            if (!shouldremove.Contains(i))
                            {
                                shouldremove.Add(i);
                            }
                        }
                    }
                    b = (Bitmap)this.dataGridView2[0, i - 1].Value;
                    if (b.Tag != null)
                    {
                        if (b.Tag.ToString() == "variable")
                        {
                            shouldremove.Add(i - 1);
                        }
                    }
                }
                before = current;
            }
            for (int i = 0; i < shouldremove.Count; i++)
            {
                dataGridView2.Rows.RemoveAt((int)shouldremove[i] - i);
            }
        }
        public void adjustdatagrigheight()
        {
            if (this.dataGridView2.RowCount > 0)
            {
                this.dataGridView2.Sort(this.dataGridView2.Columns[1], ListSortDirection.Ascending);
                this.dataGridView2.Columns[1].Width = AutoSizeColumnWidth(this.dataGridView2, 1);
                this.dataGridView2.Width = this.dataGridView2.Columns[0].Width + this.dataGridView2.Columns[1].Width + 19;
                int a = this.dataGridView2.Rows[0].Height;
                int min = Math.Min(this.dataGridView2.RowCount, nu.DisplayAssistnum);
                this.dataGridView2.Height = a * (min);
            }
        }
    }
}