﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace NotepadNeue
{
    public partial class Form7 : Form
    {
        NotepadUtility utl;
        bool ignore = true;
        ColorDialog.CustomColorDialog ccd;
        public Form7()
        {
            InitializeComponent();
            SetAllFont();
            azukiControl1.Text = "[テストの文章です]\r\n　←全角スペース\r ←半角スペース\n\t←タブ\r\n";
            azukiControl1.Document.IsDirty = false;
            azukiControl1.Document.Replace("ダーティな行です", 36, 36);
            ccd = new ColorDialog.CustomColorDialog();
        }
        private void SetAllFont()
        {
            //InstalledFontCollectionオブジェクトの取得
            System.Drawing.Text.InstalledFontCollection ifc =
                new System.Drawing.Text.InstalledFontCollection();
            //インストールされているすべてのフォントファミリアを取得
            FontFamily[] ffs = ifc.Families;
            this.comboBox1.BeginUpdate();
            foreach (FontFamily ff in ffs)
            {
                //ここではスタイルにRegularが使用できるフォントのみを表示
                if (ff.IsStyleAvailable(FontStyle.Regular))
                {
                    this.comboBox1.Items.Add(ff.Name);
                }
            }
            this.comboBox1.EndUpdate();
        }
        private void button1_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Forecolor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.ForeColor = ccd.CurrentColor;
                utl.Forecolor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Backcolor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.BackColor = ccd.CurrentColor;
                utl.Backcolor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Selectionfore;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.SelectionFore = ccd.CurrentColor;
                utl.Selectionfore = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Selectionback;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.SelectionBack = ccd.CurrentColor;
                utl.Selectionback = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Correspondfore;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.MatchedBracketFore = ccd.CurrentColor;
                utl.Correspondfore = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Correspondback;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.MatchedBracketBack = ccd.CurrentColor;
                utl.Correspondback = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Linenumberfore;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.LineNumberFore = ccd.CurrentColor;
                utl.Linenumberfore = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Linenumberback;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.LineNumberBack = ccd.CurrentColor;
                utl.Linenumberback = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Highlightcolor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.HighlightColor = ccd.CurrentColor;
                utl.Highlightcolor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button12_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Eolcolor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.EolColor = ccd.CurrentColor;
                utl.Eolcolor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button13_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.Whitespacecolor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.WhiteSpaceColor = ccd.CurrentColor;
                utl.Whitespacecolor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }
        private void button15_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.EofColor;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.EofColor = ccd.CurrentColor;
                utl.EofColor = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button16_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.CleanedLineBar;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.CleanedLineBar = ccd.CurrentColor;
                utl.CleanedLineBar = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }

        private void button17_Click(object sender, EventArgs e)
        {
            ccd = new ColorDialog.CustomColorDialog();
            ccd.CurrentColor = utl.DirtyLineBar;
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                azukiControl1.ColorScheme.DirtyLineBar = ccd.CurrentColor;
                utl.DirtyLineBar = ccd.CurrentColor;
                checkchanged();
                utility.SetToEditor(azukiControl1);
            }
        }
        public NotepadUtility utility
        {
            get
            {
                return utl;
            }
            set
            {
                ignore = true;
                utl = value.Clone() as NotepadUtility;
                this.comboBox1.Text = utl.Fontname;
                this.comboBox2.Text = utl.Fontsize.ToString();
                this.comboBox3.Text = utl.UpdateInfomsec.ToString();
                this.comboBox4.Text = utl.DisplayAssistnum.ToString();
                this.checkBox1.Checked = utl.DrawEol;
                this.checkBox4.Checked = utl.DrawFullWidthSpace;
                this.checkBox5.Checked = utl.DrawLineNumber;
                this.checkBox3.Checked = utl.DrawSpace;
                this.checkBox2.Checked = utl.DrawTab;
                this.checkBox6.Checked = utl.HighlightCurrentline;
                this.checkBox7.Checked = utl.AskWhenNewlySave;
                this.notExecuteProgramWhenErrorCheckBox.Checked = utl.NotExecuteProgramWhenError;
                this.notExecuteProgramWhenWarningCheckBox.Checked = utl.NotExecuteProgramWhenWarning;
                this.checkBox9.Checked = utl.ShowDirtBar;
                this.checkBox10.Checked = utl.DrawEofMark;
                this.checkBox11.Checked = utl.ShowHRuler;
                this.checkBox12.Checked = utl.UseTabForIndent;
                this.checkBox13.Checked = utl.AutoFormatInScope;
                this.checkBox14.Checked = utl.AdjustOpenEnclosure;
                this.checkBox17.Checked = utl.AdjustCloseEnclosure;
                this.checkBox15.Checked = utl.AskSaveTabs;
                this.checkBox16.Checked = utl.SaveTabs;
                this.checkBox18.Checked = utl.DetectNewLineString;
                this.checkBox19.Checked = utl.TellMixedNewLine;
                this.textBox1.Text = utl.DefaultNewLineString.Replace("\n", "\\n").Replace("\r", "\\r");
                checkBox14.Enabled = utl.AutoFormatInScope;
                checkBox17.Enabled = utl.AutoFormatInScope;
                checkBox16.Enabled = !checkBox15.Checked;
                checkBox19.Enabled = utl.DetectNewLineString;
                int num = utl.TabWidth;
                if (num < 1) num = 3;
                if (num > 9) num = 3;
                this.comboBox5.Text = num.ToString();
                this.comboBox7.Text = utl.BackUpNum.ToString();
                utility.SetToEditor(azukiControl1);
                switch (utl.Antialias)
                {
                    case Sgry.Azuki.Antialias.Default:
                        this.comboBox6.SelectedIndex = 0;
                        break;
                    case Sgry.Azuki.Antialias.None:
                        this.comboBox6.SelectedIndex = 1;
                        break;
                    case Sgry.Azuki.Antialias.Gray:
                        this.comboBox6.SelectedIndex = 2;
                        break;
                    case Sgry.Azuki.Antialias.Subpixel:
                        this.comboBox6.SelectedIndex = 3;
                        break;
                    default:
                        this.comboBox6.SelectedIndex = 0;
                        break;
                }
                ignore = false;
            }
        }
        private void comboBox1_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void comboBox2_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void comboBox5_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void comboBox3_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged2();
            Updateutil();
        }

        private void comboBox4_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged2();
            Updateutil();
        }

        private void comboBox7_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged2();
            Updateutil();

        }
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void comboBox6_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void checkBox5_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void checkBox6_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void checkBox9_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }

        private void checkBox10_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void checkBox11_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void checkBox12_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged();
            Updateutil();
            utility.SetToEditor(azukiControl1);
        }
        private void Updateutil()
        {
            utl.DrawEol = this.checkBox1.Checked;
            utl.DrawFullWidthSpace = this.checkBox4.Checked;
            utl.DrawLineNumber = this.checkBox5.Checked;
            utl.DrawSpace = this.checkBox3.Checked;
            utl.DrawTab = this.checkBox2.Checked;
            utl.HighlightCurrentline = this.checkBox6.Checked;
            utl.ShowDirtBar = this.checkBox9.Checked;
            utl.DrawEofMark = this.checkBox10.Checked;
            utl.ShowHRuler = this.checkBox11.Checked;
            utl.UseTabForIndent = this.checkBox12.Checked;
            utl.Fontname = this.comboBox1.Text;
            float size = 0;
            if (!float.TryParse(this.comboBox2.Text, out size))
            {
                MessageBox.Show("変換エラー\nフォントサイズ");
                size = 10.5f;
            }
            utl.Fontsize = size;
            int num = 0;
            if (!int.TryParse(this.comboBox3.Text, out num))
            {
                MessageBox.Show("変換エラー\nパース間隔");
                num = 500;
            }
            utl.UpdateInfomsec = num;
            int displaynum = 0;
            if (!int.TryParse(this.comboBox4.Text, out displaynum))
            {
                MessageBox.Show("変換エラー\n補完最大表示数");
                displaynum = 6;
            }
            utl.DisplayAssistnum = displaynum;
            int tabwidth = 0;
            if (!int.TryParse(this.comboBox5.Text, out tabwidth))
            {
                MessageBox.Show("変換エラー\nタブ幅");
                tabwidth = 3;
            }
            utl.TabWidth = tabwidth;
            int backupnum = 0;
            if (!int.TryParse(this.comboBox7.Text, out backupnum))
            {
                MessageBox.Show("変換エラー\nバックアップの数");
                backupnum = 1;
            }
            utl.BackUpNum = backupnum;
            switch (this.comboBox6.SelectedIndex)
            {
                case 0:
                    utl.Antialias = Sgry.Azuki.Antialias.Default;
                    break;
                case 1:
                    utl.Antialias = Sgry.Azuki.Antialias.None;
                    break;
                case 2:
                    utl.Antialias = Sgry.Azuki.Antialias.Gray;
                    break;
                case 3:
                    utl.Antialias = Sgry.Azuki.Antialias.Subpixel;
                    break;
                default:
                    break;
            }
            utl.DefaultNewLineString = this.textBox1.Text.Replace("\\n", "\n").Replace("\\r", "\r");
        }
        private void checkchanged()
        {
            if (!this.tabPage1.Text.StartsWith("*")) this.tabPage1.Text = "*" + this.tabPage1.Text;
        }
        private void checkchanged2()
        {
            if (!this.tabPage2.Text.StartsWith("*")) this.tabPage2.Text = "*" + this.tabPage2.Text;
        }
        public bool Changed
        {
            get
            {
                if (tabPage1.Text.StartsWith("*")) return true;
                if (tabPage2.Text.StartsWith("*")) return true;
                return false;
            }
        }

        private void checkBox7_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.AskWhenNewlySave = this.checkBox7.Checked;
            checkchanged2();
        }

        private void notExecuteProgramWhenErrorCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.NotExecuteProgramWhenError = this.notExecuteProgramWhenErrorCheckBox.Checked;
            checkchanged2();
        }
        private void notExecuteProgramWhenWarningCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.NotExecuteProgramWhenWarning = this.notExecuteProgramWhenWarningCheckBox.Checked;
            checkchanged2();
        }
        private void checkBox13_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.AutoFormatInScope = this.checkBox13.Checked;
            checkBox14.Enabled = utl.AutoFormatInScope;
            checkBox17.Enabled = utl.AutoFormatInScope;
            checkchanged2();
        }
        private void checkBox14_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.AdjustOpenEnclosure = this.checkBox14.Checked;
            checkchanged2();
        }
        private void checkBox17_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.AdjustCloseEnclosure = this.checkBox17.Checked;
            checkchanged2();
        }
        private void checkBox15_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.AskSaveTabs = this.checkBox15.Checked;
            checkBox16.Enabled = !checkBox15.Checked;
            checkchanged2();
        }

        private void checkBox16_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.SaveTabs = this.checkBox16.Checked;
            checkchanged2();
        }

        private void checkBox18_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.DetectNewLineString = this.checkBox18.Checked;
            checkBox19.Enabled = this.checkBox18.Checked;
            checkchanged2();
        }

        private void checkBox19_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            utl.TellMixedNewLine = this.checkBox19.Checked;
            checkchanged2();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            checkchanged2();
            Updateutil();
        }
    }
}
