﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class AssistInformation
    {
        public AssistInformation()
        {
            Image = NotepadNeue.Properties.Resources.error;
            DefineIndex = -1;
        }
        public Image Image
        {
            get;
            set;
        }
        public virtual string Text
        {
            get;
            set;
        }
        public virtual string HintText
        {
            get;
            set;
        }
        public virtual string Summary
        {
            get;
            set;
        }
        public virtual int DefineIndex
        {
            get;
            set;
        }
        public override string ToString()
        {
            return Text;
        }
        public virtual bool Equals(AssistInformation info)
        {
            if (info == null) return false;
            if (Image == info.Image && Text == info.Text && HintText == info.HintText)
            {
                return true;
            }
            return false;
        }
    }

    public class AssistInfomationComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<AssistInformation>
    {
        public int Compare(AssistInformation x, AssistInformation y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;


            StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
            return sc.Compare(x.ToString(), y.ToString());

        }
        public int Compare(object x, object y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;

            //String型以外の比較はエラー
            if (!(x is AssistInformation) || !(y is AssistInformation))
                throw new ArgumentException();
            AssistInfomationComparer aic = new AssistInfomationComparer();

            return aic.Compare((AssistInformation)x, (AssistInformation)y);
        }
    }
}
