﻿using System;
using System.Xml;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    class XMLBufferReader
    {
        string path = String.Empty;
        bool ignorefirstnamespace = false;
        public NameSpaceInfo namespacemanager
        {
            get;
            set;
        }
        public XMLBufferReader(string path)
        {
            this.path = path;
        }
        public void Parse()
        {
            XmlReaderSettings settings = new XmlReaderSettings();
            settings.ConformanceLevel = ConformanceLevel.Fragment;
            settings.IgnoreWhitespace = true;
            settings.IgnoreComments = true;
            XmlReader reader = XmlReader.Create(path, settings);
            ParseNameSpace(reader, namespacemanager);
            reader.Close();
            namespacemanager.CompleteRead = true;
        }
        private void ParseNameSpace(XmlReader reader, NameSpaceInfo nsm)
        {
            while (reader.Read())
            {
                if (reader.IsStartElement())
                {
                    if (reader.Name == "namespace")
                    {
                        if (!ignorefirstnamespace)
                        {
                            NameSpaceInfo tempnsm = new NameSpaceInfo();
                            string name = reader.GetAttribute("name");
                            if (name != null)
                            {
                                nsm.AddNameSpace(tempnsm, name);
                                tempnsm.Name = name;
                                XmlReader tempreader = reader.ReadSubtree();
                                ignorefirstnamespace = true;
                                ParseNameSpace(tempreader, tempnsm);
                                ignorefirstnamespace = false;
                            }
                        }
                        else
                        {
                            ignorefirstnamespace = false;
                        }
                    }
                    else if (reader.Name == "object")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            //string type = reader.GetAttribute("type");
                            //string inherited = reader.GetAttribute("inherited");
                            ObjectInfo objectinfo = new ObjectInfo();
                            objectinfo.Name = name;
                            nsm.AddObject(objectinfo, name);
                            XmlReader tempreader = reader.ReadSubtree();
                            ParseObjectAndSummary(tempreader, objectinfo);
                        }
                    }
                    else if (reader.Name == "function")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string type = reader.GetAttribute("type");
                            type = type == null ? "" : type;
                            string content = reader.GetAttribute("content");
                            content = content == null ? "" : content;
                            FunctionInfo functioninfo = new FunctionInfo();
                            functioninfo.Name = name;
                            functioninfo.Type = type;
                            functioninfo.AddContent(content);
                            nsm.AddFunction(functioninfo, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummaryAndArgument(summaryreader, functioninfo);
                        }
                    }
                    else if (reader.Name == "variable")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string type = reader.GetAttribute("type");
                            type = type == null ? "" : type;
                            VariableInfo variableinfo = new VariableInfo();
                            variableinfo.Name = name;
                            variableinfo.Type = type;
                            nsm.AddVariable(variableinfo, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummary(summaryreader, variableinfo);
                        }
                    }
                    else if (reader.Name == "definevalue")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string value = reader.GetAttribute("value");
                            value = value == null ? "" : value;
                            DefineValueInfo definevalueinfo = new DefineValueInfo();
                            definevalueinfo.Name = name;
                            definevalueinfo.Value = value;
                            nsm.AddDefineValueInfo(definevalueinfo, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummary(summaryreader, definevalueinfo);
                        }
                    }
                }
            }
            reader.Close();
        }
        private void ParseObjectAndSummary(XmlReader reader, ObjectInfo objectinfo)
        {
            while (reader.Read())
            {
                if (reader.IsStartElement())
                {
                    if (reader.Name == "method")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string type = reader.GetAttribute("type");
                            type = type == null ? "" : type;
                            string content = reader.GetAttribute("content");
                            content = content == null ? "" : content;
                            FunctionInfo method = new FunctionInfo();
                            method.Name = name;
                            method.Type = type;
                            method.AddContent(content);
                            objectinfo.AddMethod(method, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummaryAndArgument(summaryreader, method);
                        }
                    }
                    else if (reader.Name == "variable")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string type = reader.GetAttribute("type");
                            type = type == null ? "" : type;
                            VariableInfo variableinfo = new VariableInfo();
                            variableinfo.Name = name;
                            variableinfo.Type = type;
                            objectinfo.AddVariable(variableinfo, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummary(summaryreader, variableinfo);
                        }
                    }
                    else if (reader.Name == "definevalue")
                    {
                        string name = reader.GetAttribute("name");
                        if (name != null)
                        {
                            string value = reader.GetAttribute("value");
                            value = value == null ? "" : value;
                            DefineValueInfo definevalueinfo = new DefineValueInfo();
                            definevalueinfo.Name = name;
                            definevalueinfo.Value = value;
                            objectinfo.AddDefineValueInfo(definevalueinfo, name);
                            XmlReader summaryreader = reader.ReadSubtree();
                            ParseSummary(summaryreader, definevalueinfo);
                        }
                    }
                    else if (reader.Name == "summary")
                    {
                        string summary = reader.GetAttribute("text");
                        if (summary != null)
                        {
                            objectinfo.Summary = summary;
                        }
                    }
                }
            }
            reader.Close();
        }
        private void ParseSummary(XmlReader reader, AssistInformation ai)
        {
            while (reader.Read())
            {
                if (reader.IsStartElement())
                {
                    if (reader.Name == "summary")
                    {
                        string summary = reader.GetAttribute("text");
                        if (summary != null)
                        {
                            ai.Summary = summary;
                        }
                    }
                }
            }
            reader.Close();
        }
        private void ParseSummaryAndArgument(XmlReader reader, FunctionInfo fi)
        {
            List<String> pool = new List<string>();
            while (reader.Read())
            {
                if (reader.IsStartElement())
                {
                    if (reader.Name == "summary")
                    {
                        string summary = reader.GetAttribute("text");
                        if (summary != null)
                        {
                            fi.Summary = summary;
                        }
                    }
                    else if (reader.Name == "argument")
                    {
                        string argument = reader.GetAttribute("text");
                        if (argument != null)
                        {
                            pool.Add(argument);
                        }
                    }
                }
            }
            fi.AddArgument(pool.ToArray());
            reader.Close();
        }
    }
}
