﻿using System;
using System.Windows.Forms;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using SlimDX;
using SlimDX.Direct3D9;
using System.Runtime.InteropServices;


namespace testgame
{
    class Game : IDisposable
    {

        [DllImport("winmm.dll")]
        static extern long timeGetTime();
        [DllImport("winmm.dll")]
        static extern void timeBeginPeriod(int x);
        [DllImport("winmm.dll")]
        static extern void timeEndPeriod(int x);

        bool disposed = false;
        protected Utility util;
        public NotepadNeue.MovieWindow Window;
        public NotepadNeue.ExAzukiControl exac;
        public IntPtr Handle;
        public IntPtr WindowHandle;
        public Device device;
        private Direct3D d3d;
        public PresentParameters presentParam;
        long lasttime;
        int count = 0;
        public int width;
        public int height;
        bool recreateflag = false;
        public Game()
        {
        }
        public Direct3D D3D
        {
            get
            {
                return d3d;
            }
        }
        public void Run()
        {

            if (!DXInitialize())
            {
                return;
            }
            Initialize();
            LoadContent();
            timeBeginPeriod(1);
            double nextframe = (double)timeGetTime();
            float wait = 16.7f;
            while (this.Window.Created)
            {
                if (device == null) break;
                if ((double)timeGetTime() >= nextframe)
                {
                    Update();


                    if ((double)timeGetTime() < nextframe + wait)
                    {
                        try
                        {
                            try
                            {
                                //更新
                                Draw();
                                device.Present();
                            }
                            catch (Direct3D9Exception)
                            {
                                resetDevice();
                            }
                        }
                        catch
                        {

                        }
                        if (recreateflag)
                        {
                            presentParam.BackBufferHeight = height;
                            presentParam.BackBufferWidth = width;
                            recreateflag = false;
                            device.Dispose();
                            device = null;
                            if (createdevice())
                            {
                                LoadContent();
                            }
                            else
                            {
                                recreateflag = true;
                            }
                        }
                        long now = timeGetTime();
                        if (now - lasttime >= 1000)
                        {
                            Console.WriteLine(count);
                            count = 0;
                            lasttime = now;
                        }
                        count++;
                    }
                    nextframe += wait;
                }
                int sleep = (int)(nextframe - timeGetTime());
                if (sleep > 0)
                {
                    System.Threading.Thread.Sleep(sleep);
                }
                Application.DoEvents();
            }
        }

        private void resetDevice()
        {
            if (device == null) return;
            Result r = device.TestCooperativeLevel();
            if (r.Code != ResultCode.Success.Code)
            {
                if (r.Code == ResultCode.DeviceLost.Code)
                {
                    //ちょっと待つ
                    System.Threading.Thread.Sleep(10);

                }
                else if (r.Code == ResultCode.DeviceNotReset.Code)
                {
                    OnLostDevice();
                    try
                    {
                        device.Reset(presentParam);
                    }
                    catch 
                    {

                    }
                    OnResetDevice();
                }
            }
        }
        public virtual void OnLostDevice()
        {

        }
        public virtual void OnResetDevice()
        {

        }
        private void changeMode()
        {
            if (presentParam.Windowed)
            {




                presentParam.Windowed = false;
                presentParam.BackBufferHeight = this.Window.Height;
                presentParam.BackBufferWidth = this.Window.Width;

                presentParam.BackBufferFormat = Format.X8R8G8B8;
                presentParam.FullScreenRefreshRateInHertz = 60;
                device.Reset(presentParam);
            }
            else
            {
                presentParam = new PresentParameters();
                presentParam.Windowed = true;
                presentParam.SwapEffect = SwapEffect.Discard;

                device.Reset(presentParam);

            }
        }
        public bool DXInitialize()
        {



            try
            {
                MultisampleType mt = MultisampleType.None;
                /*if (File.Exists("PPD.ini"))
                {
                    using (StreamReader sr = new StreamReader("PPD.ini"))
                    {
                        string s = sr.ReadToEnd();
                        sr.Close();
                        settingloader sl = new settingloader();
                        string num = sl.readdata(s, "multisample");
                        int test = 0;
                        if (int.TryParse(num, out test))
                        {
                            if (test >= 0 && test <= 16)
                            {
                                mt = (MultisampleType)test;
                            }
                        }
                        if (sl.readdata(s, "d3d") == "1")
                        {
                            d3dtype = 1;
                        }
                        if (sl.readdata(s, "lightmode") == "1")
                        {
                            lightmode = 1;
                        }
                        if (sl.readdata(s, "fullscreen") == "1")
                        {
                            fullscreen = 1;
                        }
                    }
                }
                if (d3dtype == 1)
                {
                    d3d = new Direct3DEx();
                }
                else
                {
                    d3d = new Direct3D();
                }
                util = new Utility();
                util.d3d = d3d;
                util.window = this.Window.Handle;
                if (lightmode == 1)
                {
                    util.lightmode = 1;
                }
                else
                {
                    util.lightmode = 0;
                }
                this.Window.util = util;*/
                d3d = new Direct3D();
                util = new Utility();
                util.d3d = d3d;
                util.disptag = Handle;
                util.Window = WindowHandle;
                Window.util = util;
                //util.window = this.Window.Handle;
                //util.window = this.exac.Handle;
                int count = d3d.GetAdapterModeCount(d3d.Adapters.DefaultAdapter.Adapter, Format.X8R8G8B8);
                //プレゼンテーションパラメータを作成
                presentParam = new PresentParameters();
                //ウィンドウモード
                presentParam.Windowed = true;
                presentParam.BackBufferHeight = height;
                presentParam.BackBufferWidth = width;
                //スワップエフェクトを設定。
                presentParam.BackBufferFormat = Format.Unknown;
                presentParam.BackBufferCount = 1;
                presentParam.SwapEffect = SwapEffect.Discard;
                presentParam.PresentationInterval = PresentInterval.Default;



                presentParam.Multisample = mt;

                /*presentParam.EnableAutoDepthStencil = true;
                presentParam.AutoDepthStencilFormat = Format.Unknown;
                presentParam.PresentFlags = PresentFlags.DiscardDepthStencil;*/


                //デバイスを作成
                try
                {

                    device = new Device(d3d, 0, DeviceType.Hardware, util.disptag, CreateFlags.HardwareVertexProcessing | CreateFlags.Multithreaded, presentParam);

                }
                catch (Direct3D9Exception)
                {
                    try
                    {

                        device = new Device(d3d, 0, DeviceType.Hardware, util.disptag
                            , CreateFlags.SoftwareVertexProcessing | CreateFlags.Multithreaded, presentParam);
                    }
                    catch (Direct3D9Exception)
                    {
                        try
                        {

                            device = new Device(d3d, 0, DeviceType.Reference, util.disptag
                                , CreateFlags.SoftwareVertexProcessing | CreateFlags.Multithreaded,
                                presentParam);
                        }
                        catch (Direct3D9Exception ex)
                        {

                            MessageBox.Show("初期化できませんでした\n" + ex.Message);
                        }
                    }
                }

                util.device = device;
                //初期化成功
                return true;
            }
            catch
            {
                //初期化失敗
                return false;
            }

        }
        private bool createdevice()
        {
            try
            {

                device = new Device(d3d, 0, DeviceType.Hardware, util.disptag, CreateFlags.HardwareVertexProcessing | CreateFlags.Multithreaded, presentParam);

            }
            catch (Direct3D9Exception)
            {
                try
                {

                    device = new Device(d3d, 0, DeviceType.Hardware, util.disptag
                        , CreateFlags.SoftwareVertexProcessing | CreateFlags.Multithreaded, presentParam);
                }
                catch (Direct3D9Exception)
                {
                    try
                    {

                        device = new Device(d3d, 0, DeviceType.Reference, util.disptag
                            , CreateFlags.SoftwareVertexProcessing | CreateFlags.Multithreaded,
                            presentParam);
                    }
                    catch (Direct3D9Exception ex)
                    {
                        MessageBox.Show("初期化できませんでした\n" + ex.Message);
                        return false;
                    }
                }
            }

            util.device = device;
            //初期化成功
            return true;
        }
        public virtual void ReCreate()
        {
            recreateflag = true;
        }
        protected virtual void Initialize()
        {

        }

        protected virtual void LoadContent()
        {

        }

        protected virtual void UnloadContent()
        {


        }


        protected virtual void Update()
        {


        }

        protected virtual void Draw()
        {


        }
        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    if (device != null)
                    {
                        device.Dispose();
                        device = null;
                    }
                }
            }
            disposed = true;
        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
    }
}
