﻿<?xml version="1.0" encoding="utf-8"?>
<root>
    <object name="mpz_t">
        <summary text="多倍長整数型です。"/>
    </object>
    <object name="mpq_t">
        <summary text="多倍長有理数型です。"/>
    </object>
    <object name="mp_bitcnt_t">
        <summary text="個数を表します。"/>
    </object>
    <function name="mpz_init" type="void" content="void mpz_init(mpz_t x)">
        <summary text="多倍長整数型を初期化し、0を値に設定します。"/>
        <argument text="初期化する多倍長整数型の変数"/>
    </function>
    <function name="mpz_inits" type="void" content="void mpz_inits(mpz_t x, ...)">
        <summary text="複数の多倍長整数型を初期化し、0を値に設定します。"/>
        <argument text="初期化する多倍長整数型の変数"/>
        <argument text="複数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_init2" type="void" content="void mpz_init2(mpz_t x, mpz_bitcnt_t n)">
        <summary text="多倍長整数型を特定のスペースで初期化し、0を値に設定します。"/>
        <argument text="初期化する多倍長整数型の変数"/>
        <argument text="初期化するスペース"/>
    </function>
    <function name="mpz_clear" type="void" content="void mpz_clear(mpz_t x)">
        <summary text="多倍長整数型を解放します"/>
        <argument text="解放する多倍長整数型の変数"/>
    </function>
    <function name="mpz_clears" type="void" content="void mpz_clears(mpz_t x, ...)">
        <summary text="複数の多倍長整数型を解放します"/>
        <argument text="解放する多倍長整数型の変数"/>
        <argument text="複数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_realloc2" type="void" content="void mpz_realloc2(mpz_t x, mpz_bitcnt_t n)">
        <summary text="多倍長整数型のスペースを変更します。範囲内に収まる場合は値は保存されますが、そうでない場合は0が設定されます。"/>
        <argument text="スペースを変更する多倍長整数型の変数"/>
        <argument text="変更後のスペース"/>
    </function>
    <function name="mpz_set" type="void" content="void mpz_set(mpz_t rop, mpz_t op)">
        <summary text="値を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の多倍長整数型の変数"/>
    </function>
    <function name="mpz_set_ui" type="void" content="void mpz_set_ui(mpz_t rop, unsigned long int op)">
        <summary text="多倍長整数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の整数型の変数"/>
    </function>
    <function name="mpz_set_ui" type="void" content="void mpz_set_ui(mpz_t rop, unsigned long int op)">
        <summary text="符号なし整数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の符号なし整数型の変数"/>
    </function>
    <function name="mpz_set_si" type="void" content="void mpz_set_si(mpz_t rop, signed long int op)">
        <summary text="符号つき整数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の符号つき整数型の変数"/>
    </function>
    <function name="mpz_set_d" type="void" content="void mpz_set_d(mpz_t rop, double op)">
        <summary text="倍精度浮動小数点数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の符号なし倍精度浮動小数点数型の変数"/>
    </function>
    <function name="mpz_set_q" type="void" content="void mpz_set_q(mpz_t rop, mpq_t op)">
        <summary text="多倍長有理数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の符号なし多倍長有理数型の変数"/>
    </function>
    <function name="mpz_set_f" type="void" content="void mpz_set_f(mpz_t rop, mpf_t op)">
        <summary text="多倍長小数型の値を多倍長整数型の変数に代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の符号なし多倍長小数型の変数"/>
    </function>
    <function name="mpz_set_str" type="int" content="int mpz_set_f(mpz_t rop, char *str, int base)">
        <summary text="文字列で表された数値を指定された基数基づき多倍長整数型の変数に代入します。成功した場合は0、そうでない場合は-1を返します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="代入元の文字列表記の数値。ホワイトスペースは許されていますが、単に無視されます。"/>
        <argument text="基数,2から62の間か0ならば最初の文字列によって変わります。(0x:16進数, 0b(B):2進数, 0:8進数, それ以外:10進数)"/>
    </function>
    <function name="mpz_swap" type="void" content="void mpz_swap(mpz_t rop, mpz_t op)">
        <summary text="変数の中身を交換します"/>
        <argument text="一つ目の交換する多倍長整数型の変数"/>
        <argument text="二つ目の交換する多倍長整数型の変数"/>
    </function>
    <function name="mpz_init_set" type="void" content="void mpz_init_set(mpz_t rop, mpz_t op)">
        <summary text="変数を初期化し、その後に多倍長整数値の代入を行います。"/>
        <argument text="初期化され、代入される先の多倍長整数型の変数"/>
        <argument text="代入元の多倍長整数型の変数"/>
    </function>
    <function name="mpz_init_set_ui" type="void" content="void mpz_init_set_ui(mpz_t rop, unsigned long int op)">
        <summary text="変数を初期化し、その後に符号なし整数数値の代入を行います。"/>
        <argument text="初期化され、代入される先の多倍長整数型の変数"/>
        <argument text="代入元の符号なし整数型の変数"/>
    </function>
    <function name="mpz_init_set_si" type="void" content="void mpz_init_set_si(mpz_t rop, signed long int op)">
        <summary text="変数を初期化し、その後に符号つき整数数値の代入を行います。"/>
        <argument text="初期化され、代入される先の多倍長整数型の変数"/>
        <argument text="代入元の符号つき整数型"/>
    </function>
    <function name="mpz_init_set_d" type="void" content="void mpz_init_set_d(mpz_t rop, double op)">
        <summary text="変数を初期化し、その後に倍精度浮動小数点数数値の代入を行います。"/>
        <argument text="初期化され、代入される先の多倍長整数型の変数"/>
        <argument text="代入元の倍精度浮動小数点数型"/>
    </function>
    <function name="mpz_set_str" type="int" content="int mpz_set_f(mpz_t rop, char *str, int base)">
        <summary text="変数を初期化し、その後に文字列で表された数値を指定された基数基づき代入を行います。成功した場合は0、そうでない場合は-1を返します。-1を返した場合でもmpz_clearを呼ぶ必要があります。"/>
        <argument text="初期化され、代入される先の多倍長整数型の変数"/>
        <argument text="代入元の文字列表記の数値。ホワイトスペースは許されていますが、単に無視されます。"/>
        <argument text="基数,2から62の間か0ならば最初の文字列によって変わります。(0x:16進数, 0b(B):2進数, 0:8進数, それ以外:10進数)"/>
    </function>
    <function name="mpz_get_ui" type="unsigned long int" content="unsigned long int mpz_get_ui(mpz_t rop)">
        <summary text="多倍長整数型の変数の符号なし整数を取得します。符号なし整数に収まらない場合は、収まるだけの最下位ビットからの数値を返します。"/>
        <argument text="対象の多倍長整数型の変数"/>
    </function>
    <function name="mpz_get_si" type="signed long int" content="signed long int mpz_get_si(mpz_t rop)">
        <summary text="多倍長整数型の変数の符号つき整数を取得します。符号つき整数に収まらない場合は、収まるだけの最下位ビットからの数値かつ符号が一致する数値を返します。収まるかどうかを調べるにはmpz_fits_slong_pを使います。"/>
        <argument text="対象の多倍長整数型の変数"/>
    </function>
    <function name="mpz_get_d" type="double" content="double mpz_get_d(mpz_t rop)">
        <summary text="多倍長整数型の変数の倍精度浮動小数点数を取得します。必要に応じて切り捨てが行われます。収まらない場合は、環境依存ですがInfinityの数値を返します。"/>
        <argument text="対象の多倍長整数型の変数"/>
    </function>
    <function name="mpz_get_d_2exp" type="double" content="double mpz_get_d_2exp(signed long int *exp, mpz_t rop)">
        <summary text="多倍長整数型の変数を倍精度浮動小数点数とべき乗に分けてを取得します。必要に応じて切り捨てが行われます。返り値は0.5以上1未満です。値が0の場合の返り値は0.0で、べきは0になります。"/>
        <argument text="べき乗の数値。元の数値(丸められた)は (返り値)*2^べき乗 になります。"/>
        <argument text="対象の多倍長整数型の変数"/>
    </function>
    <function name="mpz_get_str" type="char *" content="char * mpz_get_str(char *str, int base, mpz_t op)">
        <summary text="多倍長整数型の変数を指定された基数に基づき文字列表記を取得します。引数の文字列がNULLの場合に自動的に確保された文字列、指定された文字列の場合はその文字列を返します"/>
        <argument text="使用される文字列。NULLの場合は自動的に確保された文字列が使用されます。文字列は mpz_sineinbase(op, base)+2 以上である必要があります。(符号と終端文字列)"/>
        <argument text="文字列表記する際の基数。2から62か-2から-36である必要があります。-2から-36の場合、大文字にして返します。"/>
        <argument text="対象の多倍長整数型の変数"/>
    </function>
    <function name="mpz_add" type="void" content="void mpz_add(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="ropに op1 + op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の加算引数"/>
        <argument text="二つ目の加算引数"/>
    </function>
    <function name="mpz_add_ui" type="void" content="void mpz_add_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="ropに op1 + op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の加算引数"/>
        <argument text="二つ目の加算引数"/>
    </function>
    <function name="mpz_sub" type="void" content="void mpz_sub(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="ropに op1 - op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の減算引数"/>
        <argument text="二つ目の減算引数"/>
    </function>
    <function name="mpz_sub_ui" type="void" content="void mpz_sub_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="ropに op1 - op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の減算引数"/>
        <argument text="二つ目の減算引数"/>
    </function>
    <function name="mpz_ui_sub" type="void" content="void mpz_ui_sub(mpz_t rop, unsigned long int op1, mpz_t op2)">
        <summary text="ropに op1 - op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の減算引数"/>
        <argument text="二つ目の減算引数"/>
    </function>
    <function name="mpz_mul" type="void" content="void mpz_mul(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="ropに op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_mul_si" type="void" content="void mpz_mul_si(mpz_t rop, mpz_t op1, long int op2)">
        <summary text="ropに op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_mul_ui" type="void" content="void mpz_mul_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="ropに op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_addmul" type="void" content="void mpz_addmul(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="ropに rop + op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_addmul_ui" type="void" content="void mpz_addmul_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="ropに rop + op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_submul" type="void" content="void mpz_submul(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="ropに rop - op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_submul_ui" type="void" content="void mpz_submul_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="ropに rop - op1 * op2 を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpz_mul_2exp" type="void" content="void mpz_2exp(mpz_t rop, mpz_t op1, mp_bitcnt_t op2)">
        <summary text="ropに op1 * 2^(op2) を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の引数"/>
    </function>
    <function name="mpz_neg" type="void" content="void mpz_neg(mpz_t rop, mpz_t op)">
        <summary text="ropに -op を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の引数"/>
    </function>
    <function name="mpz_abs" type="void" content="void mpz_abs(mpz_t rop, mpz_t op)">
        <summary text="ropに |op| を代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の引数"/>
    </function>
    <function name="mpz_cdiv_q" type="void" content="void mpz_cdiv_q(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の商を計算します。天井関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_cdiv_r" type="void" content="void mpz_cdiv_r(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の余りを計算します。天井関数の丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_cdiv_qr" type="void" content="void mpz_cdiv_qr(mpz_t q, mpz_t r, mpz_t n, mpz_t d)">
        <summary text="n / d の商と余りを計算します。天井関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_cdiv_q_ui" type="unsigned long int" content="unsigned long int mpz_cdiv_q_ui(mpz_t q, mpz_t n, unsigned long int d)">
        <summary text="n / d の商を計算します。天井関数の丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_cdiv_r_ui" type="unsigned long int" content="unsigned long int mpz_cdiv_r_ui(mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。天井関数の丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_cdiv_qr_ui" type="unsigned long int" content="unsigned long int mpz_cdiv_qr_ui(mpz_t q, mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の商と余りを計算します。天井関数の丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_cdiv_ui" type="unsigned long int" content="unsigned long int mpz_cdiv_qr_ui(mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。天井関数の丸めが行われます。返り値は余りの絶対値になります。"/>>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_cdiv_q_2exp" type="void" content="void mpz_cdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の商を計算します。天井関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_cdiv_r_2exp" type="void" content="void mpz_cdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の余りを計算します。天井関数の丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_fdiv_q" type="void" content="void mpz_fdiv_q(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の商を計算します。床関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_fdiv_r" type="void" content="void mpz_fdiv_r(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の余りを計算します。床関数の丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_fdiv_qr" type="void" content="void mpz_fdiv_qr(mpz_t q, mpz_t r, mpz_t n, mpz_t d)">
        <summary text="n / d の商と余りを計算します。床関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_fdiv_q_ui" type="unsigned long int" content="unsigned long int mpz_fdiv_q_ui(mpz_t q, mpz_t n, unsigned long int d)">
        <summary text="n / d の商を計算します。床関数の丸めが行われます。返り値は余りになります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_fdiv_r_ui" type="unsigned long int" content="unsigned long int mpz_fdiv_r_ui(mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。床関数の丸めが行われます。返り値は余りになります。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_fdiv_qr_ui" type="unsigned long int" content="unsigned long int mpz_fdiv_qr_ui(mpz_t q, mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の商と余りを計算します。床関数の丸めが行われます。返り値は余りになります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_fdiv_ui" type="unsigned long int" content="unsigned long int mpz_fdiv_qr_ui(mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。床関数の丸めが行われます。返り値は余りになります。"/>>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_fdiv_q_2exp" type="void" content="void mpz_fdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の商を計算します。床関数の丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_fdiv_r_2exp" type="void" content="void mpz_fdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の余りを計算します。床関数の丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_tdiv_q" type="void" content="void mpz_tdiv_q(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の商を計算します。0方向へのの丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_tdiv_r" type="void" content="void mpz_tdiv_r(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="n / d の余りを計算します。0方向へのの丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_tdiv_qr" type="void" content="void mpz_tdiv_qr(mpz_t q, mpz_t r, mpz_t n, mpz_t d)">
        <summary text="n / d の商と余りを計算します。0方向へのの丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_tdiv_q_ui" type="unsigned long int" content="unsigned long int mpz_tdiv_q_ui(mpz_t q, mpz_t n, unsigned long int d)">
        <summary text="n / d の商を計算します。0方向へのの丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_tdiv_r_ui" type="unsigned long int" content="unsigned long int mpz_tdiv_r_ui(mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。0方向へのの丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_tdiv_qr_ui" type="unsigned long int" content="unsigned long int mpz_tdiv_qr_ui(mpz_t q, mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="n / d の商と余りを計算します。0方向へのの丸めが行われます。返り値は余りの絶対値になります。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_tdiv_ui" type="unsigned long int" content="unsigned long int mpz_tdiv_qr_ui(mpz_t n, unsigned long int d)">
        <summary text="n / d の余りを計算します。0方向へのの丸めが行われます。返り値は余りの絶対値になります。"/>>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_tdiv_q_2exp" type="void" content="void mpz_tdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の商を計算します。0方向へのの丸めが行われます。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_tdiv_r_2exp" type="void" content="void mpz_tdiv_q_2exp(mpz_t q, mpz_t n, mp_bitcnt_t b)">
        <summary text="n / 2^b の余りを計算します。0方向へのの丸めが行われます。"/>
        <argument text="余りの代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_mod" type="void" content="void mpz_mod(mpz_t r, mpz_t n, mpz_t d)">
        <summary text="r に n % dを代入します。割る数(d)の符号は無視され、余りは必ず非負になります。"/>
        <argument text="剰余の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_mod_ui" type="unsigned long int" content="unsigned long int mpz_mod_ui(mpz_t r, mpz_t n, unsigned long int d)">
        <summary text="r に n % dを代入します。割る数(d)の符号は無視され、余りは必ず非負になります。mpz_fdiv_r_uiと同じです。"/>
        <argument text="剰余の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_divexact" type="void" content="void mpz_divexact(mpz_t q, mpz_t n, mpz_t d)">
        <summary text="q に n / dの商を代入します。ただし、結果が正しいのはnがdで割り切れる場合のみです。他の割り算に比べて高速なので割り切れることが分かっている場合は使用してください。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_divexact_ui" type="void" content="void mpz_divexact_ui(mpz_t q, mpz_t n, unsigned long int d)">
        <summary text="q に n / dの商を代入します。ただし、結果が正しいのはnがdで割り切れる場合のみです。他の割り算に比べて高速なので割り切れることが分かっている場合は使用してください。"/>
        <argument text="商の代入先になる多倍長整数型の変数"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_divisible_p" type="int" content="int mpz_divisible_p(mpz_t n, mpz_t d)">
        <summary text="nがdで割り切れるかどうかを調べます。割り切れる場合は0以外の値を返します。n=q*dを満たすか調べるので、dが0でも問題ありません。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_divisible_ui_p" type="int" content="int mpz_divisible_ui_p(mpz_t n, unsigned long int d)">
        <summary text="nがdで割り切れるかどうかを調べます。割り切れる場合は0以外の値を返します。n=q*dを満たすか調べるので、dが0でも問題ありません。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数の符号なし整数型の変数"/>
    </function>
    <function name="mpz_divisible_2exp_p" type="int" content="int mpz_divisible_2exp_p(mpz_t n, mp_bitcnt_t b)">
        <summary text="nが2^bで割り切れるかどうかを調べます。割り切れる場合は0以外の値を返します。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="割る数のべき"/>
    </function>
    <function name="mpz_congruent_p" type="int" content="int mpz_congruent_p(mpz_t n, mpt_t c, mpz_t d)">
        <summary text="nをdで割ったときの余りがcがどうかを調べます。その場合は0以外の値を返します。n=c+q*dを満たすか調べるので、dが0でも問題ありません。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="余りかどうか調べる多倍長整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_congruent_ui_p" type="int" content="int mpz_congruent_ui_p(mpz_t n, unsigned long int c, mpz_t d)">
        <summary text="nをdで割ったときの余りがcがどうかを調べます。その場合は0以外の値を返します。n=c+q*dを満たすか調べるので、dが0でも問題ありません。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="余りかどうか調べる符号なし整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_congruent_2exp_p" type="int" content="int mpz_congruent_2exp_p(mpz_t n, mp_bitcnt b, mpz_t d)">
        <summary text="nを2^bで割ったときの余りがcがどうかを調べます。その場合は0以外の値を返します。"/>
        <argument text="割られる数の多倍長整数型の変数"/>
        <argument text="余りかどうか調べる符号なし整数型の変数"/>
        <argument text="割る数の多倍長整数型の変数"/>
    </function>
    <function name="mpz_powm" type="void" content="void mpz_powm(mpz_t rop, mpz_t base, mpz_t exp, mpz_t mod)">
        <summary text="rop に (base^exp) % modを代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="基数となる多倍長整数型の変数"/>
        <argument text="べきとなる多倍長整数型の変数"/>
        <argument text="法となる多倍長整数型の変数"/>
    </function>
    <function name="mpz_powm_ui" type="void" content="void mpz_powm_ui(mpz_t rop, mpz_t base, unsigned long int exp, mpz_t mod)">
        <summary text="rop に (base^exp) % modを代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="基数となる多倍長整数型の変数"/>
        <argument text="べきとなる符号なし整数型の変数"/>
        <argument text="法となる多倍長整数型の変数"/>
    </function>
    <function name="mpz_powm_sec" type="void" content="void mpz_powm_sec(mpz_t rop, mpz_t base, mpz_t exp, mpz_t mod)">
        <summary text="rop に (base^exp) % modを代入します。exp>0 かつ mod が奇数である必要があります。暗号化などに使用を意図しています"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="基数となる多倍長整数型の変数"/>
        <argument text="べきとなる多倍長整数型の変数"/>
        <argument text="法となる多倍長整数型の変数"/>
    </function>
    <function name="mpz_pow_ui" type="void" content="void mpz_pow_ui(mpz_t rop, mpz_t base, unsigned long int exp)">
        <summary text="rop に (base^exp) を代入します。0^0は1になります。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="基数となる多倍長整数型の変数"/>
        <argument text="べきとなる符号なし整数型の変数"/>
    </function>
    <function name="mpz_ui_pow_ui" type="void" content="void mpz_pow_ui(mpz_t rop, unsinged long int base, unsigned long int exp)">
        <summary text="rop に (base^exp) % modを代入します。0^0は1になります。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="基数となる符号なし整数型の変数"/>
        <argument text="べきとなる符号なし整数型の変数"/>
    </function>
    <function name="mpz_root" type="int" content="int mpz_root(mpz_t rop, mpz_t op, unsigned long int n)">
        <summary text="rop に opのn乗根の0方向に丸められた値を代入します。rop^n = opとなる場合のみ、返り値は0以外になります。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="ルートをとる多倍長整数型の変数"/>
        <argument text="何乗根を取るかの符号なし整数型の変数"/>
    </function>
    <function name="mpz_rootrem" type="void" content="void mpz_rootrem(mpz_t root, mpz_t rem, mpz_t u, unsigned long int n)">
        <summary text="root に uのn乗根の0方向に丸められた値を、remにそのときの余りの数を代入します。"/>
        <argument text="ルートの代入先の多倍長整数型の変数"/>
        <argument text="ルートの余りの代入先の多倍長整数型の変数"/>
        <argument text="ルートをとる多倍長整数型の変数"/>
        <argument text="何乗根を取るかの符号なし整数型の変数"/>
    </function>
    <function name="mpz_sqrt" type="void" content="void mpz_sqrt(mpz_t rop, mpz_t op)">
        <summary text="rop に opの2乗根の0方向に丸められた値を代入します。"/>
        <argument text="ルートの代入先の多倍長整数型の変数"/>
        <argument text="ルートをとる多倍長整数型の変数"/>
    </function>
    <function name="mpz_sqrtrem" type="void" content="void mpz_sqrtrem(mpz_t rop1, mpz_t rop2, mpz_t op)">
        <summary text="rop1 に opの2乗根の0方向に丸められた値を、rop2に余りを代入します。rop1とrop2が同じ変数の場合、結果は定義されません。"/>
        <argument text="ルートの代入先の多倍長整数型の変数"/>
        <argument text="ルートの余りの代入先の多倍長整数型の変数"/>
        <argument text="ルートをとる多倍長整数型の変数"/>
    </function>
    <function name="mpz_perfect_power_p" type="int" content="int mpz_perfect_power_p(mpz_t op)">
        <summary text="opがa^bで表されるような整数a,bが存在する場合、0以外を返します。0,1はこれに当てはまります。"/>
        <argument text="調べる多倍長整数型の整数"/>
    </function>
    <function name="mpz_perfect_square_p" type="int" content="int mpz_perfect_power_p(mpz_t op)">
        <summary text="opの２乗根が整数の場合、0以外を返します。0,1はこれに当てはまります。"/>
        <argument text="調べる多倍長整数型の整数"/>
    </function>
    <function name="mpz_probab_prime_p" type="int" content="int mpz_probab_prime_p(mpz_t n, int reps)">
        <summary text="nが素数かどうかを調べます。返り値が2なら素数、1なら素数かもしれない、0なら合成数です。"/>
        <argument text="素数かどうか調べる多倍長整数型の変数"/>
        <argument text="テストを行う回数。5~10が普通の値ですが、大きければ大きいほど素数判定が厳しくなります。"/>
    </function>
    <function name="mpz_nextprime" type="void" content="void mpz_nextprime(mpz_t rop, mpz_t op)">
        <summary text="ropにopよりも大きい次の素数を代入します。"/>
        <argument text="素数が代入される多倍長整数型の変数"/>
        <argument text="基準になる多倍長整数型の変数"/>
    </function>
    <function name="mpz_gcd" type="void" content="void mpz_gcd(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="rop に op1 と op2 の最大公約数を代入します。結果は必ず正になります。"/>
        <argument text="最大公約数の代入先となる多倍長整数型の変数"/>
        <argument text="最大公約数を調べる一つ目の引数"/>
        <argument text="最大公約数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_gcd_ui" type="unsigned long int" content="void mpz_gcd_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="rop に op1 と op2 の最大公約数を代入します。結果が符号なし整数に収まる場合、返り値として返します。そうでない場合は0を返し、結果はop1と等しくなります。"/>
        <argument text="最大公約数の代入先となる多倍長整数型の変数"/>
        <argument text="最大公約数を調べる一つ目の引数"/>
        <argument text="最大公約数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_gcdext" type="void" content="void mpz_gcdext(mpz_t g, mpz_t s, mpz_t t, mpz_t a, mpz_t b)">
        <summary text="g に a と b の最大公約数を代入します。また、s と t に a*s+b*t=g を満たす数を代入します。a,bの符号によらず、gは必ず正です。tがNULLなら計算されません。"/>
        <argument text="最大公約数の代入先となる多倍長整数型の変数"/>
        <argument text="最大公約数を調べる一つ目の引数"/>
        <argument text="最大公約数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_lcm" type="void" content="void mpz_lcm(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="rop に op1 と op2 の最小公倍数を代入します。結果は必ず正になります。op1,op2 のどちらかが0であれば、結果も0になります。"/>
        <argument text="最小公倍数の代入先となる多倍長整数型の変数"/>
        <argument text="最小公倍数を調べる一つ目の引数"/>
        <argument text="最小公倍数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_lcm_ui" type="void" content="void mpz_lcm_ui(mpz_t rop, mpz_t op1, unsigned long int op2)">
        <summary text="rop に op1 と op2 の最小公倍数を代入します。結果は必ず正になります。op1,op2 のどちらかが0であれば、結果も0になります。"/>
        <argument text="最小公倍数の代入先となる多倍長整数型の変数"/>
        <argument text="最小公倍数を調べる一つ目の引数"/>
        <argument text="最小公倍数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_invert" type="int" content="int mpz_invert(mpz_t rop, mpz_t op1, mpz_t op2)">
        <summary text="rop に op1 modulo op2 の逆数を代入します。逆数が存在する場合、返り値は0以外になります。"/>
        <argument text="逆数の代入先となる多倍長整数型の変数"/>
        <argument text="逆数を調べる一つ目の引数"/>
        <argument text="逆数を調べる二つ目の引数"/>
    </function>
    <function name="mpz_jacobi" type="int" content="int mpz_jacobi(mpz_t a, mpz_t b)">
        <summary text="Jacobi symbol(a/b)を計算します。bが奇数の時のみ定義されます"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_legendle" type="int" content="int mpz_legendle(mpz_t a, mpz_t p)">
        <summary text="Legendle symbol(a/b)を計算します。pが正で奇数の素数の時のみ定義されます"/>
        <argument text="Legendle symbolを調べる一つ目の引数"/>
        <argument text="Legendle symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_kronecker" type="int" content="int mpz_kronecker(mpz_t a, mpz_t b)">
        <summary text="Jacobi symbol(a/b)を a が奇数のときKronecker extension(a/2)=(2/a)、偶数のとき(a/2)=0として計算します。"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_kronecker_si" type="int" content="int mpz_kronecker(mpz_t a, long b)">
        <summary text="Jacobi symbol(a/b)を a が奇数のときKronecker extension(a/2)=(2/a)、偶数のとき(a/2)=0として計算します。"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_kronecker_ui" type="int" content="int mpz_kronecker(mpz_t a, unsigned long b)">
        <summary text="Jacobi symbol(a/b)を a が奇数のときKronecker extension(a/2)=(2/a)、偶数のとき(a/2)=0として計算します。"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_si_kronecker" type="int" content="int mpz_si_kronecker(long a, mpz_t b)">
        <summary text="Jacobi symbol(a/b)を a が奇数のときKronecker extension(a/2)=(2/a)、偶数のとき(a/2)=0として計算します。"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_ui_kronecker" type="int" content="int mpz_ui_kronecker(unsigned long a, mpz_t b)">
        <summary text="Jacobi symbol(a/b)を a が奇数のときKronecker extension(a/2)=(2/a)、偶数のとき(a/2)=0として計算します。"/>
        <argument text="Jacobi symbolを調べる一つ目の引数"/>
        <argument text="Jacobi symbolを調べる二つ目の引数"/>
    </function>
    <function name="mpz_remove" type="mp_bitcnt_t" content="mp_bitcnt_t mpz_remove(mpz_t rop, mpz_t op, mpz_t f)">
        <summary text="opからfの全てのoccurrenceを取り除いてropに代入します。返り値は何個のoccurrenceが取り除かれたかです。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="対象となる多倍長整数型の変数"/>
        <argument text="factor"/>
    </function>
    <function name="mpz_fac_ui" type="void" content="void mpz_fac_ui(mpz_t rop, unsigned long int op)">
        <summary text="rop にop!を代入します"/>
        <argument text="階乗の代入先の多倍長整数型の変数"/>
        <argument text="何階乗かの多倍長整数型の変数"/>
    </function>
    <function name="mpz_bin_ui" type="void" content="void mpz_bin_ui(mpz_t rop, mpz_t n, unsigned long int k)">
        <summary text="kに対するnのBinomial coefficientをropに代入します。負のnがサポートされています。bin(-n,k)=(-1)^k*bin(n+k-1,k)"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の引数"/>
        <argument text="二つ目の引数"/>
    </function>
    <function name="mpz_bin_uiui" type="void" content="void mpz_bin_ui(mpz_t rop, unsigned long int n, unsigned long int k)">
        <summary text="kに対するnのBinomial coefficientをropに代入します。負のnがサポートされています。bin(-n,k)=(-1)^k*bin(n+k-1,k)"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="一つ目の引数"/>
        <argument text="二つ目の引数"/>
    </function>
    <function name="mpz_fib_ui" type="void" content="void mpz_fib_ui(mpz_t fn, unsigned long int n)">
        <summary text="フィボナッチ数F[n]をfnに代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="何ステップ先か"/>
    </function>
    <function name="mpz_fib2_ui" type="void" content="void mpz_fib_ui(mpz_t fn, mpz_t fnsub1, unsigned long int n)">
        <summary text="フィボナッチ数F[n]をfnに、F[n-1]をfnsub1に代入します。"/>
        <argument text="F[n]の代入先の多倍長整数型の変数"/>
        <argument text="F[n-1]の代入先の多倍長整数型の変数"/>
        <argument text="何ステップ先か"/>
    </function>
    <function name="mpz_lucnum_ui" type="void" content="void mpz_lucnum_ui(mpz_t ln, unsigned long int n)">
        <summary text="Lucus数L[n]をlnに代入します。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="何ステップ先か"/>
    </function>
    <function name="mpz_lucnum2_ui" type="void" content="void mpz_lucnum_ui(mpz_t ln, mpz_t lnsub1, unsigned long int n)">
        <summary text="Lucus数L[n]をlnに、L[n-1]をlnsub1に代入します。"/>
        <argument text="L[n]の代入先の多倍長整数型の変数"/>
        <argument text="L[n-1]の代入先の多倍長整数型の変数"/>
        <argument text="何ステップ先か"/>
    </function>
    <function name="mpz_cmp" type="int" content="int mpz_cmp(mpz_t op1, mpz_t op2)">
        <summary text="op1 と op2を比較します。op1&gt;op2のとき正の数,op1=op2のとき0,op1&lt;op2のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の多倍長整数型の変数"/>
    </function>
    <function name="mpz_cmp_d" type="int" content="int mpz_cmp_d(mpz_t op1, double op2)">
        <summary text="op1 と op2を比較します。op1&gt;op2のとき正の数,op1=op2のとき0,op1&lt;op2のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の倍精度浮動小数点数型の変数"/>
    </function>
    <function name="mpz_cmp_si" type="int" content="int mpz_cmp_si(mpz_t op1, signed long int op2)">
        <summary text="(マクロです)op1 と op2を比較します。op1&gt;op2のとき正の数,op1=op2のとき0,op1&lt;op2のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の符号つき整数型の変数"/>
    </function>
    <function name="mpz_cmp_ui" type="int" content="int mpz_cmp_ui(mpz_t op1, unsigned long int op2)">
        <summary text="(マクロです)op1 と op2を比較します。op1&gt;op2のとき正の数,op1=op2のとき0,op1&lt;op2のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の符号なし整数型の変数"/>
    </function>
    <function name="mpz_cmpabs" type="int" content="int mpz_cmpabs(mpz_t op1, mpz_t op2)">
        <summary text="abs(op1)とabs(op2)を比較します。abs(op1)&gt;abs(op2)のとき正の数,abs(op1)=abs(op2)のとき0,abs(op1)&lt;abs(op2)のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の多倍長整数型の変数"/>
    </function>
    <function name="mpz_cmpabs_d" type="int" content="int mpz_cmpabs_d(mpz_t op1, double op2)">
        <summary text="abs(op1)とabs(op2)を比較します。abs(op1)&gt;abs(op2)のとき正の数,abs(op1)=abs(op2)のとき0,abs(op1)&lt;abs(op2)のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の倍精度浮動小数点数型の変数"/>
    </function>
    <function name="mpz_cmpabs_ui" type="int" content="int mpz_cmpabs_ui(mpz_t op1, unsigned long int op2)">
        <summary text="abs(op1)とabs(op2)を比較します。abs(op1)&gt;abs(op2)のとき正の数,abs(op1)=abs(op2)のとき0,abs(op1)&lt;abs(op2)のとき負の数を返します。"/>
        <argument text="比較する一つ目の多倍長整数型の変数"/>
        <argument text="比較する二つ目の符号なし整数型の変数"/>
    </function>
    <function name="mpz_sgn" type="int" content="int mpz_sgn(mpz_t op)">
        <summary text="(マクロです)opの符号を返します。。op1&gt;0のとき1,op1=0のとき0,op1&lt;0のとき-1を返します。"/>
        <argument text="符号を調べる多倍長整数型の変数"/>
    </function>
    <function name="mpz_out_str" type="size_t" content="size_t mpz_out_str(File *stream, int base, mpz_op)">
        <summary text="多倍長整数型を文字列として出力します。エラーが起きた場合返り値は0になります。"/>
        <argument text="出力先のファイルポインタ"/>
        <argument text="基数。2~62あるいは-2~-36"/>
        <argument text="出力する多倍長整数型の変数"/>
    </function>
    <function name="mpz_inp_str" type="size_t" content="size_t mpz_inp_str(mpz_t rop, File *stream, int base)">
        <summary text="多倍長整数型に文字列として入力します。エラーが起きた場合返り値は0になります。"/>
        <argument text="入力先の多倍長整数型の変数"/>
        <argument text="入力するファイルポインタ"/>
        <argument text="基数。2~62あるいは-2~-36"/>
    </function>
    <function name="mpz_out_raw" type="size_t" content="size_t mpz_out_raw(File *stream, mpz_op)">
        <summary text="多倍長整数型をバイナリとして出力します。エラーが起きた場合返り値は0になります。"/>
        <argument text="出力先のファイルポインタ"/>
        <argument text="出力する多倍長整数型の変数"/>
    </function>
    <function name="mpz_inp_raw" type="size_t" content="size_t mpz_inp_raw(mpz_t rop, File *stream)">
        <summary text="多倍長整数型に文字列として入力します。エラーが起きた場合返り値は0になります。"/>
        <argument text="入力先の多倍長整数型の変数"/>
        <argument text="入力するファイルポインタ"/>
    </function>
    <function name="mpq_canonicalize" type="void" content="void mpq_canonicalize(mpq_t op)">
        <summary text="分子、分母の共通の約数を省き正規化します。"/>
        <summary text="正規化する多倍長有理数が他の変数"/>
    </function>
    <function name="mpq_init" type="void" content="void mpq_init(mpq_t x)">
        <summary text="xに0/1を代入して初期化します。"/>
        <argument text="初期化する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_inits" type="void" content="void mpq_inits(mpq_t x, ...)">
        <summary text="xに0/1を代入して初期化します。"/>
        <argument text="初期化する多倍長有理数型の変数"/>
        <argument text="他の初期化する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_clear" type="void" content="void mpq_clear(mpq_t x)">
        <summary text="xを解放します。"/>
        <argument text="解放する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_clears" type="void" content="void mpq_clears(mpq_t x, ...)">
        <summary text="xを解放します。"/>
        <argument text="解放する多倍長有理数型の変数"/>
        <argument text="他の解放する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_set" type="void" content="void mpq_set(mpq_t rop, mpq_t op)">
        <summary text="rop に op を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="代入されるの多倍長有理数型の変数"/>
    </function>
    <function name="mpq_set_z" type="void" content="void mpq_set_z(mpq_t rop, mpza_t op)">
        <summary text="rop に op を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="代入されるの多倍長整数型の変数"/>
    </function>
    <function name="mpq_set_ui" type="void" content="void mpq_set_ui(mpq_t rop, unsigned long int op1, unsigned long int op2)">
        <summary text="rop に op1/op2 を代入します。共通の約数がある場合は、mpq_canonicalizeを使い正規化する必要があります。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="分子となる符号なし整数型の変数"/>
        <argument text="分母となる符号なし整数型の変数"/>
    </function>
    <function name="mpq_set_si" type="void" content="void mpq_set_si(mpq_t rop, long int op1, long int op2)">
        <summary text="rop に op1/op2 を代入します。共通の約数がある場合は、mpq_canonicalizeを使い正規化する必要があります。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="分子となる符号つき整数型の変数"/>
        <argument text="分母となる符号つき整数型の変数"/>
    </function>
    <function name="mpq_set_str" type="int" content="int mpq_set_z(mpq_t rop, char *str, int base)">
        <summary text="rop に文字列表記の有理数を指定の基数に基づき代入します。表記はたとえば41や41/128のような表記です。共通の約数がある場合は、mpq_canonicalizeを使い正規化する必要があります。書式はmpz_set_strと同じです。有効な文字列の場合0以外、無効な場合0が返ります。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="文字列表記の有理数"/>
        <argument text="基数"/>
    </function>
    <function name="mpq_swap" type="void" content="void mpq_set_z(mpq_t op1, mpza_t op2)">
        <summary text="op1とop2を効率的に入れ替えます。"/>
        <argument text="入れ替える多倍長有理数型の変数"/>
        <argument text="入れ替える多倍長有理数型の変数"/>
    </function>
    <function name="mpq_get_d" type="double" content="double mpq_get_d(mpq_t op)">
        <summary text="op を倍精度浮動小数点数に変換します。必要があれば0方向への丸めが行われます。doubleに対して大きすぎたり小さすぎる場合の返り値は環境依存です。"/>
        <argument text="変換する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_set_d" type="void" content="void mpq_set_d(mpq_t rop, double op)">
        <summary text="op を多倍長有理数に変換します。丸めは行われず、正確です。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="変換する倍精度浮動小数点数方の変数"/>
    </function>
    <function name="mpq_set_f" type="void" content="void mpq_set_f(mpq_t rop, float op)">
        <summary text="op を多倍長有理数に変換します。丸めは行われず、正確です。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="変換する単精度浮動小数点数方の変数"/>
    </function>
    <function name="mpq_get_str" type="char *" content="char * mpq_get_str(char *str, int base, mpq_t op)">
        <summary text="op を文字列表記の有理数に変換します。基数は2~36の間です。分母が1の場合単にnumを返しますが、そうでない場合num/denomという形で返します。strがNULLの場合、自動で領域が確保されます。"/>
        <argument text="代入先の文字列。NULLでない場合、mpz_sizeinbase (mpq_numref(op), base) + mpz_sizeinbase (mpq_denref(op), base) + 3を満たす必要があります。"/>
        <argument text="基数"/>
        <argument text="変換する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_add" type="void" content="void mpq_add(mpq_t sum, mpq_t addend1, mpq_t addend2)">
        <summary text="sum に addend1+addend2 を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="一つ目の加算引数"/>
        <argument text="二つ目の加算引数"/>
    </function>
    <function name="mpq_sub" type="void" content="void mpq_sub(mpq_t difference, mpq_t minuend, mpq_t subtrahend)">
        <summary text="difference に minuend-subtrahend を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="一つ目の減算引数"/>
        <argument text="二つ目の減算引数"/>
    </function>
    <function name="mpq_mul" type="void" content="void mpq_mul(mpq_t product, mpq_t multiplier, mpq_t multiplicand)">
        <summary text="product に multiplier*multiplicand を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="一つ目の乗算引数"/>
        <argument text="二つ目の乗算引数"/>
    </function>
    <function name="mpq_div" type="void" content="void mpq_div(mpq_t quotient, mpq_t dividend, mpq_t divisor)">
        <summary text="quotient に dividend/divisor を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="一つ目の除算引数"/>
        <argument text="二つ目の除算引数"/>
    </function>
    <function name="mpq_div_2exp" type="void" content="void mpq_div(mpq_t rop, mpq_t op1, mp_bitcnt op2)">
        <summary text="rop に op1/2^op2 を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="一つ目の除算引数"/>
        <argument text="2のべき"/>
    </function>
    <function name="mpq_neg" type="void" content="void mpq_neg(mpq_t negated_operand, mpq_t operand)">
        <summary text="negated_operand に -operand を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="符号を反転させる多倍長有理数型の変数"/>
    </function>
    <function name="mpq_abs" type="void" content="void mpq_abs(mpq_t rop, mpq_t op)">
        <summary text="rop に abs(op) を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="絶対値を取る多倍長有理数型の変数"/>
    </function>
    <function name="mpq_inv" type="void" content="void mpq_inv(mpq_t inverted_number, mpq_t number)">
        <summary text="inverted_number に 1/number を代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="逆数を取る多倍長有理数型の変数"/>
    </function>
    <function name="mpq_cmp" type="int" content="int mpq_cmp(mpq_t op1, mpq_t op2)">
        <summary text="op1 と op2 を比較します。op1&gt;op2のとき正の数、op1=op2のとき0、op1&lt;op2のとき負の数を返します。等しいかを調べるときは、mpq_equalの方が高速です。"/>
        <argument text="比較する一つ目の多倍長有理数型の変数"/>
        <argument text="比較する一つ目の多倍長有理数型の変数"/>
    </function>
    <function name="mpq_cmp_ui" type="int" content="int mpq_cmp_ui(mpq_t op1, unsigned long int num2, unsigned long int den2)">
        <summary text="(マクロです)op1 と num2/den2 を比較します。op1&gt;(num2/den2)のとき正の数、op1=(num2/den2)のとき0、op1&lt;(num2/den2)のとき負の数を返します。num2とden2は共通の約数を持っていてもいいです。"/>
        <argument text="比較する一つ目の多倍長有理数型の変数"/>
        <argument text="比較する二つ目の分子の変数"/>
        <argument text="比較する二つ目の分母の変数"/>
    </function>
    <function name="mpq_cmp_si" type="int" content="int mpq_cmp_si(mpq_t op1, long int num2, long int den2)">
        <summary text="(マクロです)op1 と num2/den2 を比較します。op1&gt;(num2/den2)のとき正の数、op1=(num2/den2)のとき0、op1&lt;(num2/den2)のとき負の数を返します。num2とden2は共通の約数を持っていてもいいです。"/>
        <argument text="比較する一つ目の多倍長有理数型の変数"/>
        <argument text="比較する二つ目の分子の変数"/>
        <argument text="比較する二つ目の分母の変数"/>
    </function>
    <function name="mpq_sgn" type="int" content="int mpq_sgn(mpq_t op)">
        <summary text="(マクロです)op1 の符号を調べます。op1&gt;0のとき1、op1=0のとき0、op1&lt;0のとき-1を返します。"/>
        <argument text="符号を調べる多倍長有理数型の変数"/>
    </function>
    <function name="mpq_equal" type="int" content="int mpq_equal(mpq_t op1, mpq_t op2)">
        <summary text="op1 と op2 が等しいとき0以外の数を返し、等しくないとき0を返します。mpq_cmpよりも高速です。"/>
        <argument text="等しいかを調べる一つ目の多倍長有理数型の変数"/>
        <argument text="等しいかを調べる二つ目の多倍長有理数型の変数"/>
    </function>
    <function name="mpq_numref" type="mpz_t" content="mpq_t mpq_numref(mpq_t op)">
        <summary text="(マクロです)op の分子の参照を取得します。後でopをmpq_tの関数に使用するときはmpq_canonicalizeを行ってください。"/>
        <argument text="分子を取得する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_denref" type="mpz_t" content="mpq_t mpq_denref(mpq_t op)">
        <summary text="(マクロです)op の分母の参照を取得します。後でopをmpq_tの関数に使用するときはmpq_canonicalizeを行ってください。"/>
        <argument text="分母を取得する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_get_num" type="void" content="void mpq_get_num(mpz_t numerator, mpq_t rational)">
        <summary text="rational の分子を取得し numerator に代入します。mpq_numrefを直接使いましょう。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="分子を取得する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_get_num" type="void" content="void mpq_get_num(mpz_t numerator, mpq_t rational)">
        <summary text="rational の分子を取得し numerator に代入します。mpq_numrefを直接使いましょう。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="分子を取得する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_get_den" type="void" content="void mpq_get_den(mpz_t denominator, mpq_t rational)">
        <summary text="rational の分母を取得し denominator に代入します。mpq_denrefを直接使いましょう。"/>
        <argument text="代入先の多倍長整数型の変数"/>
        <argument text="分母を取得する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_set_num" type="void" content="void mpq_set_num(mpq_t rational, mpz_t numerator)">
        <summary text="rational の分子に numerator に代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="分子となる多倍長整数型の変数"/>
    </function>
    <function name="mpq_set_den" type="void" content="void mpq_set_den(mpq_t rational, mpz_t denominator)">
        <summary text="rational の分母に denominator に代入します。"/>
        <argument text="代入先の多倍長有理数型の変数"/>
        <argument text="分母となる多倍長整数型の変数"/>
    </function>
    <function name="mpq_out_str" type="size_t" content="size_t mpq_out_str(FILE *stream, int base, mpq_t op)">
        <summary text="多倍長有理数型を文字列として出力します。エラーが発生した場合の返り値は0です。"/>
        <argument text="出力先のファイルポインタ"/>
        <argument text="基数。2~36"/>
        <argument text="出力する多倍長有理数型の変数"/>
    </function>
    <function name="mpq_inp_str" type="size_t" content="size_t mpq_inp_str(mpz_t rop, FILE *stream, int base">
        <summary text="多倍長有理数型に文字列として入力します。エラーが発生した場合の返り値は0です。mpq_canonicalizeが必要です。0xなどの接頭辞をつける場合は分母、分子ともに必要です。"/>
        <argument text="入力先の多倍長有理数型の変数"/>
        <argument text="入力するファイルポインタ"/>
        <argument text="基数。2~36"/>
    </function>
</root>