﻿<?xml version="1.0" encoding="utf-8"?>
<root>
   <function name="MPI_Init" type="int" content="MPI_Init(int *argc, char ***argv)">
      <summary text="MPIを初期化します。"/>
      <argument text="main関数のargcを渡します。"/>
      <argument text="main関数のargvを渡します。"/>
   </function>
   <function name="MPI_Finalize" type="int" content="MPI_Finalize()">
      <summary text="MPIを終了します。"/>
   </function>
   <function name="MPI_Comm_size" type="int" content="MPI_Comm_size(MPI_Comm comm, int *size)">
      <summary text="全プロセス数を取得します。"/>
      <argument text="MPIコミュニケータ。普通 MPI_COMM_WORLD。"/>
      <argument text="サイズ。"/>
   </function>
   <function name="MPI_Comm_rank" type="int" content="MPI_Comm_rank(MPI_Comm comm, int *rank)">
      <summary text="自身のプロセスランクを取得します。"/>
      <argument text="MPIコミュニケータ。普通 MPI_COMM_WORLD。"/>
      <argument text="ランク。"/>
   </function>
   <function name="MPI_Send" type="int" content="MPI_Send(void *buf, int nsnd, MPI_DataType type, int dest, int tag, MPI_Comm comm)">
      <summary text="データを送信します。"/>
      <argument text="先頭アドレス"/>
      <argument text="送信データ数"/>
      <argument text="送信データ型"/>
      <argument text="送り先ランク番号"/>
      <argument text="タグ(識別番号)"/>
      <argument text="コミュニケーター"/>
   </function>
   <function name="MPI_Recv" type="int" content="MPI_Recv(void *buf, int nsnd, MPI_DataType type, int dest, int tag, MPI_Comm comm, MPI_Status *stat)">
      <summary text="データを受信します。"/>
      <argument text="先頭アドレス"/>
      <argument text="受信データ数"/>
      <argument text="受信データ型"/>
      <argument text="送信元ランク番号"/>
      <argument text="タグ(識別番号)"/>
      <argument text="コミュニケーター"/>
      <argument text="終了状態"/>
   </function>
   <function name="MPI_Isend" type="int" content="MPI_Isend(void *buf, int nsnd, MPI_DataType type, int dest, int tag, MPI_Comm comm, int *req)">
      <summary text="データを非同期送信します。"/>
      <argument text="先頭アドレス"/>
      <argument text="送信データ数"/>
      <argument text="送信データ型"/>
      <argument text="送り先ランク番号"/>
      <argument text="タグ(識別番号)"/>
      <argument text="コミュニケーター"/>
      <argument text="リクエスト"/>
   </function>
   <function name="MPI_Irecv" type="int" content="MPI_Irecv(void *buf, int nsnd, MPI_DataType type, int dest, int tag, MPI_Comm comm, int *req)">
      <summary text="データを非同期受信します。"/>
      <argument text="先頭アドレス"/>
      <argument text="受信データ数"/>
      <argument text="受信データ型"/>
      <argument text="送信元ランク番号"/>
      <argument text="タグ(識別番号)"/>
      <argument text="コミュニケーター"/>
      <argument text="リクエスト"/>
   </function>
   <function name="MPI_Wait" type="int" content="MPI_Wait(MPI_Request *request, MPI_Status *status)">
      <summary text="非同期処理が終わるのを待ちます。"/>
      <argument text="リクエスト"/>
      <argument text="ステータス"/>
   </function>
   <definevalue name="MPI_COMM_WORLD" value="">
      <summary text="プログラムの開始時に走る全プロセス"/>
   </definevalue>
   <definevalue name="MPI_COMM_SELF" value="">
      <summary text="自分自身のプロセス"/>
   </definevalue>
</root>