﻿<?xml version="1.0" encoding="utf-8"?>
<root>
   <object name="FILE">
      <summary text="ストリームを制御するためのオブジェクト型(構造体とは限らない)"/>
   </object>
   <variable name="stdin" type="FILE*">
      <summary text="標準入力のファイルポインタ(通常はキーボード)です。"/>
   </variable>
   <variable name="stdout" type="FILE*">
      <summary text="標準出力のファイルポインタ(通常はディスプレイ)です。"/>
   </variable>
   <variable name="stderr" type="FILE*">
      <summary text="標準エラー出力のファイルポインタ(通常はディスプレイ)です。"/>
   </variable>
	<function name="fopen" type="FILE" content="FILE *fopen(const char *filename, const char *mode)">
	   <summary text="ファイルを開きます。開いたファイルポインタ、失敗した場合はNULLを返します。"/>
	   <argument text="ファイル名"/>
	   <argument text="モード文字列。r:読み込み、w:新規、a:追加。b付加でバイナリ、+付加で入出力両用。"/>
	</function>
	<function name="fclose" type="int" content="int fclose(FILE *fp)">
	   <summary text="ファイルを閉じます。成功した場合は0、失敗したときはEOFを返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fgetc" type="int" content="int fgetc(FILE *fp)">
	   <summary text="ファイルから1文字読み出します。読み出した文字、失敗したか終わりに到達した場合はEOFを返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="getc" type="int" content="int getc(FILE *fp)">
	   <summary text="ファイルから1文字読み出します。読み出した文字、失敗したか終わりに到達した場合はEOFを返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fgets" type="char" content="char *fgets(char *s, int n, FILE *fp)">
	   <summary text="ファイルから1行読み出します。結果に改行を含みます。引数で指定したバッファ、失敗したか終わりに到達した場合はNULLを返します。"/>
	   <argument text="文字列を格納するバッファ"/>
	   <argument text="バッファサイズ"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fputc" type="int" content="int fputc(int c, FILE *fp)">
	   <summary text="ファイルに1文字書き込みます。出力文字、失敗したときはEOFを返します。"/>
	   <argument text="文字"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="putc" type="int" content="int putc(int c, FILE *fp)">
	   <summary text="ファイルに1文字書き込みます。出力文字、失敗したときはEOFを返します。"/>
	   <argument text="文字"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fputs" type="int" content="int fputs(const char *s, FILE *fp)">
	   <summary text="ファイルに文字列を書き込みます。成功した場合は真、失敗したときはEOFを返します。"/>
	   <argument text="文字列"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fread" type="size_t" content="size_t fread(void *ptr, size_t size, size_t nelem, FILE *fp)">
	   <summary text="ファイルから固定サイズの項目を読み込みます。読み込んだ項目数、失敗した場合は0を返します。"/>
	   <argument text="読み込み結果を格納するバッファ"/>
	   <argument text="1項目のサイズ"/>
	   <argument text="項目数"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fwrite" type="size_t" content="size_t fwrite(const void *ptr, size_t size, size_t nelem, FILE *fp)">
	   <summary text="ファイルに固定サイズの項目を書き込みます。書き込んだ項目数、失敗した場合は0を返します。"/>
	   <argument text="書き込むバッファ"/>
	   <argument text="1項目のサイズ"/>
	   <argument text="項目数"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fprintf" type="int" content="int fprintf(FILE *fp, const char *format, ...)">
	   <summary text="ファイルに書式付き文字列を書き込みます。出力文字数、失敗したときは負の値を返します。"/>
	   <argument text="ファイルポインタ"/>
	   <argument text="書式付き文字列"/>
	   <argument text="可変個の変数"/>
	</function>
	<function name="fscanf" type="int" content="int fscanf(FILE *fp, const char *format, ...)">
	   <summary text="ファイルから文字列を読み込み指定された形式に変換します。変換に成功した数、失敗した場合は-1を返します。"/>
	   <argument text="ファイルポインタ"/>
	   <argument text="変換指定文字列"/>
	   <argument text="可変個のバッファ"/>
	</function>
	<function name="ftell" type="long" content="long ftell(FILE *fp)">
	   <summary text="ファイル位置を取得します。現在のファイル位置を返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fseek" type="int" content="int fseek(FILE *fp, long offset, int ptrname)">
	   <summary text="ファイル位置を変更します。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="ファイルポインタ"/>
	   <argument text="ファイル位置の移動数"/>
	   <argument text="ファイル位置の基準。 SEEK_SET 先頭、SEEK_CUR 現在の位置、SEEK_END 終わり。"/>
	</function>
	<definevalue name="SEEK_SET" value="">
	   <summary text="ファイルの先頭"/>
	</definevalue>
	<definevalue name="SEEK_CUR" value="">
	   <summary text="シークのの現在の位置"/>
	</definevalue>
	<definevalue name="SEEK_END" value="">
	   <summary text="ファイルの終端"/>
	</definevalue>
	<function name="fgetpos" type="int" content="int fgetpos(FILE *fp, fpos_t *ptr)">
	   <summary text="現在のファイル位置を格納します。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="ファイルポインタ"/>
	   <argument text="ファイル位置を格納する変数のポインタ"/>
	</function>
	<function name="fsetpos" type="int" content="int fsetpos(FILE *fp, const fpos_t *ptr)">
	   <summary text="ファイル位置を変更します。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="ファイルポインタ"/>
	   <argument text="ファイル位置を格納する変数のポインタ"/>
	</function>
	<function name="feof" type="int" content="int feof(FILE *fp)">
	   <summary text="ファイルが終わりに到達したか調べます。終わりに到達した場合は真、到達していない場合は偽を返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="ferror" type="int" content="int ferror(FILE *fp)">
	   <summary text="ファイルにエラーが発生したか調べます。エラー発生した場合は真、発生していない時は偽を返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="clearerr" type="void" content="void clearerr(FILE *fp)">
	   <summary text="ファイルのエラーの時に回復します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="fflush" type="int" content="int fflush(FILE *fp)">
	   <summary text="出力バッファを強制出力します。成功した場合は0、失敗したときは偽を返します。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="freopen" type="FILE" content="FILE *freopen(const char *filename, const char *mode, FILE *fp)">
	   <summary text="ファイルポインタの再割り当てを行います。引数で指定されたファイルポインタ、失敗した場合はNULLを返します。"/>
	   <argument text="ファイル名"/>
	   <argument text="モード文字列。r:読み込み、w:新規、a:追加。b付加でバイナリ、+付加で入出力両用。"/>
	   <argument text="ファイルポインタ"/>
	</function>
	<function name="rename" type="int" content="int rename(const char *oldname, const char *newname)">
	   <summary text="ファイルの名前を変更します。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="現在のファイル名"/>
	   <argument text="新しいファイル名"/>
	</function>
	<function name="remove" type="int" content="int remove(const char *filename)">
	   <summary text="ファイルを削除します。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="ファイル名"/>
	</function>
	<function name="getchar" type="int" content="int getchar()">
	   <summary text="標準入力(キーボード)から1文字読み込みます。読み出した文字、失敗した場合はEOFを返します。"/>
	</function>
	<function name="putchar" type="int" content="int putchar(char c)">
	   <summary text="標準出力(ディスプレイ)に1文字書き込みます。出力文字、失敗したときはEOFを返します。"/>
	   <argument text="文字"/>
	</function>
	<function name="gets" type="char" content="char *gets(char *s)">
	   <summary text="標準入力(キーボード)から1行読み出します。結果に改行は含まれません。使用非推奨です。代わりにfgets()にstdinを引数として使用してください。"/>
	   <argument text="読み込んだ文字列を格納するバッファ"/>
	</function>
	<function name="puts" type="int" content="int puts(const char *s)">
	   <summary text="標準出力(ディスプレイ)に1行書き込みます。改行されます。成功した場合は0、失敗したときは0以外を返します。"/>
	   <argument text="文字列"/>
	</function>
	<function name="perror" type="void" content="void perror(const char *s)">
	   <summary text="指定した文字列と一緒に直前に発生したエラーを表示します。"/>
	   <argument text="表示する文字列"/>
	</function>
	<function name="printf" type="int" content="int printf(const char *format, ...)">
	   <summary text="標準出力(ディスプレイ)に書式付き文字列を書き込みます。出力文字数。失敗したときは-1を返します。"/>
	   <argument text="書式付き文字列"/>
	   <argument text="可変個の変数"/>
	</function>
	<function name="scanf" type="int" content="int scanf(const char *format, ...)">
	   <summary text="標準入力(キーボード)から文字列を読み込み指定された形式に変換します。変換に成功した数。失敗した場合は-1を返します。"/>
	   <argument text="変換指定文字列"/>
	   <argument text="可変個のバッファ"/>
	</function>
</root>