﻿<?xml version="1.0" encoding="utf-8"?>
<root>
   <definevalue name="CLOCKS_PER_SEC">
      <summary text="clock()が返す値を秒単位に変換するために割る値を表すマクロ"/>
   </definevalue>
	<function name="time" type="time_t" content="time_t time(time_t *t)">
      <summary text="現在の時刻を基準時刻からの経過秒数で返します。引数を NULL で呼び出して戻り値だけを取得できます。"/>
      <argument text="時刻を格納する変数のアドレス"/>
   </function>
	<function name="clock" type="clock_t" content="clock_t clock()">
	   <summary text="プログラムが使用したプロセス時間を返します。clock() / CLOCKS_PER_SEC とすることで秒単位の値を得られます。"/>
	</function>
	<function name="difftime" type="double" content="double difftime(time_t t1, time_t t2)">
	   <summary text="２つの経過秒数の差を返します。"/>
      <argument text="基準時刻からの経過秒数１"/>
      <argument text="基準時刻からの経過秒数２"/>
	</function>
	<function name="localtime" type="struct tm*" content="struct tm *localtime(const time_t *t)">
	   <summary text="基準時刻からの経過秒数を国内時刻に変換します。"/>
      <argument text="基準時刻からの経過秒数"/>
	</function>
	<function name="gmtime" type="struct tm*" content="struct tm *gmtime(const time_t *t)">
	   <summary text="基準時刻からの経過秒数を国際時刻に変換します。"/>
      <argument text="基準時刻からの経過秒数"/>
	</function>
	<function name="asctime" type="char*" content="char *asctime(const struct tm *tm)">
	   <summary text="時刻を Wed Feb 17 20:14:04 1988 のような文字列に変換します。"/>
      <argument text="時刻を格納した構造体"/>
	</function>
	<function name="ctime" type="char*" content="char *ctime(const time_t *t)">
	   <summary text="時刻を Wed Feb 17 20:14:04 1988 のような文字列に変換します。"/>
      <argument text="基準時刻からの経過秒数"/>
	</function>
	<function name="strftime" type="size_t" content="size_t strftime(char *s, size_t smax, const char *fmt, const struct tm *tp)">
	   <summary text="時刻を指定された書式通りに文字列に変換します。配列に書き込まれた文字数が返され、失敗した場合は0が返されます。"/>
      <argument text="文字配列"/>
      <argument text="文字配列のサイズ"/>
      <argument text="時刻書式指定文字列"/>
      <argument text="時刻を格納した構造体"/>
   </function>
   <object name="struct tm">
      <summary text="時間を表す構造体"/>
      <variable name="tm_sec" type="int">
         <summary text="秒"/>
      </variable>
      <variable name="tm_min" type="int">
         <summary text="分"/>
      </variable>
      <variable name="tm_hour" type="int">
         <summary text="時"/>
      </variable>
      <variable name="tm_mday" type="int">
         <summary text="日"/>
      </variable>
      <variable name="tm_mon" type="int">
         <summary text="月(１月=0)"/>
      </variable>
      <variable name="tm_year" type="int">
         <summary text="西暦年-1900"/>
      </variable>
      <variable name="tm_wday" type="int">
         <summary text="曜日(日曜=0)"/>
      </variable>
      <variable name="tm_yday" type="int">
         <summary text="日(年を通して)"/>
      </variable>
      <variable name="tm_isdst" type="int">
         <summary text="サーマータイムフラグ"/>
      </variable>
   </object>
</root>