﻿import clr

clr.AddReference("System.Windows.Forms")
clr.AddReference("System.Drawing")
clr.AddReference("System")
clr.AddReference("System.IO")

from System.Windows.Forms import *
from System.Drawing import Color
from System import *
from System.IO import *
from System.Diagnostics import Process

saveFileDialog = SaveFileDialog()
saveFileDialog.InitialDirectory = Path.GetDirectoryName(editor.FileName)
saveFileDialog.Filter = "html files (*.html)|*.html|All files (*.*)|*.*"
saveFileDialog.RestoreDirectory = True
currentExtension = Path.GetExtension(editor.FileName)
saveFileDialog.FileName = Path.ChangeExtension(Path.GetFileName(editor.FileName), currentExtension + ".html")
if saveFileDialog.ShowDialog() == DialogResult.OK:
    filename = saveFileDialog.FileName
    text = editor.Document.Text
    output = "<html>"
    output += "<head>"
    output += "<style>"
    output += "body{font-family:MS Gothic;}"
    output += "</style>"
    output += '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />'
    output += "</head>"
    output += "<body>"
    index = 0
    length = len(text)
    lastColor = Color.Black
    builder = ""
    def append():
        global output
        global builder
        global lastColor
        if len(builder) > 0:
            foreColor = '#%02X%02X%02X' % (lastColor.R,lastColor.G,lastColor.B)
            output += '<span style="' + "color:"+ foreColor +'">' + builder + "</span>"
        builder = ""
    while index < length:
        c = text[index]
        newLine = False
        if c == '\r':
            newLine = True
            index += 1
            if index < length:
                c = text[index]
                if c == '\n':
                    index += 1
                    if index < length:
                        c = text[index]
        elif c == '\n':
            newLine = True
            index += 1
            if index < length:
                c = text[index]
        if newLine:
            append()
            output += "<br/>\n"
        if index >= length:
            break
        if c == '<':
            c = "&lt;"
        elif c == '>':
            c = "&gt;"
        elif c == "&":
            c = "&amp;"
        elif c == '"':
            c = '&quot;'
        elif c == "'":
            c ='&#039;'
        elif c == " ":
            c = "&nbsp;"
        klass = editor.Document.GetCharClass(index)
        f,b = editor.ColorScheme.GetColor(klass)
        if lastColor != f:
            append()
            lastColor = f
        builder += c
        index += 1
    append()
    output += "</body>"
    output += "</html>"
    File.WriteAllText(filename, output)
    Process.Start(filename)
        