﻿# coding : utf-8

import sys
sys.path.insert(0,"./plugin/tex/Lib")

import clr
clr.AddReference("System")
from System.IO import *
from System.Text import *
import re

def compileEnd(result):
    if result:
        n2.CloseDocument()

docReg = re.compile(r'\\begin\{document\}')
docLineIndex = -1
line = 0
while line < editor.Document.LineCount:
    lineContent = editor.Document.GetLineContent(line)
    match1 = docReg.match(lineContent)
    if match1 is not None:
        docLineIndex = line
        break
    line += 1

if docLineIndex < 0:
    MessageBox.Show("No document")
    sys.exit()

reg1 = re.compile(r'\\begin\{frame\}')
reg2 = re.compile(r'\\end\{frame\}')
line, column = editor.GetLineColumnIndexFromCharIndex(editor.CaretIndex)
startLine = endLine = -1
startContent = ""
while line >= 0:
    lineContent = editor.Document.GetLineContent(line)
    match1 = reg1.match(lineContent)
    match2 = reg2.match(lineContent)
    if match1 is not None:
        startLine = line
        break
    elif match2 is not None:
        break
    line -= 1

line += 1
if startLine >= 0:
    while line < editor.Document.LineCount:
        lineContent = editor.Document.GetLineContent(line)
        match1 = reg1.match(lineContent)
        match2 = reg2.match(lineContent)
        if match2 is not None:
            endLine = line
        elif match1 is not None:
            break
        line += 1
        
if startLine >= 0 and endLine >= 0:
    startIndex = 0
    endIndex = editor.Document.GetLineHeadIndex(docLineIndex) + editor.Document.GetLineLength(docLineIndex)
    text = editor.Document.GetTextInRange(startIndex,endIndex)
    startIndex = editor.Document.GetLineHeadIndex(startLine)
    endIndex = editor.Document.GetLineHeadIndex(endLine) + editor.Document.GetLineLength(endLine)
    text += "\r\n"+editor.Document.GetTextInRange(startIndex,endIndex)
    text += "\r\n\end{document}"
    currentDir = Path.GetDirectoryName(Path.GetFullPath(n2.DocumentPath))
    path = Path.Combine(currentDir, "__beamer__partial.tex")
    File.WriteAllText(path, text, Encoding.GetEncoding(932));
    n2.OpenFileToNewDocument(path)
    n2.CompileAndExecute(path, compileEnd)
else:
    MessageBox.Show("No frame")