﻿# coding : utf-8

import clr
clr.AddReference("System.Windows.Forms")
clr.AddReference("System.Drawing")

from System.Windows.Forms import *
from System.Drawing import *


data = [0,0,""]

def Keypress(sender,e):
   if e.KeyChar == '\r':
      e.Handled = True
      PressedOK(sender,e)


def PressedCancel(sender,e):
   fm = sender.FindForm()
   fm.Close()

def PressedOK(sender,e):
   fm = sender.FindForm()
   lab = fm.Controls[3]
   tb = fm.Controls[0]
   st = tb.Text
   try:
      if data[0] == 0:
         num = int(st)
         if num <= 0:
            MessageBox.Show(u"０よりも大きい数を入力してください")
            return
         data[0] = num
         lab.Text = u"列の数"
         tb.Text = ""
         tb.Focus()
      elif data[1] == 0:
         num = int(st)
         if num <= 0:
            MessageBox.Show(u"０よりも大きい数を入力してください")
            return
         data[1] = num
         lab.Text = u"行列のタイプ( [ { |"
         tb.Text = "("
         tb.SelectAll()
         tb.Focus()
      else:
         if st != u"(" and st != u"[" and st != u"{" and st != u"|":
            MessageBox.Show(u"( [ { | のうちからいずれかを入力してください")
         data[2] = st
         cs = ""
         linedata = ""
         iter = 0
         while iter < data[1]:
            cs += u"c"
            if iter > 0:
               linedata += u" &"
            iter += 1
         st = u"\\left"+data[2]+u"\r\n\\begin{array}{"+cs+"}\r\n"
         beginpoint = len(st)
         iter = 0
         while iter < data[0]:
            st += linedata
            if iter == data[0] - 1:
               st += u" \r\n"
            else:
               st += u"  \\\\\r\n"
            iter += 1
         st += u"\\end{array}\r\n\\right"
         if data[2] == u"(":
            st += u")"
         elif data[2] == u"[":
            st += u"]"
         elif data[2] == u"{":
            st += u"}"
         elif data[2] == u"|":
            st += u"|"
         st += "\r\n"
         begin,end = editor.Document.GetSelection()
         editor.Document.Replace(st,begin,end)
         editor.SetSelection(begin+beginpoint,begin+beginpoint)
         fm.Close()
   except ValueError:
      MessageBox.Show(u"テキストボックスの入力が数値ではありません")

fm = Form()
fm.MaximizeBox = False
fm.MinimizeBox = False
fm.FormBorderStyle = FormBorderStyle.FixedDialog
fm.ShowInTaskbar = False
fm.ShowIcon = False
fm.Text = u"行列"
fm.Size = Size(200,150)
okbut = Button()
okbut.Location = Point(95-okbut.Width,80)
okbut.Text = u"OK"
okbut.Click += PressedOK
cancelbut = Button()
cancelbut.Location = Point(105,80)
cancelbut.Text = u"Cancel"
cancelbut.Click += PressedCancel
lab = Label()
lab.AutoSize = True
lab.Text = u"行の数"
lab.Location = Point(10,10)
tb = TextBox()
tb.Location = Point(10,30)
tb.Width = 170
tb.KeyPress += Keypress
fm.Controls.Add(tb)
fm.Controls.Add(okbut)
fm.Controls.Add(cancelbut)
fm.Controls.Add(lab)
fm.StartPosition = FormStartPosition.CenterScreen
fm.ShowDialog()