﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// ヌルスペース情報(シングルトン)
    /// </summary>
    public class NullNameSpaceInfo : NameSpaceInfo
    {
        private static NullNameSpaceInfo ins = new NullNameSpaceInfo();
        private NullNameSpaceInfo()
        {
        }
        /// <summary>
        /// ヌルスペース情報
        /// </summary>
        public static NullNameSpaceInfo NullNSM
        {
            get
            {
                return ins;
            }
        }
    }
    /// <summary>
    /// 名前空間情報
    /// </summary>
    public class NameSpaceInfo : AssistInformation
    {
        NameSpaceInfo parentnamespace;
        string name;
        SortedList<string, NameSpaceInfo> namespaces;
        SortedList<string, FunctionInfo> functioninfos;
        SortedList<string, ObjectInfo> objectinfos;
        SortedList<string, VariableInfo> variableinfos;
        SortedList<string, DefineValueInfo> definevalueinfos;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public NameSpaceInfo()
        {
            Image = NotepadNeueExtension.Properties.Resources._namespace;
            namespaces = new SortedList<string, NameSpaceInfo>();
            functioninfos = new SortedList<string, FunctionInfo>();
            objectinfos = new SortedList<string, ObjectInfo>();
            variableinfos = new SortedList<string, VariableInfo>();
            definevalueinfos = new SortedList<string, DefineValueInfo>();
        }
        /// <summary>
        /// 名前空間情報を加える
        /// </summary>
        /// <param name="namespacemanager"></param>
        /// <param name="name"></param>
        public void AddNameSpace(NameSpaceInfo namespacemanager, string name)
        {
            if (!namespaces.ContainsKey(name))
            {
                namespaces.Add(name, namespacemanager);
                namespacemanager.parentnamespace = this;
            }
        }
        /// <summary>
        /// 関数を加える
        /// </summary>
        /// <param name="functioninfo"></param>
        /// <param name="name"></param>
        public void AddFunction(FunctionInfo functioninfo, string name)
        {
            if (!functioninfos.ContainsKey(name))
            {
                functioninfos.Add(name, functioninfo);
            }
            else
            {
                FunctionInfo tempfunctioninfo = null;
                if (functioninfos.TryGetValue(name, out tempfunctioninfo))
                {
                    tempfunctioninfo.AddContent(functioninfo.ContentAt(0));
                }
            }
        }
        /// <summary>
        /// オブジェクトを加える
        /// </summary>
        /// <param name="objectinfo"></param>
        /// <param name="name"></param>
        public void AddObject(ObjectInfo objectinfo, string name)
        {
            if (!objectinfos.ContainsKey(name))
            {
                objectinfos.Add(name, objectinfo);
                objectinfo.Namespace = this;
            }
        }
        /// <summary>
        /// 変数を加える
        /// </summary>
        /// <param name="variableinfo"></param>
        /// <param name="name"></param>
        public void AddVariable(VariableInfo variableinfo, string name)
        {
            if (!variableinfos.ContainsKey(name))
            {
                variableinfos.Add(name, variableinfo);
            }
        }
        /// <summary>
        /// 定義値を加える
        /// </summary>
        /// <param name="definevalueinfo"></param>
        /// <param name="name"></param>
        public void AddDefineValueInfo(DefineValueInfo definevalueinfo, string name)
        {
            if (!definevalueinfos.ContainsKey(name))
            {
                definevalueinfos.Add(name, definevalueinfo);
            }
        }
        /// <summary>
        /// 名前からオブジェクト情報を取得する
        /// </summary>
        /// <param name="objectname"></param>
        /// <returns></returns>
        public ObjectInfo GetObjectInfo(string objectname)
        {
            ObjectInfo ret = null;
            objectinfos.TryGetValue(objectname, out ret);
            return ret;
        }
        /// <summary>
        /// 全てのオブジェクトを取得する
        /// </summary>
        /// <returns></returns>
        public IList<ObjectInfo> GetAllObjectType()
        {
            return objectinfos.Values;
        }
        /// <summary>
        /// 全ての関数を取得する
        /// </summary>
        /// <returns></returns>
        public IList<FunctionInfo> GetAllFunction()
        {
            return functioninfos.Values;
        }
        /// <summary>
        /// 全ての名前空間を取得する
        /// </summary>
        /// <returns></returns>
        public IList<NameSpaceInfo> GetAllNameSpace()
        {
            return namespaces.Values;
        }
        /// <summary>
        /// 全ての変数を取得する
        /// </summary>
        /// <returns></returns>
        public IList<VariableInfo> GetAllVariable()
        {
            return variableinfos.Values;
        }
        /// <summary>
        /// 全ての定義値を取得する
        /// </summary>
        /// <returns></returns>
        public IList<DefineValueInfo> GetAllDefineValue()
        {
            return definevalueinfos.Values;
        }
        /// <summary>
        /// 名前から名前空間情報を取得する
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public NameSpaceInfo GetNameSpaceManager(string key)
        {
            NameSpaceInfo ret = null;
            namespaces.TryGetValue(key, out ret);
            return ret;
        }
        /// <summary>
        /// 名前
        /// </summary>
        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// 親の名前空間
        /// </summary>
        public NameSpaceInfo ParentNamespace
        {
            get
            {
                return parentnamespace;
            }
            set
            {
                parentnamespace = value;
            }
        }
        /// <summary>
        /// 補完ウィンドウ表示テキスト(Nameを返す)
        /// </summary>
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// ツールチップ表示ヒント(なにもしない)
        /// </summary>
        public override string HintText
        {
            get
            {
                return "";
            }
            set
            {

            }
        }
    }
}
