﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Diagnostics;
using System.IO;

namespace Packager
{
    class Program
    {
        static void Main(string[] args)
        {
            FileVersionInfo fileVersion = FileVersionInfo.GetVersionInfo(Assembly.GetExecutingAssembly().Location);
            string binDir = Path.Combine(@"..\..\..\NotepadNeue\bin");
            string packagePath = Path.GetFullPath(Path.Combine(@"..\..\..\package", fileVersion.FileVersion));
            Console.WriteLine("{0} is output dir, OK? (y/n)", packagePath);
            if (Console.ReadLine() == "y")
            {
                SafeCreateDirectory(packagePath);
                Package(Path.Combine(binDir, "x86", "Release"), Path.Combine(packagePath, "x86"), false);
                Package(Path.Combine(binDir, "x64", "Release"), Path.Combine(packagePath, "x64"), true);
                Console.WriteLine("Output finished.");
            }
            else
            {
                Console.WriteLine("Output cancelled");
            } Console.ReadLine();
        }

        static void SafeCreateDirectory(string dir)
        {
            if (!Directory.Exists(dir))
            {
                Directory.CreateDirectory(dir);
            }
        }

        static void SafeCopyFile(string srcFile, string destFile)
        {
            Console.Write("Copy:{0}", Path.Combine(Path.GetFileName(Path.GetDirectoryName(srcFile)),
                Path.GetFileName(srcFile)));
            File.Copy(srcFile, destFile, true);
            Console.WriteLine("...complete");
        }

        static void RecursiveCopy(string srcDir, string destDir)
        {
            SafeCreateDirectory(destDir);
            foreach (string childDir in Directory.GetDirectories(srcDir))
            {
                RecursiveCopy(childDir, Path.Combine(destDir, Path.GetFileName(childDir)));
            }
            foreach (string childFile in Directory.GetFiles(srcDir))
            {
                SafeCopyFile(childFile, Path.Combine(destDir, Path.GetFileName(childFile)));
            }
        }

        static void Package(string dir, string outDir, bool isX64)
        {
            SafeCreateDirectory(outDir);

            string[] copyFileNames = new string[]{
                "Azuki.dll",
                "config.ini",
                "CustomColorDialog.dll",
                "DirectShowLib-2005.dll",
                "IronPython.dll",
                "IronPython.Modules.dll",
                "keybind.ini",
                "Microsoft.Scripting.dll",
                "NotepadNeue.exe",
                "NotepadNeue.exe.config",
                "NotepadNeueExtension.dll",
                "WeifenLuo.WinFormsUI.Docking.dll",        
                isX64?"Hunspellx64.dll":"Hunspellx86.dll"
            };

            string[] extensionFileNames = new string[]{
                "ConsoleExtension.dll",
                "ExplorerExtension.dll",
                "ParseExtension.dll",
                "ScriptExtension.dll",
                "SearchAndReplaceExtension.dll",
                "ConsoleExtension.dll.config",
                "ExplorerExtension.dll.config",
                "ParseExtension.dll.config",
                "ScriptExtension.dll.config",
                "SearchAndReplaceExtension.dll.config",
                "NHunspell.dll",
                @"dict\en_US.aff",
                @"dict\en_US.dic",
            };

            foreach (string fileName in copyFileNames)
            {
                SafeCopyFile(Path.Combine(dir, fileName), Path.Combine(outDir, fileName));
            }

            SafeCreateDirectory(Path.Combine(outDir, "extension"));
            SafeCreateDirectory(Path.Combine(outDir, "extension\\dict"));
            foreach (string extensionFileName in extensionFileNames)
            {
                SafeCopyFile(Path.Combine(dir, "extension", extensionFileName),
                    Path.Combine(outDir, "extension", extensionFileName));
            }

            RecursiveCopy(Path.Combine(dir, "ini"), Path.Combine(outDir, "ini"));
            RecursiveCopy(Path.Combine(dir, "plugin"), Path.Combine(outDir, "plugin"));
        }
    }
}
