﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    abstract class OperatorTokenizerBase : TokenizerBase
    {
        public abstract string[] Operations
        {
            get;
        }

        public OperatorTokenizerBase(ParseEnclosure[] enclosures, bool removeComments)
            : base(enclosures, removeComments)
        {

        }

        protected override ParseToken[] JoinSymbolsImpl(ParseToken[] tokens)
        {
            List<ParseToken> ret = new List<ParseToken>();
            for (int i = 0; i < tokens.Length; i++)
            {
                ParseToken append = tokens[i];
                foreach (string ope in Operations)
                {
                    if (ope.Length > tokens.Length - i)
                    {
                        continue;
                    }
                    bool ok = true;
                    for (int j = 0; j < ope.Length; j++)
                    {
                        if (tokens[i + j].Token != ope[j].ToString())
                        {
                            ok = false;
                            break;
                        }
                    }
                    if (ok)
                    {
                        append = tokens.Skip(i).Take(ope.Length).Aggregate((p1, p2) => p1.Join(p2));
                        i += ope.Length - 1;
                        break;
                    }
                }
                ret.Add(append);
            }
            return ret.ToArray();
        }

        protected int SkipTo(TokenType tokenType, int index, ParseToken[] tokens)
        {
            return SkipTo(null, tokenType, index, tokens);
        }

        protected int SkipTo(string token, TokenType tokenType, int index, ParseToken[] tokens)
        {
            for (int i = index; i < tokens.Length; i++)
            {
                if (token != null)
                {
                    if (tokens[i].Token == token && tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
                else
                {
                    if (tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
            }

            return tokens.Length;
        }

        protected int SkipTo(string token, TokenType tokenType, TokenType[] allowedTokenTypes, int index, ParseToken[] tokens)
        {
            for (int i = index; i < tokens.Length; i++)
            {
                if (!allowedTokenTypes.Contains(tokens[i].TokenType))
                {
                    return tokens.Length;
                }

                if (token != null)
                {
                    if (tokens[i].Token == token && tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
                else
                {
                    if (tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
            }

            return tokens.Length;
        }
    }
}
