﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    class ParseEnclosure
    {
        public string OpenOperand
        {
            get;
            private set;
        }

        public string CloseOperand
        {
            get;
            private set;
        }

        public string EscapeString
        {
            get;
            private set;
        }

        public bool IsMultiLine
        {
            get;
            private set;
        }

        public TokenType TokenType
        {
            get;
            private set;
        }

        public ParseEnclosure(string openOperand, string closeOperand, string escapeString, bool isMultiLine, TokenType tokenType)
        {
            OpenOperand = openOperand;
            CloseOperand = closeOperand;
            EscapeString = escapeString;
            IsMultiLine = isMultiLine;
            TokenType = tokenType;

            if (CloseOperand == null && IsMultiLine)
            {
                throw new Exception("CloseOperand is null and IsMultiLine is true. This is not available");
            }
        }
    }
}
