﻿using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using NotepadNeueExtension;

namespace SearchAndReplaceExtension
{
    public class SearchAndReplaceExtension : CExtension
    {
        string cachepath = Path.GetDirectoryName(Application.ExecutablePath) + "\\console.cache";
        private Label label3;
        private ComboBox comboBox1;
        private GroupBox groupBox1;
        private CheckBox checkBox3;
        private CheckBox checkBox1;
        private CheckBox checkBox2;
        private Label label2;
        private Label label1;
        private Button button4;
        private Button button3;
        private Button button1;
        private TextBox textBox2;
        private TextBox textBox1;
        public override string ExtensionName
        {
            get
            {
                return "検索/置換";
            }
            set
            {

            }
        }

        enum SearchType
        {
            Current = 0,
            All = 1,
            InSelection = 2
        }

        int selbegin = -1;
        int selend = -1;

        const string st1 = "ありませんでした";
        const string st2 = "処理が完了しました。";
        const string st3 = "入力がありません。";
        const string st4 = "個の変換を行いました";
        const string st5 = "選択範囲がありません";
        private SearchType Searchtype
        {
            get
            {
                return (SearchType)comboBox1.SelectedIndex;
            }
        }
        public IExtensionHost Host
        {
            get;
            set;
        }
        private bool IgnoreCase
        {
            get
            {
                return checkBox3.Checked;
            }
        }
        public override void Initialize(IExtensionHost Host)
        {
            InitializeComponent();
            this.Host = Host;
            this.GotFocus += new EventHandler(SearchAndReplace_GotFocus);
            this.VisibleChanged += new EventHandler(SearchAndReplaceExtension_VisibleChanged);
            this.comboBox1.SelectedIndex = 0;
        }

        private void InitializeComponent()
        {
            this.label3 = new System.Windows.Forms.Label();
            this.comboBox1 = new System.Windows.Forms.ComboBox();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.checkBox3 = new System.Windows.Forms.CheckBox();
            this.checkBox1 = new System.Windows.Forms.CheckBox();
            this.checkBox2 = new System.Windows.Forms.CheckBox();
            this.label2 = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.button4 = new System.Windows.Forms.Button();
            this.button3 = new System.Windows.Forms.Button();
            this.button1 = new System.Windows.Forms.Button();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.groupBox1.SuspendLayout();
            this.SuspendLayout();
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.BackColor = System.Drawing.Color.Transparent;
            this.label3.Location = new System.Drawing.Point(13, 86);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(53, 12);
            this.label3.TabIndex = 23;
            this.label3.Text = "検索対象";
            // 
            // comboBox1
            // 
            this.comboBox1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboBox1.FormattingEnabled = true;
            this.comboBox1.Items.AddRange(new object[] {
            "現在のドキュメント",
            "開いているドキュメント全て",
            "選択範囲"});
            this.comboBox1.Location = new System.Drawing.Point(14, 101);
            this.comboBox1.Name = "comboBox1";
            this.comboBox1.Size = new System.Drawing.Size(189, 20);
            this.comboBox1.TabIndex = 22;
            this.comboBox1.SelectedIndexChanged += new System.EventHandler(this.comboBox1_SelectedIndexChanged);
            // 
            // groupBox1
            // 
            this.groupBox1.BackColor = System.Drawing.Color.Transparent;
            this.groupBox1.Controls.Add(this.checkBox3);
            this.groupBox1.Controls.Add(this.checkBox1);
            this.groupBox1.Controls.Add(this.checkBox2);
            this.groupBox1.Location = new System.Drawing.Point(15, 128);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(193, 97);
            this.groupBox1.TabIndex = 21;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "オプション";
            // 
            // checkBox3
            // 
            this.checkBox3.AutoSize = true;
            this.checkBox3.Location = new System.Drawing.Point(18, 62);
            this.checkBox3.Name = "checkBox3";
            this.checkBox3.Size = new System.Drawing.Size(166, 16);
            this.checkBox3.TabIndex = 11;
            this.checkBox3.Text = "大文字と小文字を区別しない";
            this.checkBox3.UseVisualStyleBackColor = true;
            // 
            // checkBox1
            // 
            this.checkBox1.AutoSize = true;
            this.checkBox1.Location = new System.Drawing.Point(18, 18);
            this.checkBox1.Name = "checkBox1";
            this.checkBox1.Size = new System.Drawing.Size(106, 16);
            this.checkBox1.TabIndex = 9;
            this.checkBox1.Text = "正規表現で検索";
            this.checkBox1.UseVisualStyleBackColor = true;
            this.checkBox1.CheckedChanged += new System.EventHandler(this.checkBox1_CheckedChanged);
            // 
            // checkBox2
            // 
            this.checkBox2.AutoSize = true;
            this.checkBox2.Location = new System.Drawing.Point(18, 40);
            this.checkBox2.Name = "checkBox2";
            this.checkBox2.Size = new System.Drawing.Size(106, 16);
            this.checkBox2.TabIndex = 10;
            this.checkBox2.Text = "正規表現で置換";
            this.checkBox2.UseVisualStyleBackColor = true;
            this.checkBox2.CheckedChanged += new System.EventHandler(this.checkBox2_CheckedChanged);
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.BackColor = System.Drawing.Color.Transparent;
            this.label2.Location = new System.Drawing.Point(12, 49);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(87, 12);
            this.label2.TabIndex = 20;
            this.label2.Text = "置換後の文字列";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.BackColor = System.Drawing.Color.Transparent;
            this.label1.Location = new System.Drawing.Point(12, 10);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(84, 12);
            this.label1.TabIndex = 19;
            this.label1.Text = "検索する文字列";
            // 
            // button4
            // 
            this.button4.Location = new System.Drawing.Point(114, 260);
            this.button4.Name = "button4";
            this.button4.Size = new System.Drawing.Size(89, 24);
            this.button4.TabIndex = 18;
            this.button4.Text = "全て置換";
            this.button4.UseVisualStyleBackColor = true;
            this.button4.Click += new System.EventHandler(this.button4_Click);
            // 
            // button3
            // 
            this.button3.Location = new System.Drawing.Point(15, 260);
            this.button3.Name = "button3";
            this.button3.Size = new System.Drawing.Size(89, 24);
            this.button3.TabIndex = 17;
            this.button3.Text = "置換して次へ";
            this.button3.UseVisualStyleBackColor = true;
            this.button3.Click += new System.EventHandler(this.button3_Click);
            // 
            // button1
            // 
            this.button1.AutoSize = true;
            this.button1.Location = new System.Drawing.Point(14, 231);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(89, 24);
            this.button1.TabIndex = 16;
            this.button1.Text = "次を検索";
            this.button1.UseVisualStyleBackColor = true;
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // textBox2
            // 
            this.textBox2.Location = new System.Drawing.Point(14, 64);
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(189, 19);
            this.textBox2.TabIndex = 15;
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(14, 27);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(189, 19);
            this.textBox1.TabIndex = 14;
            this.textBox1.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
            this.textBox1.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBox1_KeyPress);
            // 
            // SearchAndReplaceExtension
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.BackColor = System.Drawing.SystemColors.Window;
            this.ClientSize = new System.Drawing.Size(220, 290);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.comboBox1);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.button4);
            this.Controls.Add(this.button3);
            this.Controls.Add(this.button1);
            this.Controls.Add(this.textBox2);
            this.Controls.Add(this.textBox1);
            this.KeyPreview = true;
            this.Name = "SearchAndReplaceExtension";
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        void SearchAndReplace_GotFocus(object sender, EventArgs e)
        {
            if (!Host.IsDocumentEmpty)
            {
                textBox1.Text = Host.SelectedTextInDocument;
            }
            textBox1.SelectAll();
            textBox1.Focus();
        }
        private void button1_Click(object sender, EventArgs e)
        {
            if (Host.IsDocumentEmpty) return;
            if (Searchtype == SearchType.InSelection)
            {
                if (selbegin == -1 && selend == -1)
                {
                    Range range = Host.SelectionInDocument;
                    selbegin = range.Start;
                    selend = range.End;
                    if (selbegin == selend)
                    {
                        MessageBox.Show(st5);
                        return;
                    }
                }
                if (selbegin == selend)
                {
                    MessageBox.Show(st5);
                    return;
                }
                searchinselection();
            }
            else
            {
                if (!search(Host.PresentDocument())) MessageBox.Show(st1);
            }
        }
        public bool searchinselection()
        {
            if (this.textBox1.Text != "")
            {
                Range selectionrange = Host.SelectionInDocument;
                if (selbegin == selectionrange.Start && selend == selectionrange.End) selectionrange.End = selectionrange.Start;
                Range searchrange = Search(this.textBox1.Text, selectionrange.End);
                if (!selectionrange.IsInvalid)
                {
                    if (selbegin <= searchrange.Start && searchrange.End <= selend)
                    {
                        Host.SelectionInDocument = searchrange;
                        Host.ScrollToCaret();
                    }
                    else
                    {
                        Host.SelectionInDocument = new Range(selbegin, selend);
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st1);
                        return false;
                    }
                }
                else
                {
                    Host.SelectionInDocument = new Range(selbegin, selend);
                    selbegin = -1;
                    selend = -1;
                    MessageBox.Show(st1);
                }
                return true;
            }
            else
            {
                MessageBox.Show(st3);
                return false;
            }
        }
        public bool search(object startexac)
        {
            if (this.textBox1.Text != "")
            {
                Range selectionrange = Host.SelectionInDocument;
                Range searchrange = Search(this.textBox1.Text, selectionrange.End);
                if (!searchrange.IsInvalid)
                {
                    Host.SelectionInDocument = searchrange;
                    Host.ScrollToCaret();
                }
                else
                {
                    //MessageBox.Show(st1);
                    if (Searchtype == SearchType.Current)
                    {
                        searchrange = Search(this.textBox1.Text, 0);
                        if (searchrange.IsInvalid)
                        {
                            return false;
                        }
                        else
                        {
                            Host.SelectionInDocument = searchrange;
                            Host.ScrollToCaret();
                        }
                    }
                    else if (Searchtype == SearchType.All)
                    {
                        object currentexac = null;
                        while ((currentexac = Host.NextDocument()) != null)
                        {
                            if (startexac == currentexac) return false;
                            searchrange = Search(this.textBox1.Text, 0);
                            if (searchrange.IsInvalid)
                            {
                                //MessageBox.Show(st1);
                            }
                            else
                            {
                                Host.SelectionInDocument = searchrange;
                                Host.ScrollToCaret();
                                this.button1.Focus();
                                break;
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                MessageBox.Show(st3);
                return false;
            }
        }
        public Range Search(string text, int end)
        {
            if (text == null || text == "") return Range.InvalidRange;
            Range range = Range.InvalidRange;
            if (!this.checkBox1.Checked)
            {
                range = Host.FindNext(this.textBox1.Text, end, IgnoreCase);
            }
            else
            {
                try
                {
                    range = Host.FindNext(new System.Text.RegularExpressions.Regex(this.textBox1.Text, IgnoreCase ? RegexOptions.IgnoreCase : RegexOptions.None), end);
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message);
                }
            }
            return range;
        }
        private void button3_Click(object sender, EventArgs e)
        {
            if (Host.IsDocumentEmpty) return;
            if (Searchtype == SearchType.InSelection)
            {
                bool ret = true;
                if (selbegin == -1 && selend == -1)
                {
                    Range tempr = Host.SelectionInDocument;
                    selbegin = tempr.Start;
                    selend = tempr.End;
                    if (selbegin == selend)
                    {
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st5);
                        return;
                    }
                    ret = searchinselection();
                }
                if (ret)
                {
                    Range selectionrange = Host.SelectionInDocument;
                    if (selectionrange.End - selectionrange.Start != 0)
                    {
                        int sub = 0;
                        if (this.checkBox2.Checked)
                        {
                            string selectionstring = Host.GetTextInRange(selectionrange);
                            selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                            Host.Replace(selectionstring);
                            sub = selectionstring.Length - (selectionrange.End - selectionrange.Start);
                        }
                        else
                        {
                            Host.Replace(this.textBox2.Text);
                            sub = this.textBox2.Text.Length - (selectionrange.End - selectionrange.Start);
                        }
                        selend += sub;
                    }
                    if (!searchinselection()) MessageBox.Show(st1);
                }
            }
            else
            {
                Host.MakeInvalidChange();
                Range selectionrange = Host.SelectionInDocument;
                if (selectionrange.End - selectionrange.Start != 0)
                {
                    if (this.checkBox2.Checked)
                    {
                        string selectionstring = Host.GetTextInRange(selectionrange);
                        selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                        Host.Replace(selectionstring);
                    }
                    else
                    {
                        Host.Replace(this.textBox2.Text);
                    }
                }
                Host.MakeValidChange();
                if (!search(Host.PresentDocument())) MessageBox.Show(st1);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (Host.IsDocumentEmpty) return;
            if (Searchtype == SearchType.InSelection)
            {
                if (selbegin == -1 && selend == -1)
                {
                    Range tempr = Host.SelectionInDocument;
                    selbegin = tempr.Start;
                    selend = tempr.End;
                    if (selbegin == selend)
                    {
                        selbegin = -1;
                        selend = -1;
                        MessageBox.Show(st5);
                        return;
                    }
                }
                if (selbegin == selend)
                {
                    selbegin = -1;
                    selend = -1;
                    MessageBox.Show(st5);
                    return;
                }
                int sub = 0;
                string selectedtext = Host.GetTextInRange(new Range(selbegin, selend));
                if (this.checkBox2.Checked)
                {
                    string temp = System.Text.RegularExpressions.Regex.Replace(selectedtext, this.textBox1.Text, this.textBox2.Text);
                    Host.Replace(temp, new Range(selbegin, selend));
                    sub = temp.Length - selectedtext.Length;
                }
                else
                {
                    string temp = selectedtext.Replace(this.textBox1.Text, this.textBox2.Text);
                    Host.Replace(temp, new Range(selbegin, selend));
                    sub = temp.Length - selectedtext.Length;
                }
                selend += sub;
                Host.SelectionInDocument = new Range(selbegin, selend);
                selbegin = -1;
                selend = -1;
            }
            else
            {
                object dc = Host.PresentDocument();
                Host.SelectionInDocument = new Range(0, 0);
                int replacecount = 0;
                while (search(dc))
                {
                    Range selectonrange = Host.SelectionInDocument;
                    if (selectonrange.End - selectonrange.Start != 0)
                    {
                        if (this.checkBox2.Checked)
                        {
                            string selectionstring = Host.GetTextInRange(selectonrange);
                            selectionstring = System.Text.RegularExpressions.Regex.Replace(selectionstring, this.textBox1.Text, this.textBox2.Text);
                            Host.Replace(selectionstring);
                        }
                        else
                        {
                            Host.Replace(this.textBox2.Text);
                        }
                    }
                    replacecount++;
                }
                if (replacecount == 0)
                {
                    MessageBox.Show(st1);
                }
                else
                {
                    MessageBox.Show(replacecount + st4);
                }
            }
        }
        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (this.checkBox2.Checked)
            {
                this.checkBox1.Checked = true;
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.checkBox1.Checked)
            {
                this.checkBox2.Checked = false;
            }
            UpdateWatchPatterns();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            selbegin = -1;
            selend = -1;
        }


        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                button1_Click(sender, e);
                e.Handled = true;
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            UpdateWatchPatterns();
        }

        void SearchAndReplaceExtension_VisibleChanged(object sender, EventArgs e)
        {
            if (!Visible)
            {
                Host.ClearIncrementalSearch();
            }
        }

        private void UpdateWatchPatterns()
        {
            if (String.IsNullOrEmpty(textBox1.Text))
            {
                Host.ClearIncrementalSearch();
                return;
            }

            Regex regex = null;
            if (checkBox1.Checked)
            {
                try
                {
                    regex = new Regex(textBox1.Text);
                }
                catch
                {

                }
            }
            else
            {
                regex = new Regex(Regex.Escape(textBox1.Text));
            }

            if (regex == null)
            {
                Host.ClearIncrementalSearch();
                return;
            }

            Host.SetIncrementalSearch(regex);
        }
    }
}
