﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;

namespace NT2chCtrl
{
    class ThreadHistoryUI
    {
        List<IThreadDescription> mThreadList;
        StackPanel mThreadHistoryPanel;
        Style mThreadButtonStyle;
        IUtil mUtil;
        ICommand mCommand;

        public ThreadHistoryUI(ICommand command, IUtil util, List<IThreadDescription> threadList,
            StackPanel panel)
        {
            if (panel == null || threadList == null)
                return;

            mUtil = util;
            mCommand = command;
            
            panel.Children.Clear();

            mThreadList = new List<IThreadDescription>();
            mThreadHistoryPanel = panel;

            mThreadButtonStyle = (Style)panel.TryFindResource("ThreadButton");

            int threadCount = threadList.Count;
            for (int i = threadCount - 1; i >= 0; i--)
            {
                AddButton(threadList[i]);
            }
            if (threadCount > 0)
                mCommand.OpenThread(threadList[0]);

        }
        public List<IThreadDescription> getCurrentList()
        {
            return mThreadList;
        }

        public void AddButton(IThread ithread)
        {
            ThreadDescriptionImple threadImpl = 
                ThreadDescriptionImple.createThreadDescription(ithread);
            if (threadImpl == null)
                return;

            IBoard board = ithread.getBoard();
            if (board != null)
            {
                string boardName = board.getName();
                if (boardName != null && boardName.Length > 0)
                    updateMenu(boardName);
            }

            AddButton(threadImpl);

        }

        public void UpdateButton(IBoard iboard)
        {
            //System.Diagnostics.Debug.WriteLine("AAA");
            if (iboard == null)
                return;
            foreach (UIElement ui in mThreadHistoryPanel.Children)
            {
                Button btn = ui as Button;
                if (btn == null)
                    continue;
                IThreadDescription desc =
                    btn.Tag as IThreadDescription;
                if (desc == null)
                    continue;

                IBoard ib = desc.getBoard();
                if (!iboard.getName().Equals(ib.getName()))
                    continue;

                IThread ithread = getIThread(ib, desc.getDatName());
                if (ithread == null)
                    continue;
                string title = ithread.getTitle();
                if (title != null)
                    btn.Content = title;
                /*foreach (IThread ithread in iboard.getThreadList())
                {
                    if (desc.getDatName().Equals(ithread.getDatName()))
                    {
                        string title = ithread.getTitle();
                        if (title != null)
                        {
                            //System.Diagnostics.Debug.WriteLine("Attached Title: "+ title);
                            btn.Content = title;
                        }
                        break;
                    }
                }*/
            }
        }

        private IThread getIThread(IBoard iboard, string datName)
        {
            foreach (IThread ithread in iboard.getThreadList())
            {
                if (datName.Equals(ithread.getDatName()))
                    return ithread;
            }
            return null;
        }

        private void AddButton(IThreadDescription thread)
        {
            if (thread == null)
                return;

            deleteThreadFromMenu(thread);

            string title =  thread.getTitle();

            if (mThreadList.Count == 50)
                mThreadList.RemoveAt(49);

            mThreadList.Insert(0,thread);

            Button button = new Button();
            if (title != null)
                button.Content = title;
            else
                button.Content = "Unknown thread title.";
            if(mThreadButtonStyle != null)
                button.Style = mThreadButtonStyle;

            button.Click += threadButton_Click;
            button.Tag = thread;
            ContextMenu cm = createButtonContextMenu(thread);
            if(cm != null)
                button.ContextMenu = cm;

            mThreadHistoryPanel.Children.Insert(0, button);

        }

        ContextMenu createButtonContextMenu(IThreadDescription thread)
        {
            ContextMenu cm = new ContextMenu();

            string title = thread.getTitle();
            if(title == null || title.Length == 0)
                title = "Unknown thread ti...";

            if (title.Length > 17)
                title = title.Substring(0, 17-3) + "...";


            MenuItem item = new MenuItem();
            item = new MenuItem();
            item.Header = title;
            cm.Items.Add(item);
            cm.Items.Add(new Separator());
            item = new MenuItem();
            item.Tag = thread;
            item.Header = "お気に入りに追加";
            item.Click += addThreadToFavorite_Click;
            cm.Items.Add(item);
            item = new MenuItem();
            item.Tag = thread;
            item.Header = "メニューから削除";
            item.Click += deleteThreadFromMenu_Click;
            cm.Items.Add(item);
            item = new MenuItem();
            item.Tag = thread;
            item.Header = "類似スレを検索";
            item.Click += searchSimularThreadMenu_Click;
            cm.Items.Add(item);
            item = new MenuItem();
            item.Tag = thread;
            item.Header = "アドレスを表示";
            item.Click += showThreadInfoMenu_Click;
            cm.Items.Add(item);
            cm.Items.Add(new Separator());
            item = new MenuItem();
            item.Tag = thread;
            item.Header = "このタブを閉じる";
            //item.Click += boardTabHeaderMenu_CloseThis_Click;
            cm.Items.Add(item);

            return cm;
        }

        void searchSimularThreadMenu_Click(object sender, RoutedEventArgs e)
        {
            MenuItem mi = sender as MenuItem;
            if (mi == null)
                return;

            IThreadDescription thread = mi.Tag as IThreadDescription;
            if (thread == null)
                return;
            IBoard iboard = thread.getBoard();
            if (iboard == null)
                return;

            IThread2 ithread = getIThread(iboard, thread.getDatName()) as IThread2;
            if (ithread != null)
            {
                ((ICommand2)mCommand).SearchSimilarTitle(ithread);
            }
            else
            {
                MessageBox.Show("スレッドの情報が見つかりません");
            }
        }

        void showThreadInfoMenu_Click(object sender, RoutedEventArgs e)
        {
            string title, address;

            MenuItem mi = sender as MenuItem;
            if (mi == null)
                return;

            IThreadDescription thread = mi.Tag as IThreadDescription;
            if (thread == null)
                return;
            IBoard iboard = thread.getBoard();
            if (iboard == null)
                return;
           
            title =  thread.getTitle();
            if (title == null || title.Length == 0)
            {
                IThread ithread = getIThread(iboard, thread.getDatName());
                if(ithread != null)
                    title = ithread.getTitle();
            }

            address = parse2chAddress(iboard.getAddress(), thread.getDatName());

            mCommand.ShowThreadInfoWindow(title, address);
        }
        void deleteThreadFromMenu_Click(object sender, RoutedEventArgs e)
        {
            MenuItem mi = sender as MenuItem;
            if (mi == null)
                return;

            IThreadDescription thread = mi.Tag as IThreadDescription;
            if (thread == null)
                return;

            deleteThreadFromMenu(thread);
        }

        void deleteThreadFromMenu(IThreadDescription thread)
        {
            int threadCnt = mThreadList.Count;

            for (int i = 0; i < threadCnt; i++)
            {
                IThreadDescription ithreadDecl = mThreadList[i];

                if (!(thread.getDatName().Equals(ithreadDecl.getDatName()) &&
                    thread.getBoard().getName().Equals(ithreadDecl.getBoard().getName())))
                    continue;
                mThreadList.RemoveAt(i);
                mThreadHistoryPanel.Children.RemoveAt(i);
                break;
            }


        }

        void updateMenu(string boardName)
        {
            if (boardName == null)
                return;

            int threadCnt = mThreadList.Count;

            for (int i = 0; i < threadCnt; i++)
            {
                IThreadDescription ithreadDecl = mThreadList[i];

                if (!boardName.Equals(ithreadDecl.getBoard().getName()))
                    continue;

                string title = ithreadDecl.getTitle();
                if (title == null || title.Length == 0)
                    continue;

                Button btn = mThreadHistoryPanel.Children[i] as Button;
                if(btn != null)
                    btn.Content = title;
             }


        }

        void addThreadToFavorite_Click(object sender, RoutedEventArgs e)
        {
            MenuItem mi = sender as MenuItem;
            if (mi == null)
                return;

            IThreadDescription thread = mi.Tag as IThreadDescription;
            if (thread == null)
                return;

            if (!mCommand.AddThreadToFavorite(thread))
                MessageBox.Show("追加できませんでした");
        }

        void threadButton_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;
            IThreadDescription thread = btn.Tag as IThreadDescription;
            if (thread == null)
                return;

            mCommand.OpenThread(thread);
        }
        string parse2chAddress(string address, string dat)
        {
            if (address == null)
                return string.Empty;

            int len = address.Length;
            if (len == 0)
                return string.Empty;

            string address1;
            string dat1;
            if (dat == null)
                dat1 = string.Empty;
            else
                dat1 = dat;


            int idx = address.IndexOf("machi.to");
            if (idx >= 0)
            {
                idx += "machi.to".Length;
                address1 = address.Substring(0, idx);
                address1 += "/bbs/read.cgi" + address.Substring(idx);
                idx = dat1.IndexOf(".cgi");
                if (idx >= 0)
                {
                    dat1 = dat.Substring(0, idx) + "/";
                }
            }
            else
            {
                idx = address.LastIndexOf('/', len - 2);
                if (idx <= 0)
                    return string.Empty;

                address1 = address.Substring(0, idx);
                address1 += "/test/read.cgi" + address.Substring(idx);
                idx = dat1.IndexOf(".dat");
                if (idx >= 0)
                {
                    dat1 = dat.Substring(0, idx) + "/";
                }
            }

            if (dat != null)
                address1 += dat1;

            return address1;
        }

    }
}
