﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.css
{
    public class cssFont
    {


        public static bool tryGetFontStyle(string source, out Property.FontStyle style)
        {
            int state = 0;
            int length = source.Length;
            //string s;
            style = Property.FontStyle.Normal;

            for (int i = 0; i < length; i++)
            {
                switch (HtmlParser.getCharToken(source[i]))
                {
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state != 0)
                            return false;
                        if (i == source.IndexOf("italic", i))
                        {
                            style  = Property.FontStyle.Italic;
                            state = 1;
                            i += 5;
                        }
                        else if (i == source.IndexOf("oblique", i))
                        {
                            style = Property.FontStyle.Oblique;
                            state = 1;
                            i += 6;
                        }
                        else if (i == source.IndexOf("normal", i))
                        {
                            state = 1;
                            i += 5;
                        }
                        else
                        {
                            return false;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        return false;
                    case HtmlParser.CHAR_TOKEN.NL:
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        switch (state)
                        {
                            case 0:
                                break;
                            case 1:
                                 return true;
                            default:
                                return false;
                        }
                        break;
                }
            }
            if (state == 1)
            {
                return true;
            }
            return false;
        }

        public static bool tryGetFontFamily(string source, out string fontFamily)
        {
            int state = 0;
            int length = source.Length;
            //string s;
            fontFamily = null;
            bool dquote = false;
            bool squote = false;
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < length; i++)
            {
                char c = source[i];
                switch (HtmlParser.getCharToken(c))
                {
                    case HtmlParser.CHAR_TOKEN.DQUOTE :
                        if (!squote)
                            dquote = !dquote;
                        else
                            sb.Append(c);
                        break;
                    case HtmlParser.CHAR_TOKEN.SQUOTE:
                        if(!dquote)
                            squote = !squote;
                        else
                            sb.Append(c);
                        break;
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                    case HtmlParser.CHAR_TOKEN.OTHER:
                        if (state == 0)
                            state = 1;
                        sb.Append(c);
                        break;
                    case HtmlParser.CHAR_TOKEN.COMMA:
                        if (state != 1)
                            return false;
                        sb.Append(c);
                        break;
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                    case HtmlParser.CHAR_TOKEN.NL:
                        if (state == 1)// && (dquote || squote))
                            sb.Append(c);
                        break;
                }
            }
            if (state == 1)
            {
                fontFamily = sb.ToString();
                return true;
            }
            return false;
        }

        public static bool tryGetFontWeight(string source, out int weight)
        {
            int state = 0;
            int length = source.Length;
            int textStart = 0;
            string s;
            int nVal;
            weight = 400;
            for (int i = 0; i < length; i++)
            {
                switch (HtmlParser.getCharToken(source[i]))
                {
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state != 0)
                            return false;
                        if (i == source.IndexOf("bold", i))
                        {
                            weight = 700;
                            state = 2;
                            i += 3;
                        }
                        else if (i == source.IndexOf("normal", i))
                        {
                            state = 2;
                            i += 5;
                        }
                        else
                        {
                            return false;
                        }
                        break;

                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        if (state == 0)
                        {
                            textStart = i;
                            state = 1;
                        }
                        else if (state != 1)
                        {
                            return false;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NL:
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        switch (state)
                        {
                            case 0:
                                break;
                            case 1:
                                s = source.Substring(textStart, i - textStart);
                                if (int.TryParse(s, out nVal))
                                {
                                    weight = nVal;
                                    return true;
                                }
                                return false;
                            case 2:
                                return true;
                            default:
                                return false;
                        }
                        break;
                }
            }
            if (state == 1)
            {
                s = source.Substring(textStart, length - textStart);
                if (int.TryParse(s, out nVal))
                {
                    weight = nVal;
                    return true;
                }
            }
            else if (state == 2)
            {
                return true;
            }
            return false;
        }
    }
}
