﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;

namespace NT2chView
{
    public class NTHistory
    {
        NTBoard.DelegateMsgOnNotifyBoardUpdate mOnNotifyBoardUpdate;

        private static string mStrState = string.Empty;
        public static string getLastState()
        {
            return mStrState;
        }
        public NTHistory()
        {
            mOnNotifyBoardUpdate 
                = new NTBoard.DelegateMsgOnNotifyBoardUpdate(OnNotifyBoardUpdate);
        }

        private ObservableCollection<NTHistoryThread> mThreadList = new ObservableCollection<NTHistoryThread>();
        public ObservableCollection<NTHistoryThread> getThreadList()
        {
            return mThreadList;
        }

        public void onDetach()
        {
            Dictionary<string, NTBoard> boardDic = new Dictionary<string,NTBoard>();
            foreach (NTHistoryThread ht in mThreadList)
            {
                if(boardDic.ContainsKey(ht.BoardName))
                    continue;
                NTBoard board = NTDataRoot.getBoardByName(ht.BoardName);
                if (board == null)
                    continue;
                boardDic.Add(ht.BoardName, board);
            }
            foreach (NTBoard board in boardDic.Values)
            {
                if(mOnNotifyBoardUpdate != null)
                    board.OnNotifyBoardUpdate -= mOnNotifyBoardUpdate;
            }

            mThreadList.Clear();
        }

        void OnNotifyBoardUpdate(NTBoard board)
        {
            if (mThreadList == null)
                return;

            foreach (NTHistoryThread ht in mThreadList)
            {
                if (board.mName.Equals(ht.BoardName))
                    ht.update(board);
            }

        }
        
 
        public bool parse(string source)
        {
            onDetach();

            if (source == null || source.Length == 0)
                return false;

            string[] lines = NTTextUtiles.splitLine(source);
            int lineLen = lines.Length;
            if (lineLen == 0)
                return false;
            int retVal;
            if (!int.TryParse(lines[0], out retVal))
                return false;
            
            if (lineLen == 1)
                return false;

            mStrState = lines[1];

            if (retVal != 100)
                return false;


            Dictionary<string, NTBoard> boardDic = new Dictionary<string, NTBoard>();

            for (int i = 2; i < lineLen; i++)
            {
                string line = lines[i];
                string[] values = line.Split(NTTextUtiles.COMMA_VALUE);
                if (values.Length != 3)
                    continue;

                string boardName;
                string datName;
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesDecodeBase64URL(values[0]);
                    datName = NTTextUtiles.aesDecodeBase64URL(values[1]);
                }
                else
                {
                    boardName = NTTextUtiles.decodeBase64URL(values[0]);
                    datName = NTTextUtiles.decodeBase64URL(values[1]);
                }
                string dateTimeDescription = values[2];

                NTHistoryThread ht = new NTHistoryThread(boardName, datName, dateTimeDescription);

                mThreadList.Add(ht);

                if (!boardDic.ContainsKey(boardName))
                {
                    NTBoard board = NTDataRoot.getBoardByName(boardName);
                    if (board != null)
                        boardDic.Add(boardName, board);
                }
            }

            foreach (NTBoard board in boardDic.Values)
            {
                if (board.mDataInit)
                {
                    OnNotifyBoardUpdate(board);
                }
                else
                {
                    board.Update(mOnNotifyBoardUpdate);
                }
            }

            return true;
        }
    }
}
