﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chCtrl;
using NT2chView;
using NT2chObject;

namespace NT2chHistory
{
    class NTThreadCashData : IThreadDescription
    {
	    //private const string UNKNOWN_TITLE_DESCRIPTION = "Unknown Title";
	    String mDatName;
	    String mBoardName;
        NTBoard mBoard;
	    String mTitle = null;
	    public NTThreadCashData(String boardName, String datName){
		    mBoardName = boardName;
            mBoard = NTDataRoot.getBoardByName(boardName);
		    mDatName = datName;
	    }
	    public String getDatName(){
		    return mDatName;
	    }
	    public String getBoardName(){
		    return mBoardName;
	    }
        public IBoard getBoard(){return mBoard;}
	    public String getTitle(){
		    return mTitle;// != null) ? mTitle : UNKNOWN_TITLE_DESCRIPTION;
	    }
	    public bool isTitleSet(){
		    return mTitle != null;
	    }
	    public void setTitle(String title){
		    mTitle = title;
	    }


	    public static string getDescription(IThreadDescription threadDecl){
		    StringBuilder sb = new StringBuilder();
            sb.Append(threadDecl.getDatName()).Append(',').Append(threadDecl.getBoard().getName());
		    return sb.ToString();
	    }
	
	    public static NTThreadCashData parse(String description){
		    int idx = description.IndexOf(',');
		    if(idx <= 0 || idx >= description.Length)
			    return null;

		    String datName = description.Substring(0, idx);
		    String boardName = description.Substring(idx+1);
            NTBoard board = NTDataRoot.getBoardByName(boardName);
            if (board == null)
                return null;

		    NTThreadCashData data = new NTThreadCashData(boardName, datName);

            NTThreadTitle tt =  board.findThreadTitleByDatName(datName);
            if (tt != null)
            {
                string title = tt.Title;
                if (title != null)
                    data.setTitle(title);
            }
            return data;
		
	    }

    }
}
