/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _DB_H_ 
#define _DB_H_ 

#include "env.h"

#ifdef HAVE_NDBM_H 
#include <ndbm.h>
#elif HAVE_GDBM_NDBM_H
#include <gdbm-ndbm.h>
#else
#include <ndbm.h>
#endif


#define LOG_DB_NAME "log_db"
#define LOG_DB_W_NAME L"log_db"
#define INDEX_DB_NAME "index_db"
#define INDEX_DB_W_NAME L"index_db"

#define DB_KEY_SIZE_MAX ((SHA_DIGEST_LENGTH)*2+2) 

typedef struct tag_nt_db_log_rec_t *nt_db_log_rec_tp;
typedef struct tag_nt_db_log_rec_t{
	int content_length;
	char last_modified[128];
} nt_db_log_rec_t;

typedef struct tag_nt_db_idx_rec_t *nt_db_idx_rec_tp;
typedef struct tag_nt_db_idx_rec_t{
} nt_db_idx_rec_t;

extern BOOL nt_db_cpy_key(const char *src, char *dst);
extern const char *nt_db_get_log_path();
extern const char *nt_db_get_idx_path();
#endif /* _DB_H_ */
